/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.view;

import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewBase;
import java.util.List;

public class GridViewItem
extends GridViewBase {
    public GridViewItem(GuiGrid gui, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        super(gui, defaultSorter, sorters);
    }

    @Override
    public void setStacks(List<IGridStack> stacks) {
        this.map.clear();
        for (IGridStack stack : stacks) {
            if (((GridStackItem)stack).doesDisplayCraftText() && this.map.containsKey(stack.getHash())) continue;
            this.map.put(stack.getHash(), stack);
        }
    }

    @Override
    public void postChange(IGridStack stack, int delta) {
        if (!(stack instanceof GridStackItem)) {
            return;
        }
        GridStackItem existing = (GridStackItem)this.map.get(stack.getHash());
        if (existing == null) {
            ((GridStackItem)stack).getStack().func_190920_e(delta);
            this.map.put(stack.getHash(), stack);
        } else {
            if (existing.getStack().func_190916_E() + delta <= 0) {
                if (existing.isCraftable()) {
                    existing.setDisplayCraftText(true);
                } else {
                    this.map.remove(existing.getHash());
                }
            } else if (existing.doesDisplayCraftText()) {
                existing.setDisplayCraftText(false);
                existing.getStack().func_190920_e(delta);
            } else {
                existing.getStack().func_190917_f(delta);
            }
            existing.setTrackerEntry(stack.getTrackerEntry());
        }
    }
}

