/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid;

import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.api.network.grid.GridType;
import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.api.network.grid.IGridTab;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeGrid;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSearchBoxMode;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSize;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSortingDirection;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSortingType;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridViewType;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.gui.control.TextFieldSearch;
import com.raoulvdberge.refinedstorage.gui.grid.GuiCraftingStart;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterID;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterInventoryTweaks;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterLastModified;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterName;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.GridSorterQuantity;
import com.raoulvdberge.refinedstorage.gui.grid.sorting.IGridSorter;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewFluid;
import com.raoulvdberge.refinedstorage.gui.grid.view.GridViewItem;
import com.raoulvdberge.refinedstorage.gui.grid.view.IGridView;
import com.raoulvdberge.refinedstorage.integration.jei.IntegrationJEI;
import com.raoulvdberge.refinedstorage.integration.jei.RSJEIPlugin;
import com.raoulvdberge.refinedstorage.network.MessageGridClear;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidInsertHeld;
import com.raoulvdberge.refinedstorage.network.MessageGridFluidPull;
import com.raoulvdberge.refinedstorage.network.MessageGridItemInsertHeld;
import com.raoulvdberge.refinedstorage.network.MessageGridItemPull;
import com.raoulvdberge.refinedstorage.network.MessageGridPatternCreate;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.TilePortableGrid;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.TimeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiGrid
extends GuiBase
implements IResizableDisplay {
    private IGridView view;
    private TextFieldSearch searchField;
    private GuiCheckBox oredictPattern;
    private GuiCheckBox processingPattern;
    private GuiCheckBox blockingPattern;
    private GuiButton tabPageLeft;
    private GuiButton tabPageRight;
    private IGrid grid;
    private boolean wasConnected;
    private boolean hadTabs = false;
    private int tabHovering = -1;
    private int slotNumber;

    public GuiGrid(ContainerGrid container, IGrid grid) {
        super(container, grid.getType() == GridType.FLUID ? 193 : 227, 0);
        LinkedList<IGridSorter> sorters = new LinkedList<IGridSorter>();
        GridSorterName defaultSorter = new GridSorterName();
        sorters.add(defaultSorter);
        sorters.add(new GridSorterQuantity());
        sorters.add(new GridSorterID());
        sorters.add(new GridSorterInventoryTweaks());
        sorters.add(new GridSorterLastModified());
        this.grid = grid;
        this.view = grid.getType() == GridType.FLUID ? new GridViewFluid(this, defaultSorter, sorters) : new GridViewItem(this, defaultSorter, sorters);
        this.wasConnected = this.grid.isActive();
    }

    @Override
    protected void calcHeight() {
        this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
        if (this.hadTabs) {
            this.field_147000_g += 31;
        }
        this.screenHeight = this.field_147000_g;
    }

    @Override
    public void init(int x, int y) {
        ((ContainerGrid)this.field_147002_h).initSlots();
        this.scrollbar = new Scrollbar(174, this.getTabHeight() + this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        if (this.grid instanceof NetworkNodeGrid || this.grid instanceof TilePortableGrid) {
            this.addSideButton(new SideButtonRedstoneMode(this, this.grid instanceof NetworkNodeGrid ? TileGrid.REDSTONE_MODE : TilePortableGrid.REDSTONE_MODE));
        }
        this.tabPageLeft = this.addButton(this.getGuiLeft(), this.getGuiTop() - 22, 20, 20, "<", true, this.grid.getTotalTabPages() > 0);
        this.tabPageRight = this.addButton(this.getGuiLeft() + this.getXSize() - 22 - 32, this.getGuiTop() - 22, 20, 20, ">", true, this.grid.getTotalTabPages() > 0);
        int sx = x + 80 + 1;
        int sy = y + 6 + 1 + this.getTabHeight();
        if (this.searchField == null) {
            this.searchField = new TextFieldSearch(0, this.field_146289_q, sx, sy, 82);
            this.searchField.addListener(() -> {
                this.view.sort();
                this.updateJEI();
            });
            this.updateSearchFieldFocus(this.grid.getSearchBoxMode());
        } else {
            this.searchField.field_146209_f = sx;
            this.searchField.field_146210_g = sy;
        }
        if (this.grid.getType() == GridType.PATTERN) {
            this.processingPattern = this.addCheckBox(x + 7, y + this.getTabHeight() + this.getTopHeight() + this.getVisibleRows() * 18 + 60, GuiGrid.t("misc.refinedstorage:processing", new Object[0]), TileGrid.PROCESSING_PATTERN.getValue());
            this.oredictPattern = this.addCheckBox(this.processingPattern.field_146128_h + this.processingPattern.field_146120_f + 5, y + this.getTabHeight() + this.getTopHeight() + this.getVisibleRows() * 18 + 60, GuiGrid.t("misc.refinedstorage:oredict", new Object[0]), TileGrid.OREDICT_PATTERN.getValue());
            if (((NetworkNodeGrid)this.grid).isProcessingPattern()) {
                this.blockingPattern = this.addCheckBox(this.oredictPattern.field_146128_h + this.oredictPattern.field_146120_f + 5, y + this.getTabHeight() + this.getTopHeight() + this.getVisibleRows() * 18 + 60, GuiGrid.t("misc.refinedstorage:blocking", new Object[0]), TileGrid.BLOCKING_PATTERN.getValue());
            }
        }
        if (this.grid.getType() != GridType.FLUID && this.grid.getViewType() != -1) {
            this.addSideButton(new SideButtonGridViewType(this, this.grid));
        }
        this.addSideButton(new SideButtonGridSortingDirection(this, this.grid));
        this.addSideButton(new SideButtonGridSortingType(this, this.grid));
        this.addSideButton(new SideButtonGridSearchBoxMode(this));
        this.addSideButton(new SideButtonGridSize(this, () -> this.grid.getSize(), size -> this.grid.onSizeChanged((int)size)));
        this.updateScrollbarAndTabs();
    }

    @Override
    protected int getSideButtonYStart() {
        return super.getSideButtonYStart() + (!this.grid.getTabs().isEmpty() ? 28 : 0);
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public IGridView getView() {
        return this.view;
    }

    @Override
    public void update(int x, int y) {
        boolean hasTabs;
        if (this.wasConnected != this.grid.isActive()) {
            this.wasConnected = this.grid.isActive();
            this.view.sort();
        }
        boolean bl = hasTabs = !this.getGrid().getTabs().isEmpty();
        if (this.hadTabs != hasTabs) {
            this.hadTabs = hasTabs;
            this.func_73866_w_();
        }
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        if (this.grid.getType() == GridType.CRAFTING) {
            return 156;
        }
        if (this.grid.getType() == GridType.PATTERN) {
            return 169;
        }
        return 99;
    }

    @Override
    public int getYPlayerInventory() {
        int yp = this.getTabHeight() + this.getTopHeight() + this.getVisibleRows() * 18;
        if (this.grid.getType() == GridType.NORMAL || this.grid.getType() == GridType.FLUID) {
            yp += 16;
        } else if (this.grid.getType() == GridType.CRAFTING) {
            yp += 73;
        } else if (this.grid.getType() == GridType.PATTERN) {
            yp += 86;
        }
        return yp;
    }

    @Override
    public int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.view.getStacks().size() / 9.0f));
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField == null ? "" : this.searchField.func_146179_b();
    }

    @Override
    public int getVisibleRows() {
        switch (this.grid.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.field_146295_m - this.getTopHeight() - this.getBottomHeight() - (this.hadTabs ? 31 : 0);
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.INSTANCE.config.maxRowsStretch));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    public boolean isOverSlotWithStack() {
        return this.grid.isActive() && this.isOverSlot() && this.slotNumber < this.view.getStacks().size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    public boolean isOverSlotArea(int mouseX, int mouseY) {
        return this.inBounds(7, 19 + this.getTabHeight(), 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    private boolean isOverClear(int mouseX, int mouseY) {
        int y = this.getTabHeight() + this.getTopHeight() + this.getVisibleRows() * 18 + 4;
        switch (this.grid.getType()) {
            case CRAFTING: {
                return this.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
            case PATTERN: {
                if (((NetworkNodeGrid)this.grid).isProcessingPattern()) {
                    return this.inBounds(154, y, 7, 7, mouseX, mouseY);
                }
                return this.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean isOverCreatePattern(int mouseX, int mouseY) {
        return this.grid.getType() == GridType.PATTERN && this.inBounds(172, this.getTabHeight() + this.getTopHeight() + this.getVisibleRows() * 18 + 22, 16, 16, mouseX, mouseY) && ((NetworkNodeGrid)this.grid).canCreatePattern();
    }

    private int getTabHeight() {
        return !this.grid.getTabs().isEmpty() ? 27 : 0;
    }

    private void drawTab(IGridTab tab, boolean foregroundLayer, int x, int y, int mouseX, int mouseY, int index, int num) {
        int uvx;
        boolean selected;
        boolean bl = selected = index == this.grid.getTabSelected();
        if (foregroundLayer && !selected || !foregroundLayer && selected) {
            return;
        }
        int tx = x + 29 * num;
        int ty = y;
        this.bindTexture("icons.png");
        if (!selected) {
            ty += 3;
        }
        int uvy = 225;
        int tbw = 28;
        int otx = tx--;
        if (selected) {
            uvx = 227;
            if (num > 0) {
                uvx = 226;
                uvy = 194;
                ++tbw;
            }
        } else {
            uvx = 199;
        }
        this.drawTexture(tx, ty, uvx, uvy, tbw, 31);
        RenderHelper.func_74520_c();
        this.drawItem(otx + 6, ty + 9 - (!selected ? 3 : 0), tab.getIcon());
        if (this.inBounds(tx, ty, 28, 31 - (selected ? 2 : 7), mouseX, mouseY)) {
            this.tabHovering = index;
        }
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        int i;
        this.tabHovering = -1;
        int j = 0;
        for (int i2 = this.grid.getTabPage() * 6; i2 < this.grid.getTabPage() * 6 + 6; ++i2) {
            if (i2 >= this.grid.getTabs().size()) continue;
            this.drawTab(this.grid.getTabs().get(i2), false, x, y, mouseX, mouseY, i2, j++);
        }
        if (this.grid.getType() == GridType.CRAFTING) {
            this.bindTexture("gui/crafting_grid.png");
        } else if (this.grid.getType() == GridType.PATTERN) {
            this.bindTexture("gui/pattern_grid" + (((NetworkNodeGrid)this.grid).isProcessingPattern() ? "_processing" : "") + ".png");
        } else if (this.grid instanceof IPortableGrid) {
            this.bindTexture("gui/portable_grid.png");
        } else {
            this.bindTexture("gui/grid.png");
        }
        int yy = y + this.getTabHeight();
        this.drawTexture(x, yy, 0, 0, this.screenWidth - (this.grid.getType() != GridType.FLUID ? 34 : 0), this.getTopHeight());
        if (this.grid.getType() != GridType.FLUID) {
            this.drawTexture(x + this.screenWidth - 34 + 4, y + this.getTabHeight(), 197, 0, 30, this.grid instanceof IPortableGrid ? 114 : 82);
        }
        int rows = this.getVisibleRows();
        for (i = 0; i < rows; ++i) {
            this.drawTexture(x, yy += 18, 0, this.getTopHeight() + (i > 0 ? (i == rows - 1 ? 36 : 18) : 0), this.screenWidth - (this.grid.getType() != GridType.FLUID ? 34 : 0), 18);
        }
        this.drawTexture(x, yy += 18, 0, this.getTopHeight() + 54, this.screenWidth - (this.grid.getType() != GridType.FLUID ? 34 : 0), this.getBottomHeight());
        if (this.grid.getType() == GridType.PATTERN) {
            int ty = 0;
            if (this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
                ty = 1;
            }
            if (!((NetworkNodeGrid)this.grid).canCreatePattern()) {
                ty = 2;
            }
            this.drawTexture(x + 172, y + this.getTabHeight() + this.getTopHeight() + this.getVisibleRows() * 18 + 22, 240, ty * 16, 16, 16);
        }
        j = 0;
        for (i = this.grid.getTabPage() * 6; i < this.grid.getTabPage() * 6 + 6; ++i) {
            if (i >= this.grid.getTabs().size()) continue;
            this.drawTab(this.grid.getTabs().get(i), true, x, y, mouseX, mouseY, i, j++);
        }
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7 + this.getTabHeight(), GuiGrid.t(this.grid.getGuiTitle(), new Object[0]));
        this.drawString(7, this.getYPlayerInventory() - 12, GuiGrid.t("container.inventory", new Object[0]));
        if (this.grid.getTotalTabPages() > 0) {
            String text = this.grid.getTabPage() + 1 + " / " + (this.grid.getTotalTabPages() + 1);
            this.drawString((int)((193.0f - (float)this.field_146289_q.func_78256_a(text)) / 2.0f), -16, text, 0xFFFFFF);
        }
        int x = 8;
        int y = 19 + this.getTabHeight();
        this.slotNumber = -1;
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 9 : 0;
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isActive()) {
                this.slotNumber = slot;
            }
            if (slot < this.view.getStacks().size()) {
                this.view.getStacks().get(slot).draw(this, x, y);
            }
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isActive()) {
                int color = this.grid.isActive() ? -2130706433 : -10790053;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                this.field_73735_i = 190.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(x, y, x + 16, y + 16, color, color);
                this.field_73735_i = 0.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverSlotWithStack()) {
            this.drawGridTooltip(this.view.getStacks().get(this.slotNumber), mouseX, mouseY);
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiGrid.t("misc.refinedstorage:clear", new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiGrid.t("gui.refinedstorage:grid.pattern_create", new Object[0]));
        }
        if (this.tabHovering >= 0 && this.tabHovering < this.grid.getTabs().size() && !this.grid.getTabs().get(this.tabHovering).getName().equalsIgnoreCase("")) {
            this.drawTooltip(mouseX, mouseY, this.grid.getTabs().get(this.tabHovering).getName());
        }
    }

    public void drawGridTooltip(IGridStack gridStack, int mouseX, int mouseY) {
        ItemStack stack;
        ArrayList textLines = Lists.newArrayList((Object[])gridStack.getTooltip().split("\n"));
        if (RS.INSTANCE.config.detailedTooltip) {
            if (!(gridStack instanceof GridStackItem) || !((GridStackItem)gridStack).doesDisplayCraftText()) {
                textLines.add("");
            }
            if (gridStack.getTrackerEntry() != null) {
                textLines.add("");
            }
        }
        ItemStack itemStack = stack = gridStack instanceof GridStackItem ? ((GridStackItem)gridStack).getStack() : ItemStack.field_190927_a;
        if (!textLines.isEmpty()) {
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, (List)textLines, mouseX, mouseY, this.screenWidth, this.screenHeight, -1, this.field_146289_q);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            this.screenWidth = event.getScreenWidth();
            this.screenHeight = event.getScreenHeight();
            FontRenderer font = event.getFontRenderer();
            float textScale = font.func_82883_a() ? 1.0f : 0.7f;
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            if (RS.INSTANCE.config.detailedTooltip) {
                int size;
                if (!(gridStack instanceof GridStackItem && ((GridStackItem)gridStack).doesDisplayCraftText() || (size = (int)((float)font.func_78256_a(I18n.func_135052_a((String)"misc.refinedstorage:total", (Object[])new Object[]{gridStack.getFormattedFullQuantity()})) * textScale)) <= tooltipTextWidth)) {
                    tooltipTextWidth = size;
                }
                if (gridStack.getTrackerEntry() != null && (size = (int)((float)font.func_78256_a(TimeUtils.getAgo(gridStack.getTrackerEntry().getTime(), gridStack.getTrackerEntry().getName())) * textScale)) > tooltipTextWidth) {
                    tooltipTextWidth = size;
                }
            }
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY + tooltipHeight + 6 > this.screenHeight) {
                tooltipY = this.screenHeight - tooltipHeight - 6;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)-267386864, (int)-267386864);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = 1344798847;
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)0x505000FF, (int)1344798847);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)0x505000FF, (int)0x505000FF);
            GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)1344798847, (int)1344798847);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, (List)textLines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, (List)textLines, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            if (RS.INSTANCE.config.detailedTooltip) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)1.0f);
                if (!(gridStack instanceof GridStackItem) || !((GridStackItem)gridStack).doesDisplayCraftText()) {
                    font.func_175063_a(TextFormatting.GRAY + I18n.func_135052_a((String)"misc.refinedstorage:total", (Object[])new Object[]{gridStack.getFormattedFullQuantity()}), (float)RenderUtils.getOffsetOnScale(tooltipX, textScale), (float)RenderUtils.getOffsetOnScale(tooltipTop + tooltipHeight - (gridStack.getTrackerEntry() != null ? 15 : 6) - (font.func_82883_a() ? 2 : 0), textScale), -1);
                }
                if (gridStack.getTrackerEntry() != null) {
                    font.func_175063_a(TextFormatting.GRAY + TimeUtils.getAgo(gridStack.getTrackerEntry().getTime(), gridStack.getTrackerEntry().getName()), (float)RenderUtils.getOffsetOnScale(tooltipX, textScale), (float)RenderUtils.getOffsetOnScale(tooltipTop + tooltipHeight - 6 - (font.func_82883_a() ? 2 : 0), textScale), -1);
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.oredictPattern) {
            TileDataManager.setParameter(TileGrid.OREDICT_PATTERN, this.oredictPattern.isChecked());
        } else if (button == this.blockingPattern) {
            TileDataManager.setParameter(TileGrid.BLOCKING_PATTERN, this.blockingPattern.isChecked());
        } else if (button == this.processingPattern) {
            TileGrid.PROCESSING_PATTERN.setValue(false, this.processingPattern.isChecked());
            ((ContainerGrid)this.field_147002_h).initSlots();
            TileDataManager.setParameter(TileGrid.PROCESSING_PATTERN, this.processingPattern.isChecked());
        } else if (button == this.tabPageLeft) {
            this.grid.onTabPageChanged(this.grid.getTabPage() - 1);
        } else if (button == this.tabPageRight) {
            this.grid.onTabPageChanged(this.grid.getTabPage() + 1);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int clickedButton) throws IOException {
        boolean clickedCreatePattern;
        super.func_73864_a(mouseX, mouseY, clickedButton);
        if (this.tabHovering >= 0 && this.tabHovering < this.grid.getTabs().size()) {
            this.grid.onTabSelectionChanged(this.tabHovering);
        }
        if (this.searchField != null) {
            this.searchField.func_146192_a(mouseX, mouseY, clickedButton);
        }
        boolean clickedClear = clickedButton == 0 && this.isOverClear(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        boolean bl = clickedCreatePattern = clickedButton == 0 && this.isOverCreatePattern(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (clickedCreatePattern) {
            BlockPos gridPos = ((NetworkNodeGrid)this.grid).getPos();
            RS.INSTANCE.network.sendToServer((IMessage)new MessageGridPatternCreate(gridPos.func_177958_n(), gridPos.func_177956_o(), gridPos.func_177952_p()));
        } else if (this.grid.isActive()) {
            if (clickedClear) {
                RS.INSTANCE.network.sendToServer((IMessage)new MessageGridClear());
            }
            ItemStack held = ((ContainerGrid)this.field_147002_h).getPlayer().field_71071_by.func_70445_o();
            if (this.isOverSlotArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r) && !held.func_190926_b() && (clickedButton == 0 || clickedButton == 1)) {
                RS.INSTANCE.network.sendToServer((IMessage)(this.grid.getType() == GridType.FLUID ? new MessageGridFluidInsertHeld() : new MessageGridItemInsertHeld(clickedButton == 1)));
            }
            if (this.isOverSlotWithStack()) {
                if (this.grid.getType() != GridType.FLUID && (held.func_190926_b() || !held.func_190926_b() && clickedButton == 2)) {
                    GridStackItem stack = (GridStackItem)this.view.getStacks().get(this.slotNumber);
                    if (stack.isCraftable() && (stack.doesDisplayCraftText() || GuiScreen.func_146272_n() && GuiScreen.func_146271_m()) && this.view.canCraft()) {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiCraftingStart(this, ((ContainerGrid)this.field_147002_h).getPlayer(), stack));
                    } else {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GuiScreen.func_146272_n()) {
                            flags |= 4;
                        }
                        if (clickedButton == 2) {
                            flags |= 2;
                        }
                        RS.INSTANCE.network.sendToServer((IMessage)new MessageGridItemPull(stack.getHash(), flags));
                    }
                } else if (this.grid.getType() == GridType.FLUID && held.func_190926_b()) {
                    RS.INSTANCE.network.sendToServer((IMessage)new MessageGridFluidPull(this.view.getStacks().get(this.slotNumber).getHash(), GuiScreen.func_146272_n()));
                }
            }
        }
        if (clickedClear || clickedCreatePattern) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (this.searchField == null) {
            return;
        }
        if (!this.func_146983_a(keyCode)) {
            if (this.searchField.func_146201_a(character, keyCode)) {
                this.updateJEI();
                this.view.sort();
                this.keyHandled = true;
            } else if (keyCode == RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX.func_151463_i()) {
                RS.INSTANCE.network.sendToServer((IMessage)new MessageGridClear());
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    private void updateJEI() {
        if (IntegrationJEI.isLoaded() && (this.grid.getSearchBoxMode() == 2 || this.grid.getSearchBoxMode() == 3)) {
            RSJEIPlugin.INSTANCE.getRuntime().getIngredientFilter().setFilterText(this.searchField.func_146179_b());
        }
    }

    public void updateSearchFieldFocus(int mode) {
        if (this.searchField != null) {
            this.searchField.func_146205_d(!IGrid.isSearchBoxModeWithAutoselection(mode));
            this.searchField.func_146195_b(IGrid.isSearchBoxModeWithAutoselection(mode));
        }
    }

    public GuiTextField getSearchField() {
        return this.searchField;
    }

    public void updateOredictPattern(boolean checked) {
        if (this.oredictPattern != null) {
            this.oredictPattern.setIsChecked(checked);
        }
    }

    public void updateBlockingPattern(boolean checked) {
        if (this.blockingPattern != null) {
            this.blockingPattern.setIsChecked(checked);
        }
    }

    public void updateScrollbarAndTabs() {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
            this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
        }
        if (this.tabPageLeft != null) {
            boolean bl = this.tabPageLeft.field_146125_m = this.grid.getTotalTabPages() > 0;
        }
        if (this.tabPageRight != null) {
            this.tabPageRight.field_146125_m = this.grid.getTotalTabPages() > 0;
        }
    }

    public GuiButton getTabPageLeft() {
        return this.tabPageLeft;
    }

    public GuiButton getTabPageRight() {
        return this.tabPageRight;
    }
}

