/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiReaderWriter;
import com.raoulvdberge.refinedstorage.container.ContainerReaderWriter;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.network.MessageReaderWriterChannelAdd;
import com.raoulvdberge.refinedstorage.network.MessageReaderWriterChannelRemove;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiReaderWriter
extends GuiBase {
    private static final int VISIBLE_ROWS = 4;
    private static final int ITEM_WIDTH = 143;
    private static final int ITEM_HEIGHT = 18;
    private List<String> channels = Collections.emptyList();
    private GuiButton add;
    private GuiButton remove;
    private GuiTextField name;
    private IGuiReaderWriter readerWriter;
    private int itemSelected = -1;
    private int itemSelectedX = -1;
    private int itemSelectedY = -1;

    public GuiReaderWriter(ContainerReaderWriter container, IGuiReaderWriter readerWriter) {
        super(container, 176, 209);
        this.readerWriter = readerWriter;
        this.scrollbar = new Scrollbar(157, 39, 12, 71);
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(this, this.readerWriter.getRedstoneModeParameter()));
        this.add = this.addButton(x + 128, y + 15, 20, 20, "+");
        this.remove = this.addButton(x + 150, y + 15, 20, 20, "-");
        this.name = new GuiTextField(0, this.field_146289_q, x + 8 + 1, y + 20 + 1, 107, this.field_146289_q.field_78288_b);
        this.name.func_146185_a(false);
        this.name.func_146189_e(true);
        this.name.func_146193_g(0xFFFFFF);
        this.name.func_146205_d(true);
        this.name.func_146195_b(false);
        this.updateSelection(this.readerWriter.getChannelParameter().getValue());
    }

    private List<String> getChannels() {
        return this.readerWriter.isActive() ? this.channels : Collections.emptyList();
    }

    public void setChannels(List<String> channels) {
        this.channels = channels;
    }

    @Override
    public void update(int x, int y) {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 4);
            this.scrollbar.setMaxOffset(this.getRows() - 4);
        }
        if (this.itemSelected >= this.getChannels().size()) {
            this.itemSelected = -1;
        }
    }

    private int getRows() {
        return this.getChannels().size();
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/readerwriter.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        if (this.itemSelectedX != -1 && this.itemSelectedY != -1 && this.itemSelected >= 0 && this.itemSelected < this.getChannels().size()) {
            this.drawTexture(x + this.itemSelectedX, y + this.itemSelectedY, 0, 216, 143, 18);
        }
        this.name.func_146194_f();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiReaderWriter.t(this.readerWriter.getTitle(), new Object[0]));
        this.drawString(7, 115, GuiReaderWriter.t("container.inventory", new Object[0]));
        int x = 8;
        int y = 39;
        int item = this.scrollbar != null ? this.scrollbar.getOffset() : 0;
        float scale = this.field_146289_q.func_82883_a() ? 1.0f : 0.5f;
        for (int i = 0; i < 4; ++i) {
            if (item < this.getChannels().size()) {
                if (item == this.itemSelected) {
                    this.itemSelectedX = x;
                    this.itemSelectedY = y;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
                this.drawString(RenderUtils.getOffsetOnScale(x + 5, scale), RenderUtils.getOffsetOnScale(y + 7, scale), this.getChannels().get(item));
                GlStateManager.func_179121_F();
                y += 18;
            }
            ++item;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.name.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.inBounds(8, 39, 144, 73, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            if (mouseButton == 0) {
                int item = this.scrollbar != null ? this.scrollbar.getOffset() : 0;
                for (int i = 0; i < 4; ++i) {
                    int ix = 8;
                    int iy = 39 + i * 18;
                    if (!this.inBounds(ix, iy, 143, 18, mouseX - this.field_147003_i, mouseY - this.field_147009_r) || item + i >= this.getChannels().size()) continue;
                    this.itemSelected = item + i;
                    TileDataManager.setParameter(this.readerWriter.getChannelParameter(), this.getChannels().get(this.itemSelected));
                }
            } else if (this.itemSelected != -1) {
                TileDataManager.setParameter(this.readerWriter.getChannelParameter(), "");
            }
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (keyCode == 211) {
            this.onRemove();
        } else if (this.name.func_146206_l() && keyCode == 28) {
            this.onAdd();
        } else if (this.func_146983_a(keyCode) || !this.name.func_146201_a(character, keyCode)) {
            super.func_73869_a(character, keyCode);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.add) {
            this.onAdd();
        } else if (button == this.remove) {
            this.onRemove();
        }
    }

    private void onAdd() {
        String name = this.name.func_146179_b().trim();
        if (!name.isEmpty()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageReaderWriterChannelAdd(name));
        }
    }

    private void onRemove() {
        String name = this.name.func_146179_b().trim();
        if (!name.isEmpty()) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageReaderWriterChannelRemove(name));
        }
    }

    public void updateSelection(String channel) {
        this.itemSelected = this.getChannels().indexOf(channel);
        this.name.func_146180_a(this.itemSelected != -1 ? this.getChannels().get(this.itemSelected) : "");
    }
}

