/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeCrafterManager;
import com.raoulvdberge.refinedstorage.container.ContainerCrafterManager;
import com.raoulvdberge.refinedstorage.container.slot.SlotCrafterManager;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonGridSize;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.gui.control.TextFieldSearch;
import com.raoulvdberge.refinedstorage.tile.TileCrafterManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class GuiCrafterManager
extends GuiBase
implements IResizableDisplay {
    private ContainerCrafterManager container;
    private NetworkNodeCrafterManager crafterManager;
    private TextFieldSearch searchField;

    public GuiCrafterManager(NetworkNodeCrafterManager crafterManager) {
        super(null, 193, 0);
        this.crafterManager = crafterManager;
    }

    public void setContainer(ContainerCrafterManager container) {
        this.container = container;
        this.field_147002_h = container;
    }

    @Override
    protected void calcHeight() {
        super.calcHeight();
        this.screenHeight = this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        return 99;
    }

    @Override
    public int getVisibleRows() {
        switch (this.crafterManager.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.field_146295_m - this.getTopHeight() - this.getBottomHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.INSTANCE.config.maxRowsStretch));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    @Override
    public int getRows() {
        return this.container == null || !this.crafterManager.isActive() ? 0 : this.container.getRows();
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar == null ? 0 : this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField == null ? "" : this.searchField.func_146179_b();
    }

    @Override
    public int getYPlayerInventory() {
        return this.getTopHeight() + this.getVisibleRows() * 18 + 16;
    }

    @Override
    public void init(int x, int y) {
        this.addSideButton(new SideButtonRedstoneMode(this, TileCrafterManager.REDSTONE_MODE));
        this.addSideButton(new SideButtonGridSize(this, () -> this.crafterManager.getSize(), size -> TileDataManager.setParameter(TileCrafterManager.SIZE, size)));
        this.scrollbar = new Scrollbar(174, this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        this.scrollbar.addListener((oldOffset, newOffset) -> {
            if (this.container != null) {
                this.container.initSlots(null);
            }
        });
        this.container.initSlots(null);
        int sx = x + 97 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new TextFieldSearch(0, this.field_146289_q, sx, sy, 82);
            this.searchField.addListener(() -> this.container.initSlots(null));
        } else {
            this.searchField.field_146209_f = sx;
            this.searchField.field_146210_g = sy;
        }
    }

    @Override
    public void update(int x, int y) {
        this.scrollbar.setEnabled(this.getRows() - 1 >= this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafter_manager.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.getTopHeight());
        int rows = this.getVisibleRows();
        int yy = y;
        for (int i = 0; i < rows; ++i) {
            this.drawTexture(x, yy += 18, 0, this.getTopHeight() + (i > 0 ? (i == rows - 1 ? 36 : 18) : 0), this.screenWidth, 18);
        }
        this.drawTexture(x, yy += 18, 0, this.getTopHeight() + 54, this.screenWidth, this.getBottomHeight());
        if (this.container != null && this.crafterManager.isActive()) {
            for (Slot slot : this.container.field_75151_b) {
                if (!(slot instanceof SlotCrafterManager) || !slot.func_111238_b()) continue;
                this.drawTexture(x + slot.field_75223_e - 1, y + slot.field_75221_f - 1, 0, 193, 18, 18);
            }
        }
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int clickedButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, clickedButton);
        if (this.searchField != null) {
            this.searchField.func_146192_a(mouseX, mouseY, clickedButton);
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (this.searchField == null) {
            return;
        }
        if (!this.func_146983_a(keyCode)) {
            if (this.searchField.func_146201_a(character, keyCode)) {
                this.container.initSlots(null);
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiCrafterManager.t("gui.refinedstorage:crafter_manager", new Object[0]));
        this.drawString(7, this.getYPlayerInventory() - 12, GuiCrafterManager.t("container.inventory", new Object[0]));
        if (this.container != null && this.crafterManager.isActive()) {
            for (Map.Entry<String, Integer> heading : this.container.getHeadings().entrySet()) {
                int y = heading.getValue();
                if (y < this.getTopHeight() - 1 || y >= this.getTopHeight() + this.getVisibleRows() * 18 - 1) continue;
                GlStateManager.func_179140_f();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                this.bindTexture("gui/crafter_manager.png");
                this.func_73729_b(7, y, 0, 174, 162, 18);
                this.drawString(11, y + 6, RenderUtils.shorten(I18n.func_135052_a((String)heading.getKey(), (Object[])new Object[0]), 25));
            }
        }
    }
}

