/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.block.BlockBase;
import com.raoulvdberge.refinedstorage.block.ControllerEnergyType;
import com.raoulvdberge.refinedstorage.block.ControllerType;
import com.raoulvdberge.refinedstorage.block.Direction;
import com.raoulvdberge.refinedstorage.item.ItemBlockController;
import com.raoulvdberge.refinedstorage.tile.TileController;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockController
extends BlockBase {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", ControllerType.class);
    public static final PropertyEnum ENERGY_TYPE = PropertyEnum.func_177709_a((String)"energy_type", ControllerEnergyType.class);

    public BlockController() {
        super("controller");
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i <= 1; ++i) {
            items.add((Object)ItemBlockController.createStackWithNBT(new ItemStack((Block)this, 1, i)));
        }
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.createBlockStateBuilder().add(new IProperty[]{TYPE}).add(new IProperty[]{ENERGY_TYPE}).build();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)(meta == 0 ? ControllerType.NORMAL : ControllerType.CREATIVE)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)TYPE) == ControllerType.NORMAL ? 0 : 1;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)ENERGY_TYPE, (Comparable)((Object)((TileController)world.func_175625_s(pos)).getEnergyType()));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileController();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.tryOpenNetworkGui(0, player, world, pos, side);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        if (!world.field_72995_K) {
            TileController controller = (TileController)world.func_175625_s(pos);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && tag.func_74764_b("Energy")) {
                controller.getEnergy().setEnergyStored(tag.func_74762_e("Energy"));
            }
        }
        super.func_180633_a(world, pos, state, player, stack);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack = new ItemStack((Block)RSBlocks.CONTROLLER, 1, RSBlocks.CONTROLLER.func_176201_c(state));
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("Energy", ((TileController)world.func_175625_s(pos)).getEnergy().getEnergyStored());
        stack.func_77978_p().func_74768_a("EnergyCapacity", ((TileController)world.func_175625_s(pos)).getEnergy().getMaxEnergyStored());
        drops.add((Object)stack);
    }

    @Override
    public Item createItem() {
        return new ItemBlockController();
    }

    @Override
    @Nullable
    public Direction getDirection() {
        return null;
    }
}

