/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class StorageCacheItemPortable
implements IStorageCache<ItemStack> {
    private IPortableGrid portableGrid;
    private IStackList<ItemStack> list = API.instance().createItemStackList();
    private List<IStorageCacheListener<ItemStack>> listeners = new LinkedList<IStorageCacheListener<ItemStack>>();

    public StorageCacheItemPortable(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    @Override
    public void invalidate() {
        this.list.clear();
        if (this.portableGrid.getStorage() != null) {
            this.portableGrid.getStorage().getStacks().forEach(this.list::add);
        }
        this.listeners.forEach(IStorageCacheListener::onInvalidated);
    }

    @Override
    public void add(@Nonnull ItemStack stack, int size, boolean rebuilding, boolean batched) {
        this.list.add(stack, size);
        if (!rebuilding) {
            this.listeners.forEach(l -> l.onChanged(stack, size));
        }
    }

    @Override
    public void remove(@Nonnull ItemStack stack, int size, boolean batched) {
        if (this.list.remove(stack, size)) {
            this.listeners.forEach(l -> l.onChanged(stack, -size));
        }
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Cannot flush portable grid storage cache");
    }

    @Override
    public void addListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(IStorageCacheListener<ItemStack> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sort() {
    }

    @Override
    public IStackList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public List<IStorage<ItemStack>> getStorages() {
        return Collections.emptyList();
    }
}

