/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageDiskFluid;
import com.raoulvdberge.refinedstorage.block.BlockFluidStorage;
import com.raoulvdberge.refinedstorage.block.FluidStorageType;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileFluidStorage;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IExcessVoidable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeFluidStorage
extends NetworkNode
implements IGuiStorage,
IStorageProvider,
IComparable,
IFilterable,
IPrioritizable,
IExcessVoidable,
IAccessType {
    public static final String ID = "fluid_storage";
    public static final String NBT_STORAGE = "Storage";
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_VOID_EXCESS = "VoidExcess";
    private ItemHandlerFluid filters = new ItemHandlerFluid(9, new ItemHandlerListenerNetworkNode(this));
    private StorageFluid storage = new StorageFluid(StorageDiskFluid.getTag());
    private NBTTagCompound storageTagToRead;
    private FluidStorageType type;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 2;
    private int mode = 0;
    private boolean voidExcess = false;

    public NetworkNodeFluidStorage(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.fluidStorageUsage;
    }

    @Override
    public void update() {
        super.update();
        if (this.storageTagToRead != null) {
            this.storage = new StorageFluid(this.storageTagToRead);
            this.storage.readFromNBT();
            if (this.network != null) {
                this.network.getFluidStorageCache().invalidate();
            }
            this.storageTagToRead = null;
        }
    }

    public void onPlacedWithStorage(NBTTagCompound tag) {
        this.storageTagToRead = tag;
    }

    public void onBreak() {
        if (this.storage != null) {
            this.storage.writeToNBT();
        }
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getNodeGraph().addPostRebuildHandler(StorageCacheFluid.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        if (this.storage != null) {
            storages.add(this.storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_STORAGE)) {
            this.storageTagToRead = tag.func_74775_l(NBT_STORAGE);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        this.storage.writeToNBT();
        tag.func_74782_a(NBT_STORAGE, (NBTBase)this.storage.getStorageTag());
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.filters, 0, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74757_a(NBT_VOID_EXCESS, this.voidExcess);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.filters, 0, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_VOID_EXCESS)) {
            this.voidExcess = tag.func_74767_n(NBT_VOID_EXCESS);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    public FluidStorageType getType() {
        if (this.type == null && this.world != null && this.world.func_180495_p(this.pos).func_177230_c() == RSBlocks.FLUID_STORAGE) {
            this.type = (FluidStorageType)((Object)this.world.func_180495_p(this.pos).func_177229_b((IProperty)BlockFluidStorage.TYPE));
        }
        return this.type == null ? FluidStorageType.TYPE_64K : this.type;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    public StorageDiskFluid getStorage() {
        return this.storage;
    }

    public ItemHandlerFluid getFilters() {
        return this.filters;
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:fluid_storage." + this.getType().getId() + ".name";
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileFluidStorage.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileFluidStorage.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileFluidStorage.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileFluidStorage.PRIORITY;
    }

    @Override
    public TileDataParameter<Boolean, ?> getVoidExcessParameter() {
        return TileFluidStorage.VOID_EXCESS;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileFluidStorage.ACCESS_TYPE;
    }

    @Override
    public String getVoidExcessType() {
        return "fluids";
    }

    @Override
    public int getStored() {
        return TileFluidStorage.STORED.getValue();
    }

    @Override
    public int getCapacity() {
        return this.getType().getCapacity();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getFluidStorageCache().invalidate();
        }
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getFluidStorageCache().sort();
        }
    }

    @Override
    public boolean getVoidExcess() {
        return this.voidExcess;
    }

    @Override
    public void setVoidExcess(boolean value) {
        this.voidExcess = value;
        this.markDirty();
    }

    class StorageFluid
    extends StorageDiskFluid {
        StorageFluid(NBTTagCompound tag) {
            super(tag, NetworkNodeFluidStorage.this.getCapacity());
            this.onPassContainerContext(NetworkNodeFluidStorage.this::markDirty, NetworkNodeFluidStorage.this::getVoidExcess, NetworkNodeFluidStorage.this::getAccessType);
        }

        @Override
        public int getPriority() {
            return NetworkNodeFluidStorage.this.priority;
        }

        @Override
        @Nullable
        public FluidStack insert(@Nonnull FluidStack stack, int size, boolean simulate) {
            if (!IFilterable.canTakeFluids(NetworkNodeFluidStorage.this.filters, NetworkNodeFluidStorage.this.mode, NetworkNodeFluidStorage.this.compare, stack)) {
                return StackUtils.copy(stack, size);
            }
            return super.insert(stack, size, simulate);
        }
    }
}

