/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview;

import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingPreviewElementFluidStack
implements ICraftingPreviewElement<FluidStack> {
    public static final String ID = "fluid_renderer";
    private FluidStack stack;
    private int available;
    private boolean missing;
    private int toCraft;

    public CraftingPreviewElementFluidStack(FluidStack stack) {
        this.stack = stack.copy();
        this.available = stack.amount;
    }

    public CraftingPreviewElementFluidStack(FluidStack stack, int available, boolean missing, int toCraft) {
        this.stack = stack.copy();
        this.available = available;
        this.missing = missing;
        this.toCraft = toCraft;
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((FluidStack)this.stack));
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.tag);
        buf.writeInt(this.available);
        buf.writeBoolean(this.missing);
        buf.writeInt(this.toCraft);
    }

    public static CraftingPreviewElementFluidStack fromByteBuf(ByteBuf buf) {
        Fluid fluid = FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        int available = buf.readInt();
        boolean missing = buf.readBoolean();
        int toCraft = buf.readInt();
        return new CraftingPreviewElementFluidStack(new FluidStack(fluid, 1, tag), available, missing, toCraft);
    }

    @Override
    public FluidStack getElement() {
        return this.stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers) {
        if (this.missing) {
            drawers.getOverlayDrawer().draw(x, y, -860450);
        }
        drawers.getFluidDrawer().draw(x += 5, y += 7, this.getElement());
        float scale = drawers.getFontRenderer().func_82883_a() ? 1.0f : 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 23, scale), RenderUtils.getOffsetOnScale(y + 3, scale), GuiBase.t("gui.refinedstorage:crafting_preview.available", ""));
        drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 23, scale), RenderUtils.getOffsetOnScale(y + 9, scale), this.getAvailable() + " mB");
        GlStateManager.func_179121_F();
    }

    public void addAvailable(int amount) {
        this.available += amount;
    }

    @Override
    public int getAvailable() {
        return this.available;
    }

    public void addToCraft(int amount) {
        this.toCraft += amount;
    }

    @Override
    public int getToCraft() {
        return this.toCraft;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    @Override
    public boolean hasMissing() {
        return this.missing;
    }

    @Override
    public String getId() {
        return ID;
    }
}

