/*
 * Decompiled with CFR 0.152.
 */
package net.modcrafters.mclib.registries;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.GenericEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.modcrafters.mclib.ingredients.IMachineIngredient;
import net.modcrafters.mclib.recipes.IMachineRecipe;
import net.modcrafters.mclib.registries.IRecipeRegistry;
import net.ndrei.teslacorelib.annotations.IRegistryHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \"*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0006 !\"#$%B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u0019H\u0004R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/modcrafters/mclib/registries/BaseRecipeRegistry;", "T", "Lnet/modcrafters/mclib/recipes/IMachineRecipe;", "Lnet/ndrei/teslacorelib/annotations/IRegistryHandler;", "Lnet/modcrafters/mclib/registries/IRecipeRegistry;", "modId", "", "registryName", "type", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "<set-?>", "", "isRegistrationCompleted", "()Z", "setRegistrationCompleted", "(Z)V", "registry", "Lnet/minecraftforge/registries/IForgeRegistryModifiable;", "getRegistry", "()Lnet/minecraftforge/registries/IForgeRegistryModifiable;", "Lnet/minecraft/util/ResourceLocation;", "getRegistryName", "()Lnet/minecraft/util/ResourceLocation;", "construct", "", "asm", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;", "registerRegistry", "ev", "Lnet/minecraftforge/event/RegistryEvent$NewRegistry;", "registrationCompleted", "AddCallback", "ClearCallback", "Companion", "DefaultRegistrationCompletedEvent", "EntryAddedEvent", "RegistryClearEvent", "tesla-core-lib"})
public abstract class BaseRecipeRegistry<T extends IMachineRecipe<T>>
implements IRegistryHandler,
IRecipeRegistry<T> {
    @NotNull
    private final ResourceLocation registryName;
    private boolean isRegistrationCompleted;
    private final Class<T> type;
    public static final int MAX_RECIPE_ID = 0x3FFFFFF;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public void construct(@NotNull ASMDataTable asm) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        IRegistryHandler.DefaultImpls.construct(this, asm);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public final void registerRegistry(@NotNull RegistryEvent.NewRegistry ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        new RegistryBuilder().setName(this.getRegistryName()).setMaxID(0x3FFFFFF).setType(this.type).add((IForgeRegistry.AddCallback)new AddCallback<T>(this.type)).add((IForgeRegistry.ClearCallback)new ClearCallback<T>(this.type)).disableSaving().allowModification().create();
    }

    @Override
    public final boolean isRegistrationCompleted() {
        return this.isRegistrationCompleted;
    }

    private final void setRegistrationCompleted(boolean bl) {
        this.isRegistrationCompleted = bl;
    }

    protected final void registrationCompleted() {
        MinecraftForge.EVENT_BUS.post((Event)new DefaultRegistrationCompletedEvent<T>(this.type, this));
        this.isRegistrationCompleted = true;
    }

    @Override
    @Nullable
    public IForgeRegistryModifiable<T> getRegistry() {
        IForgeRegistry iForgeRegistry = GameRegistry.findRegistry(this.type);
        if (!(iForgeRegistry instanceof IForgeRegistryModifiable)) {
            iForgeRegistry = null;
        }
        return (IForgeRegistryModifiable)iForgeRegistry;
    }

    public BaseRecipeRegistry(@NotNull String modId, @NotNull String registryName, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)modId, (String)"modId");
        Intrinsics.checkParameterIsNotNull((Object)registryName, (String)"registryName");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        this.type = type;
        this.registryName = new ResourceLocation(modId, registryName);
    }

    @Override
    public void preInit(@NotNull ASMDataTable asm) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        IRegistryHandler.DefaultImpls.preInit(this, asm);
    }

    @Override
    public void init(@NotNull ASMDataTable asm) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        IRegistryHandler.DefaultImpls.init(this, asm);
    }

    @Override
    public void postInit(@NotNull ASMDataTable asm) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        IRegistryHandler.DefaultImpls.postInit(this, asm);
    }

    @Override
    public void registerItems(@NotNull ASMDataTable asm, @NotNull IForgeRegistry<Item> registry) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        IRegistryHandler.DefaultImpls.registerItems(this, asm, registry);
    }

    @Override
    public void registerBlocks(@NotNull ASMDataTable asm, @NotNull IForgeRegistry<Block> registry) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        IRegistryHandler.DefaultImpls.registerBlocks(this, asm, registry);
    }

    @Override
    public void registerRecipes(@NotNull ASMDataTable asm, @NotNull IForgeRegistry<IRecipe> registry) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        IRegistryHandler.DefaultImpls.registerRecipes(this, asm, registry);
    }

    @Override
    public void registerRenderers(@NotNull ASMDataTable asm) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        IRegistryHandler.DefaultImpls.registerRenderers(this, asm);
    }

    @Override
    @NotNull
    public IRecipeRegistry<T> addRecipe(@NotNull T recipe, boolean suffixDuplicates) {
        Intrinsics.checkParameterIsNotNull(recipe, (String)"recipe");
        return IRecipeRegistry.DefaultImpls.addRecipe(this, recipe, suffixDuplicates);
    }

    @Override
    @NotNull
    public List<T> findRecipes(@NotNull Function1<? super T, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        return IRecipeRegistry.DefaultImpls.findRecipes(this, filter);
    }

    @Override
    public boolean hasRecipe(@NotNull Function1<? super T, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        return IRecipeRegistry.DefaultImpls.hasRecipe(this, filter);
    }

    @Override
    @Nullable
    public T findRecipe(@NotNull Function1<? super T, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        return IRecipeRegistry.DefaultImpls.findRecipe(this, filter);
    }

    @Override
    @Nullable
    public T getRecipe(@NotNull ResourceLocation name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return IRecipeRegistry.DefaultImpls.getRecipe(this, name);
    }

    @Override
    public void removeRecipe(@NotNull ResourceLocation registration) {
        Intrinsics.checkParameterIsNotNull((Object)registration, (String)"registration");
        IRecipeRegistry.DefaultImpls.removeRecipe(this, registration);
    }

    @Override
    @NotNull
    public List<T> getAllRecipes() {
        return IRecipeRegistry.DefaultImpls.getAllRecipes(this);
    }

    @Override
    public void removeRecipeByOutput(@NotNull IMachineIngredient output) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        IRecipeRegistry.DefaultImpls.removeRecipeByOutput(this, output);
    }

    @Override
    public void removeRecipeByPrimaryOutput(@NotNull IMachineIngredient primaryOutput) {
        Intrinsics.checkParameterIsNotNull((Object)primaryOutput, (String)"primaryOutput");
        IRecipeRegistry.DefaultImpls.removeRecipeByPrimaryOutput(this, primaryOutput);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006JA\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00012\b\u0010\u0010\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/modcrafters/mclib/registries/BaseRecipeRegistry$AddCallback;", "T", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "Lnet/minecraftforge/registries/IForgeRegistry$AddCallback;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "onAdd", "", "owner", "Lnet/minecraftforge/registries/IForgeRegistryInternal;", "stage", "Lnet/minecraftforge/registries/RegistryManager;", "id", "", "obj", "oldObj", "(Lnet/minecraftforge/registries/IForgeRegistryInternal;Lnet/minecraftforge/registries/RegistryManager;ILnet/minecraftforge/registries/IForgeRegistryEntry;Lnet/minecraftforge/registries/IForgeRegistryEntry;)V", "tesla-core-lib"})
    public static final class AddCallback<T extends IForgeRegistryEntry<T>>
    implements IForgeRegistry.AddCallback<T> {
        private final Class<T> type;

        public void onAdd(@Nullable IForgeRegistryInternal<T> owner, @Nullable RegistryManager stage, int id, @NotNull T obj, @Nullable T oldObj) {
            Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
            MinecraftForge.EVENT_BUS.post((Event)new EntryAddedEvent<T>(this.type, obj));
        }

        public AddCallback(@NotNull Class<T> type) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            this.type = type;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/modcrafters/mclib/registries/BaseRecipeRegistry$ClearCallback;", "T", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "Lnet/minecraftforge/registries/IForgeRegistry$ClearCallback;", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "onClear", "", "owner", "Lnet/minecraftforge/registries/IForgeRegistryInternal;", "stage", "Lnet/minecraftforge/registries/RegistryManager;", "tesla-core-lib"})
    public static final class ClearCallback<T extends IForgeRegistryEntry<T>>
    implements IForgeRegistry.ClearCallback<T> {
        private final Class<T> type;

        public void onClear(@Nullable IForgeRegistryInternal<T> owner, @Nullable RegistryManager stage) {
            if (owner != null) {
                MinecraftForge.EVENT_BUS.post((Event)new RegistryClearEvent<T>(this.type, (IForgeRegistry)owner));
            }
        }

        public ClearCallback(@NotNull Class<T> type) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            this.type = type;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lnet/modcrafters/mclib/registries/BaseRecipeRegistry$EntryAddedEvent;", "T", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "Lnet/minecraftforge/fml/common/eventhandler/GenericEvent;", "type", "Ljava/lang/Class;", "entry", "(Ljava/lang/Class;Lnet/minecraftforge/registries/IForgeRegistryEntry;)V", "getEntry", "()Lnet/minecraftforge/registries/IForgeRegistryEntry;", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "tesla-core-lib"})
    public static final class EntryAddedEvent<T extends IForgeRegistryEntry<T>>
    extends GenericEvent<T> {
        @NotNull
        private final T entry;

        @NotNull
        public final T getEntry() {
            return this.entry;
        }

        public EntryAddedEvent(@NotNull Class<T> type, @NotNull T entry) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Intrinsics.checkParameterIsNotNull(entry, (String)"entry");
            super(type);
            this.entry = entry;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/modcrafters/mclib/registries/BaseRecipeRegistry$RegistryClearEvent;", "T", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "Lnet/minecraftforge/fml/common/eventhandler/GenericEvent;", "type", "Ljava/lang/Class;", "registry", "Lnet/minecraftforge/registries/IForgeRegistry;", "(Ljava/lang/Class;Lnet/minecraftforge/registries/IForgeRegistry;)V", "getRegistry", "()Lnet/minecraftforge/registries/IForgeRegistry;", "tesla-core-lib"})
    public static final class RegistryClearEvent<T extends IForgeRegistryEntry<T>>
    extends GenericEvent<T> {
        @NotNull
        private final IForgeRegistry<T> registry;

        @NotNull
        public final IForgeRegistry<T> getRegistry() {
            return this.registry;
        }

        public RegistryClearEvent(@NotNull Class<T> type, @NotNull IForgeRegistry<T> registry) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
            super(type);
            this.registry = registry;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/modcrafters/mclib/registries/BaseRecipeRegistry$DefaultRegistrationCompletedEvent;", "T", "Lnet/modcrafters/mclib/recipes/IMachineRecipe;", "Lnet/minecraftforge/fml/common/eventhandler/GenericEvent;", "type", "Ljava/lang/Class;", "registry", "Lnet/modcrafters/mclib/registries/IRecipeRegistry;", "(Ljava/lang/Class;Lnet/modcrafters/mclib/registries/IRecipeRegistry;)V", "getRegistry", "()Lnet/modcrafters/mclib/registries/IRecipeRegistry;", "tesla-core-lib"})
    public static final class DefaultRegistrationCompletedEvent<T extends IMachineRecipe<T>>
    extends GenericEvent<T> {
        @NotNull
        private final IRecipeRegistry<T> registry;

        @NotNull
        public final IRecipeRegistry<T> getRegistry() {
            return this.registry;
        }

        public DefaultRegistrationCompletedEvent(@NotNull Class<T> type, @NotNull IRecipeRegistry<T> registry) {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
            super(type);
            this.registry = registry;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/modcrafters/mclib/registries/BaseRecipeRegistry$Companion;", "", "()V", "MAX_RECIPE_ID", "", "tesla-core-lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

