/*
 * Decompiled with CFR 0.152.
 */
package elucent.blockcraftery.block;

import elucent.blockcraftery.block.IEditableBlock;
import elucent.blockcraftery.model.BakedModelEditableInnerCorner;
import elucent.blockcraftery.model.BakedModelEditableOuterCorner;
import elucent.blockcraftery.tile.TileEditableBlock;
import elucent.elulib.block.BlockCornerBase;
import elucent.elulib.block.BlockTECornerBase;
import elucent.elulib.model.CustomModelBlock;
import elucent.elulib.model.CustomModelLoader;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEditableCorner
extends BlockTECornerBase
implements IEditableBlock {
    public static final UnlistedPropertyState STATEPROP = new UnlistedPropertyState();

    public BlockEditableCorner(IBlockState state, SoundType type, float hardness, String name, boolean inner, Class<? extends TileEntity> teClass) {
        super(state, type, hardness, name, inner, teClass);
        this.hasCustomModel = true;
        this.func_149713_g(0);
        this.setOpacity(false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{BlockCornerBase.INNER, BlockCornerBase.UP, BlockCornerBase.DIR};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{STATEPROP};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        IBlockState actual = this.func_176221_a(state, world, pos).func_177226_a((IProperty)INNER, (Comparable)Boolean.valueOf(this.inner));
        if (t instanceof TileEditableBlock && actual instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)actual).withProperty((IUnlistedProperty)STATEPROP, (Object)((TileEditableBlock)t).state);
        }
        return state;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileEditableBlock) {
            return ((TileEditableBlock)t).state.func_177230_c().doesSideBlockRendering(((TileEditableBlock)t).state, world, pos, side) && super.doesSideBlockRendering(state, world, pos, side);
        }
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.getRegistryName().func_110624_b() + ":blocks/" + this.getRegistryName().func_110623_a());
            if (this.parent != null) {
                defaultTex = new ResourceLocation(this.parent.func_177230_c().getRegistryName().func_110624_b() + ":blocks/" + this.parent.func_177230_c().getRegistryName().func_110623_a());
            }
            if (this.inner) {
                CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(BakedModelEditableInnerCorner.class, defaultTex, defaultTex));
                CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#inventory"), new CustomModelBlock(BakedModelEditableInnerCorner.class, defaultTex, defaultTex));
            } else {
                CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.name), new CustomModelBlock(BakedModelEditableOuterCorner.class, defaultTex, defaultTex));
                CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.name + "#inventory"), new CustomModelBlock(BakedModelEditableOuterCorner.class, defaultTex, defaultTex));
            }
        }
    }

    @Override
    public IUnlistedProperty<IBlockState> getStateProperty() {
        return STATEPROP;
    }

    public static class UnlistedPropertyState
    implements IUnlistedProperty<IBlockState> {
        public String getName() {
            return "stateprop";
        }

        public boolean isValid(IBlockState value) {
            return true;
        }

        public Class<IBlockState> getType() {
            return IBlockState.class;
        }

        public String valueToString(IBlockState value) {
            return value.toString();
        }
    }
}

