/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.integration;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftbutilities.client.FTBUtilitiesClientConfig;
import com.feed_the_beast.ftbutilities.gui.ClientClaimedChunks;
import com.feed_the_beast.ftbutilities.gui.UpdateClientDataEvent;
import com.feed_the_beast.ftbutilities.net.MessageClaimedChunksRequest;
import com.feed_the_beast.ftbutilities.net.MessageClaimedChunksUpdate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@ClientPlugin
public class JourneyMapIntegration
implements IClientPlugin {
    private IClientAPI clientAPI;
    private Map<ChunkPos, PolygonOverlay> polygons;
    private ChunkPos lastPosition;

    public void initialize(IClientAPI api) {
        this.clientAPI = api;
        this.polygons = new HashMap<ChunkPos, PolygonOverlay>();
        this.lastPosition = null;
        api.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.DISPLAY_UPDATE, ClientEvent.Type.MAPPING_STOPPED));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getModId() {
        return "ftbutilities";
    }

    public void onEvent(ClientEvent event) {
        switch (event.type) {
            case DISPLAY_UPDATE: {
                if (ClientUtils.MC.field_71439_g == null) break;
                new MessageClaimedChunksRequest((Entity)ClientUtils.MC.field_71439_g).sendToServer();
                break;
            }
            case MAPPING_STOPPED: {
                this.clearData();
            }
        }
    }

    private void clearData() {
        if (!this.polygons.isEmpty()) {
            this.polygons.clear();
            this.clientAPI.removeAll("ftbutilities");
        }
    }

    private void chunkChanged(ChunkPos pos, @Nullable ClientClaimedChunks.ChunkData chunk, int dim) {
        try {
            PolygonOverlay p = this.polygons.get(pos);
            if (p != null) {
                this.clientAPI.remove((Displayable)p);
                if (chunk == null) {
                    this.polygons.remove(pos);
                }
            }
            if (chunk != null) {
                MapPolygon poly = PolygonHelper.createChunkPolygon((int)pos.field_77276_a, (int)0, (int)pos.field_77275_b);
                p = new PolygonOverlay("ftbutilities", "claimed_" + pos.field_77276_a + '_' + pos.field_77275_b, dim, (ShapeProperties)chunk.team.shapeProperties, poly);
                p.setOverlayGroupName("claimed_chunks");
                p.setTitle(chunk.team.formattedName + '\n' + TextFormatting.GREEN + I18n.func_135052_a((String)"ftbutilities.lang.chunks.claimed_area", (Object[])new Object[0]));
                this.polygons.put(pos, p);
                this.clientAPI.show((Displayable)p);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onEnteringChunk(EntityEvent.EnteringChunk event) {
        if (!FTBUtilitiesClientConfig.general.journeymap_overlay || event.getEntity() != ClientUtils.MC.field_71439_g) {
            return;
        }
        if (this.lastPosition == null || MathUtils.dist((double)event.getNewChunkX(), (double)event.getNewChunkZ(), (double)this.lastPosition.field_77276_a, (double)this.lastPosition.field_77275_b) >= 3.0) {
            this.lastPosition = new ChunkPos(event.getNewChunkX(), event.getNewChunkZ());
            new MessageClaimedChunksRequest((Entity)ClientUtils.MC.field_71439_g).sendToServer();
        }
    }

    @SubscribeEvent
    public void onDataReceived(UpdateClientDataEvent event) {
        if (!(this.polygons.isEmpty() || FTBUtilitiesClientConfig.general.journeymap_overlay && this.clientAPI.playerAccepts("ftbutilities", DisplayType.Polygon))) {
            this.clearData();
            return;
        }
        MessageClaimedChunksUpdate m = event.getMessage();
        ClientClaimedChunks.ChunkData[] data = new ClientClaimedChunks.ChunkData[225];
        for (ClientClaimedChunks.Team team : m.teams.values()) {
            ShapeProperties shapeProperties = new ShapeProperties();
            shapeProperties.setFillOpacity(0.2f);
            shapeProperties.setStrokeOpacity(0.0f);
            shapeProperties.setFillColor(team.color.getColor().rgba());
            team.shapeProperties = shapeProperties;
            for (Map.Entry<Integer, ClientClaimedChunks.ChunkData> entry : team.chunks.entrySet()) {
                int x = entry.getKey() % 15;
                int z = entry.getKey() / 15;
                data[x + z * 15] = entry.getValue();
            }
        }
        int dim = ClientUtils.getDim();
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                this.chunkChanged(new ChunkPos(m.startX + x, m.startZ + z), data[x + z * 15], dim);
            }
        }
    }
}

