/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.lib.EnumMessageLocation;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.command.CmdShutdown;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.feed_the_beast.ftbutilities.data.backups.Backups;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesServerEventHandler {
    private static final ResourceLocation RESTART_TIMER_ID = new ResourceLocation("ftbutilities", "restart_timer");
    private static final ResourceLocation AFK_ID = new ResourceLocation("ftbutilities", "afk");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerChatEvent(ServerChatEvent event) {
        if (!FTBUtilitiesConfig.ranks.override_chat || !Ranks.isActive()) {
            return;
        }
        EntityPlayerMP player = event.getPlayer();
        Rank rank = Ranks.INSTANCE.getRank(player.field_71133_b, player.func_146103_bH(), (IContext)new PlayerContext((EntityPlayer)player));
        if (rank.isNone()) {
            return;
        }
        TextComponentString main = new TextComponentString("");
        FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)player));
        main.func_150257_a(data.getNameForChat(rank));
        main.func_150257_a(FTBUtilitiesPermissions.CHAT_TEXT.format(rank, ForgeHooks.newChatWithLinks((String)event.getMessage().trim()), null));
        event.setComponent((ITextComponent)main);
    }

    @SubscribeEvent
    public static void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (!Universe.loaded()) {
            return;
        }
        Universe universe = Universe.get();
        long nowTicks = universe.world.func_82737_E();
        long nowTime = System.currentTimeMillis();
        if (event.phase == TickEvent.Phase.START) {
            if (ClaimedChunks.isActive()) {
                ClaimedChunks.instance.update(universe.server, nowTicks);
            }
        } else {
            if (FTBUtilitiesConfig.afk.isEnabled(universe.server)) {
                EntityPlayerMP playerToKickForAfk = null;
                for (EntityPlayerMP player : universe.server.func_184103_al().func_181057_v()) {
                    long maxTicks;
                    boolean isAFK;
                    FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)player));
                    if (!player.field_71075_bZ.field_75098_d && data.getFly()) {
                        boolean fly = player.field_71075_bZ.field_75101_c;
                        player.field_71075_bZ.field_75101_c = true;
                        if (!fly) {
                            player.func_71016_p();
                        }
                    }
                    boolean prevIsAfk = data.afkTicks >= FTBUtilitiesConfig.afk.getNotificationTimer();
                    data.afkTicks = (int)((System.currentTimeMillis() - player.func_154331_x()) * 20L / 1000L);
                    boolean bl = isAFK = data.afkTicks >= FTBUtilitiesConfig.afk.getNotificationTimer();
                    if (prevIsAfk != isAFK) {
                        for (EntityPlayerMP player1 : universe.server.func_184103_al().func_181057_v()) {
                            EnumMessageLocation location = FTBUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)player1)).getAFKMessageLocation();
                            if (location == EnumMessageLocation.OFF) continue;
                            ITextComponent component = FTBUtilities.lang((ICommandSender)player1, isAFK ? "permission.ftbutilities.afk.timer.is_afk" : "permission.ftbutilities.afk.timer.isnt_afk", player.func_145748_c_());
                            component.func_150256_b().func_150238_a(TextFormatting.GRAY);
                            if (location == EnumMessageLocation.CHAT) {
                                player1.func_145747_a(component);
                                continue;
                            }
                            Notification.of((ResourceLocation)AFK_ID, (ITextComponent[])new ITextComponent[]{component}).send(universe.server, (EntityPlayer)player1);
                        }
                        FTBUtilities.LOGGER.info(player.func_70005_c_() + (isAFK ? " is now AFK" : " is no longer AFK"));
                    }
                    if (playerToKickForAfk != null || (maxTicks = data.player.getRankConfig(FTBUtilitiesPermissions.AFK_TIMER).getLong()) <= 0L || data.afkTicks < maxTicks) continue;
                    playerToKickForAfk = player;
                }
                if (playerToKickForAfk != null && playerToKickForAfk.field_71135_a != null) {
                    playerToKickForAfk.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.idling", new Object[0]));
                }
            }
            Backups.INSTANCE.tick(universe, nowTicks, nowTime);
            if (FTBUtilitiesUniverseData.shutdownTime > 0L) {
                long t = Ticks.mst((long)(FTBUtilitiesUniverseData.shutdownTime - nowTime));
                if (t <= 0L) {
                    if (Backups.INSTANCE.doingBackup == 0) {
                        CmdShutdown.shutdown(universe.server);
                    }
                } else if (t <= Ticks.st((long)10L) && t % 20L == 19L || t == Ticks.mt((long)1L) || t == Ticks.mt((long)5L) || t == Ticks.mt((long)10L) || t == Ticks.mt((long)30L)) {
                    for (EntityPlayerMP player : universe.server.func_184103_al().func_181057_v()) {
                        Notification.of((ResourceLocation)RESTART_TIMER_ID, (ITextComponent[])new ITextComponent[]{StringUtils.color((ITextComponent)FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.timer.shutdown", StringUtils.getTimeStringTicks((long)t)), (TextFormatting)TextFormatting.LIGHT_PURPLE)}).send(universe.server, (EntityPlayer)player);
                    }
                }
            }
        }
    }
}

