/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.math.BlockPosContainer;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesNotifications;
import com.feed_the_beast.ftbutilities.data.BlockInteractionType;
import com.feed_the_beast.ftbutilities.data.ClaimedChunk;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.google.common.base.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesPlayerEventHandler {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)event.getEntity()));
            data.setLastDeath(new BlockDimPos(event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onChunkChanged(EntityEvent.EnteringChunk event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityPlayerMP) || !Universe.loaded()) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        player.func_143004_u();
        ForgePlayer p = Universe.get().getPlayer(player.func_146103_bH());
        if (p == null || p.isFake()) {
            return;
        }
        FTBUtilitiesPlayerData.get(p).setLastSafePos(new BlockDimPos((Entity)player));
        FTBUtilitiesPlayerEventHandler.updateChunkMessage(player, new ChunkDimPos(event.getNewChunkX(), event.getNewChunkZ(), player.field_71093_bK));
    }

    public static void updateChunkMessage(EntityPlayerMP player, ChunkDimPos pos) {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        ClaimedChunk chunk = ClaimedChunks.instance.getChunk(pos);
        ForgeTeam team = chunk == null ? null : chunk.getTeam();
        FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)player));
        if (!Objects.equal((Object)data.lastChunkTeam, (Object)team)) {
            data.lastChunkTeam = team;
            if (team != null) {
                Notification notification = Notification.of((ResourceLocation)FTBUtilitiesNotifications.CHUNK_CHANGED, (ITextComponent[])new ITextComponent[]{team.getTitle()});
                if (!team.getDesc().isEmpty()) {
                    notification.addLine(StringUtils.italic((ITextComponent)new TextComponentString(team.getDesc()), (boolean)true));
                }
                notification.send(player.field_71133_b, (EntityPlayer)player);
            } else {
                Notification.of((ResourceLocation)FTBUtilitiesNotifications.CHUNK_CHANGED, (ITextComponent[])new ITextComponent[]{StringUtils.color((ITextComponent)FTBUtilities.lang((ICommandSender)player, "ftbutilities.lang.chunks.wilderness", new Object[0]), (TextFormatting)TextFormatting.DARK_GREEN)}).send(player.field_71133_b, (EntityPlayer)player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttacked(AttackEntityEvent event) {
        if (ClaimedChunks.isActive() && event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunks.instance.canPlayerAttackEntity((EntityPlayerMP)event.getEntityPlayer(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (ClaimedChunks.isActive() && event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunks.instance.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.INTERACT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (ClaimedChunks.isActive() && event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunks.instance.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.ITEM)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (ClaimedChunks.isActive() && event.getPlayer() instanceof EntityPlayerMP && !ClaimedChunks.instance.canPlayerInteract((EntityPlayerMP)event.getPlayer(), EnumHand.MAIN_HAND, new BlockPosContainer(event.getWorld(), event.getPos(), event.getState()), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (ClaimedChunks.isActive() && event.getPlayer() instanceof EntityPlayerMP && !ClaimedChunks.instance.canPlayerInteract((EntityPlayerMP)event.getPlayer(), EnumHand.MAIN_HAND, new BlockPosContainer(event.getWorld(), event.getPos(), event.getPlacedBlock()), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (ClaimedChunks.isActive() && event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunks.instance.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onNameFormat(PlayerEvent.NameFormat event) {
        FTBUtilitiesPlayerData data;
        ForgePlayer p;
        if (FTBUtilitiesConfig.commands.nick && Universe.loaded() && event.getEntityPlayer() instanceof EntityPlayerMP && (p = Universe.get().getPlayer(event.getEntityPlayer().func_146103_bH())) != null && !(data = FTBUtilitiesPlayerData.get(p)).getNickname().isEmpty() && PermissionAPI.hasPermission((EntityPlayer)event.getEntityPlayer(), (String)"ftbutilities.nickname.set")) {
            String name = data.getNickname().replace('&', '\u00a7');
            if (!p.hasPermission("ftbutilities.nickname.colors")) {
                name = TextFormatting.func_110646_a((String)name);
            } else if (name.indexOf(167) != -1) {
                name = name + TextFormatting.RESET;
            }
            event.setDisplayname(name);
        }
    }

    private static String getStateName(IBlockState state) {
        if (state == state.func_177230_c().func_176223_P()) {
            return state.func_177230_c().getRegistryName().toString();
        }
        return state.toString();
    }

    private static String getDim(EntityPlayer player) {
        return ServerUtils.getDimensionName((int)player.field_71093_bK).func_150260_c();
    }

    private static String getPos(BlockPos pos) {
        return String.format("[%d, %d, %d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SubscribeEvent
    public static void onBlockBreakLog(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (FTBUtilitiesConfig.world.logging.block_broken && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s broke %s at %s in %s", player.func_70005_c_(), FTBUtilitiesPlayerEventHandler.getStateName(event.getState()), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }

    @SubscribeEvent
    public static void onBlockPlaceLog(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        if (FTBUtilitiesConfig.world.logging.block_placed && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s placed %s at %s in %s", player.func_70005_c_(), FTBUtilitiesPlayerEventHandler.getStateName(event.getState()), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }

    @SubscribeEvent
    public static void onRightClickItemLog(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (FTBUtilitiesConfig.world.logging.item_clicked_in_air && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s clicked %s in air at %s in %s", player.func_70005_c_(), event.getItemStack().func_77973_b().getRegistryName(), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }
}

