/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data.backups;

import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.backups.Backup;
import com.feed_the_beast.ftbutilities.events.BackupEvent;
import com.feed_the_beast.ftbutilities.net.MessageBackupProgress;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ThreadedFileIOBase;

public enum Backups {
    INSTANCE;

    public static final ResourceLocation NOTIFICATION_ID;
    public final List<Backup> backups = new ArrayList<Backup>();
    public File backupsFolder;
    public long nextBackup = -1L;
    public int doingBackup = 0;
    public boolean printFiles = false;
    private int currentFile = 0;
    private int totalFiles = 0;
    private String currentFileName = "";

    public void init() {
        this.backupsFolder = FTBUtilitiesConfig.backups.folder.isEmpty() ? new File(CommonUtils.folderMinecraft, "/backups/") : new File(FTBUtilitiesConfig.backups.folder);
        this.doingBackup = 0;
        this.backups.clear();
        JsonElement element = DataReader.get((File)new File(this.backupsFolder, "backups.json")).safeJson();
        if (element.isJsonArray()) {
            try {
                for (JsonElement e : element.getAsJsonArray()) {
                    JsonObject json = e.getAsJsonObject();
                    if (!json.has("size")) {
                        json.addProperty("size", (Number)FileUtils.getSize((File)new File(this.backupsFolder, json.get("file").getAsString())));
                    }
                    this.backups.add(new Backup(json));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        FTBUtilities.LOGGER.info("Backups folder - " + this.backupsFolder.getAbsolutePath());
    }

    public void tick(Universe universe, long nowTicks, long nowTime) {
        if (this.nextBackup > 0L && this.nextBackup <= nowTime) {
            this.run(universe.server, (ICommandSender)universe.server, "");
        }
        if (this.doingBackup > 1) {
            this.doingBackup = 0;
            for (WorldServer world : universe.server.field_71305_c) {
                if (world == null) continue;
                world.field_73058_d = false;
            }
            if (!FTBUtilitiesConfig.backups.silent) {
                new MessageBackupProgress(0, 0).sendToAll();
            }
        } else if (this.doingBackup > 0 && this.printFiles) {
            if (this.currentFile == 0 || nowTicks % 20L * 2L == 0L || this.currentFile == this.totalFiles - 1) {
                FTBUtilities.LOGGER.info("[" + this.currentFile + " | " + StringUtils.formatDouble((double)((double)this.currentFile / (double)this.totalFiles * 100.0)) + "%]: " + this.currentFileName);
            }
            if (!FTBUtilitiesConfig.backups.silent) {
                new MessageBackupProgress(this.currentFile, this.totalFiles).sendToAll();
            }
        }
    }

    public void notifyAll(MinecraftServer server, Function<ICommandSender, ITextComponent> function, boolean error) {
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            ITextComponent component = function.apply((ICommandSender)player);
            component.func_150256_b().func_150238_a(error ? TextFormatting.DARK_RED : TextFormatting.LIGHT_PURPLE);
            Notification.of((ResourceLocation)NOTIFICATION_ID, (ITextComponent[])new ITextComponent[]{component}).setImportant(true).send(server, null);
        }
        FTBUtilities.LOGGER.info(function.apply(null).func_150260_c());
    }

    public boolean run(MinecraftServer server, ICommandSender sender, String customName) {
        boolean auto;
        if (this.doingBackup != 0) {
            return false;
        }
        boolean bl = auto = !(sender instanceof EntityPlayerMP);
        if (auto && !FTBUtilitiesConfig.backups.enabled) {
            return false;
        }
        this.notifyAll(server, player -> FTBUtilities.lang(player, "ftbutilities.lang.backup.start", sender.func_70005_c_()), false);
        this.nextBackup = System.currentTimeMillis() + FTBUtilitiesConfig.backups.time();
        for (WorldServer world : server.field_71305_c) {
            if (world == null) continue;
            world.field_73058_d = true;
        }
        File wd = server.func_71218_a(0).func_72860_G().func_75765_b();
        this.doingBackup = 1;
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            this.doBackup(server, wd, customName);
            return false;
        });
        return true;
    }

    private void doBackup(MinecraftServer server, File src, String customName) {
        try {
            if (server.func_184103_al() != null) {
                server.func_184103_al().func_72389_g();
            }
            for (WorldServer world : server.field_71305_c) {
                if (world == null) continue;
                world.func_73044_a(true, null);
            }
        }
        catch (Exception ex) {
            this.notifyAll(server, player -> FTBUtilities.lang(player, "ftbutilities.lang.backup.saving_failed", new Object[0]), true);
            FTBUtilities.LOGGER.error("Saving world failed!");
            ex.printStackTrace();
            return;
        }
        Calendar time = Calendar.getInstance();
        File dstFile = null;
        boolean success = false;
        StringBuilder out = new StringBuilder();
        if (customName.isEmpty()) {
            this.appendNum(out, time.get(1), '-');
            this.appendNum(out, time.get(2) + 1, '-');
            this.appendNum(out, time.get(5), '-');
            this.appendNum(out, time.get(11), '-');
            this.appendNum(out, time.get(12), '-');
            this.appendNum(out, time.get(13), '\u0000');
        } else {
            out.append(customName);
        }
        Exception error = null;
        long fileSize = 0L;
        try {
            LinkedHashMap<File, String> fileMap = new LinkedHashMap<File, String>();
            String mcdir = server.func_71238_n().getCanonicalFile().getAbsolutePath();
            Consumer<File> consumer = file0 -> {
                for (File file : FileUtils.listTree((File)file0)) {
                    String s1 = file.getAbsolutePath().replace(mcdir, "");
                    if (s1.startsWith(File.separator)) {
                        s1 = s1.substring(File.separator.length());
                    }
                    fileMap.put(file, "_extra_" + File.separator + s1);
                }
            };
            for (String s : FTBUtilitiesConfig.backups.extra_files) {
                consumer.accept(new File(s));
            }
            new BackupEvent.Pre(consumer).post();
            for (File file : FileUtils.listTree((File)src)) {
                String filePath = file.getAbsolutePath();
                fileMap.put(file, src.getName() + File.separator + filePath.substring(src.getAbsolutePath().length() + 1, filePath.length()));
            }
            for (Map.Entry entry : fileMap.entrySet()) {
                fileSize += FileUtils.getSize((File)((File)entry.getKey()));
            }
            long totalSize = 0L;
            if (!this.backups.isEmpty()) {
                this.backups.sort(null);
                int backupsToKeep = FTBUtilitiesConfig.backups.backups_to_keep - 1;
                if (backupsToKeep > 0 && this.backups.size() > backupsToKeep) {
                    while (this.backups.size() > backupsToKeep) {
                        Backup backup = this.backups.remove(0);
                        FTBUtilities.LOGGER.info("Deleting old backup: " + backup.fileId);
                        FileUtils.delete((File)backup.getFile());
                    }
                }
                for (Backup backup : this.backups) {
                    totalSize += backup.size;
                }
                if (fileSize > 0L) {
                    long freeSpace = Math.min(FTBUtilitiesConfig.backups.getMaxTotalSize(), this.backupsFolder.getFreeSpace());
                    while (totalSize + fileSize > freeSpace && !this.backups.isEmpty()) {
                        Backup backup = this.backups.remove(0);
                        totalSize -= backup.size;
                        FTBUtilities.LOGGER.info("Deleting backup to free space: " + backup.fileId);
                        FileUtils.delete((File)backup.getFile());
                    }
                }
            }
            this.totalFiles = fileMap.size();
            FTBUtilities.LOGGER.info("Backing up " + this.totalFiles + " files...");
            this.printFiles = true;
            if (FTBUtilitiesConfig.backups.compression_level > 0) {
                out.append(".zip");
                dstFile = FileUtils.newFile((File)new File(this.backupsFolder, out.toString()));
                long start = System.currentTimeMillis();
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
                zos.setLevel(FTBUtilitiesConfig.backups.compression_level);
                byte[] buffer = new byte[4096];
                FTBUtilities.LOGGER.info("Compressing " + this.totalFiles + " files...");
                this.currentFile = 0;
                for (Map.Entry entry : fileMap.entrySet()) {
                    try {
                        int len;
                        ZipEntry ze = new ZipEntry((String)entry.getValue());
                        this.currentFileName = (String)entry.getValue();
                        zos.putNextEntry(ze);
                        FileInputStream fis = new FileInputStream((File)entry.getKey());
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        fis.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++this.currentFile;
                }
                zos.close();
                fileSize = FileUtils.getSize((File)dstFile);
                FTBUtilities.LOGGER.info("Done compressing in " + StringUtils.getTimeString((long)(System.currentTimeMillis() - start)) + " seconds (" + FileUtils.getSizeString((double)fileSize) + ")!");
            } else {
                dstFile = new File(new File(this.backupsFolder, out.toString()), src.getName());
                dstFile.mkdirs();
                this.currentFile = 0;
                for (Map.Entry entry : fileMap.entrySet()) {
                    try {
                        File file = (File)entry.getKey();
                        this.currentFileName = (String)entry.getValue();
                        File dst1 = new File(dstFile, (String)entry.getValue());
                        FileUtils.copyFile((File)file, (File)dst1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++this.currentFile;
                }
            }
            FTBUtilities.LOGGER.info("Created " + dstFile.getAbsolutePath() + " from " + src.getAbsolutePath());
            success = true;
        }
        catch (Exception ex) {
            if (!FTBUtilitiesConfig.backups.silent) {
                this.notifyAll(server, player -> FTBUtilities.lang(player, "ftbutilities.lang.backup.fail", ex.getClass().getName()), true);
            }
            ex.printStackTrace();
            error = ex;
        }
        this.printFiles = false;
        if (error != null && dstFile != null) {
            FileUtils.delete(dstFile);
        }
        Backup backup = new Backup(time.getTimeInMillis(), out.toString().replace('\\', '/'), this.getLastIndex() + 1, success, fileSize);
        this.backups.add(backup);
        new BackupEvent.Post(backup, error).post();
        JsonArray array = new JsonArray();
        for (Backup backup1 : this.backups) {
            array.add((JsonElement)backup1.toJsonObject());
        }
        JsonUtils.toJson((File)new File(this.backupsFolder, "backups.json"), (JsonElement)array);
        if (error == null && FTBUtilitiesConfig.backups.silent) {
            String timeString = StringUtils.getTimeString((long)(System.currentTimeMillis() - time.getTimeInMillis()));
            if (FTBUtilitiesConfig.backups.display_file_size) {
                long totalSize = 0L;
                for (Backup backup1 : this.backups) {
                    totalSize += backup1.size;
                }
                String sizeB = FileUtils.getSizeString((double)fileSize);
                String sizeT = FileUtils.getSizeString((double)totalSize);
                this.notifyAll(server, player -> FTBUtilities.lang(player, "ftbutilities.lang.backup.end_2", timeString, sizeB.equals(sizeT) ? sizeB : sizeB + " | " + sizeT), false);
            } else {
                this.notifyAll(server, player -> FTBUtilities.lang(player, "ftbutilities.lang.backup.end_1", timeString), false);
            }
        }
        this.doingBackup = 2;
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    private int getLastIndex() {
        int i = 0;
        for (Backup b : this.backups) {
            i = Math.max(i, b.index);
        }
        return i;
    }

    static {
        NOTIFICATION_ID = new ResourceLocation("ftbutilities", "backup");
    }
}

