/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.events.universe.UniverseClosedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseLoadedEvent;
import com.feed_the_beast.ftblib.events.universe.UniverseSavedEvent;
import com.feed_the_beast.ftblib.lib.EventHandler;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.Badges;
import com.feed_the_beast.ftbutilities.data.BlockDimPosStorage;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesLoadedChunkManager;
import com.feed_the_beast.ftbutilities.data.backups.Backups;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@EventHandler
public class FTBUtilitiesUniverseData {
    public static long shutdownTime;
    public static final BlockDimPosStorage WARPS;
    private static final List<String> worldLog;

    public static boolean isInSpawn(MinecraftServer server, ChunkDimPos pos) {
        if (pos.dim != 0 || !server.func_71262_S() && !FTBUtilitiesConfig.world.spawn_area_in_sp) {
            return false;
        }
        int radius = FTBUtilitiesConfig.world.spawn_radius;
        if (radius <= 0) {
            return false;
        }
        BlockPos c = server.func_71218_a(0).func_175694_M();
        int minX = MathUtils.chunk((int)(c.func_177958_n() - radius));
        int minZ = MathUtils.chunk((int)(c.func_177952_p() - radius));
        int maxX = MathUtils.chunk((int)(c.func_177958_n() + radius));
        int maxZ = MathUtils.chunk((int)(c.func_177952_p() + radius));
        return pos.posX >= minX && pos.posX <= maxX && pos.posZ >= minZ && pos.posZ <= maxZ;
    }

    @SubscribeEvent
    public static void onUniversePreLoaded(UniverseLoadedEvent.Pre event) {
        if (FTBUtilitiesConfig.world.chunk_claiming) {
            ClaimedChunks.instance = new ClaimedChunks(event.getUniverse());
        }
        Ranks.INSTANCE = new Ranks(event.getUniverse());
    }

    @SubscribeEvent
    public static void onUniversePostLoaded(UniverseLoadedEvent.Post event) {
        NBTTagCompound nbt = event.getData("ftbutilities");
        WARPS.deserializeNBT(nbt.func_74775_l("Warps"));
    }

    @SubscribeEvent
    public static void onUniverseLoaded(UniverseLoadedEvent.Finished event) {
        long now = System.currentTimeMillis();
        shutdownTime = 0L;
        Backups.INSTANCE.nextBackup = now + FTBUtilitiesConfig.backups.time();
        if (FTBUtilitiesConfig.auto_shutdown.enabled && FTBUtilitiesConfig.auto_shutdown.times.length > 0 && event.getUniverse().server.func_71262_S()) {
            Calendar calendar = Calendar.getInstance();
            int currentTime = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
            ArrayList<Integer> times = new ArrayList<Integer>(FTBUtilitiesConfig.auto_shutdown.times.length);
            for (String s0 : FTBUtilitiesConfig.auto_shutdown.times) {
                try {
                    String[] s = s0.split(":", 2);
                    int t = Integer.parseInt(s[0]) * 3600 + Integer.parseInt(s[1]) * 60;
                    if (t <= currentTime) {
                        t += 86400;
                    }
                    times.add(t);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            times.sort(null);
            Iterator iterator = times.iterator();
            while (iterator.hasNext()) {
                int time = (Integer)iterator.next();
                if (time <= currentTime) continue;
                shutdownTime = now + (long)(time - currentTime) * 1000L;
                break;
            }
            FTBUtilities.LOGGER.info("Server will shut down in " + StringUtils.getTimeString((long)(shutdownTime - now)));
        }
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.nextChunkloaderUpdate = now + 1000L;
        }
        Badges.LOCAL_BADGES.clear();
    }

    public static void worldLog(String s) {
        StringBuilder out = new StringBuilder();
        Calendar time = Calendar.getInstance();
        FTBUtilitiesUniverseData.appendNum(out, time.get(1), '-');
        FTBUtilitiesUniverseData.appendNum(out, time.get(2) + 1, '-');
        FTBUtilitiesUniverseData.appendNum(out, time.get(5), ' ');
        FTBUtilitiesUniverseData.appendNum(out, time.get(11), ':');
        FTBUtilitiesUniverseData.appendNum(out, time.get(12), ':');
        FTBUtilitiesUniverseData.appendNum(out, time.get(13), ' ');
        out.append(':');
        out.append(' ');
        out.append(s);
        worldLog.add(out.toString());
        Universe.get().markDirty();
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    @SubscribeEvent
    public static void onUniverseSaved(UniverseSavedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.processQueue();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Warps", (NBTBase)WARPS.serializeNBT());
        event.setData("ftbutilities", nbt);
        if (!worldLog.isEmpty()) {
            ArrayList<String> worldLogCopy = new ArrayList<String>(worldLog);
            worldLog.clear();
            ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(FileUtils.newFile((File)new File(CommonUtils.folderMinecraft, "logs/world.log")), true)));){
                    for (String s : worldLogCopy) {
                        out.println(s);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public static void onUniverseClosed(UniverseClosedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.clear();
            ClaimedChunks.instance = null;
        }
        FTBUtilitiesLoadedChunkManager.INSTANCE.clear();
        Badges.BADGE_CACHE.clear();
        Badges.LOCAL_BADGES.clear();
    }

    static {
        WARPS = new BlockDimPosStorage();
        worldLog = new ArrayList<String>();
    }
}

