/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.EnumMessageLocation;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.IHasCache;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.math.TeleporterDimPos;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.IScheduledTask;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftblib.lib.util.misc.TimeType;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.BlockDimPosStorage;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUtilitiesPlayerData
implements INBTSerializable<NBTTagCompound>,
IHasCache {
    public final ForgePlayer player;
    private final ConfigBoolean renderBadge = new ConfigBoolean(true);
    private final ConfigBoolean disableGlobalBadge = new ConfigBoolean(false);
    private final ConfigBoolean enablePVP = new ConfigBoolean(true);
    private final ConfigString nickname = new ConfigString("");
    private final ConfigEnum<EnumMessageLocation> afkMesageLocation = new ConfigEnum(EnumMessageLocation.NAME_MAP);
    public ForgeTeam lastChunkTeam;
    public final Collection<ForgePlayer> tpaRequestsFrom;
    public long afkTicks;
    private ITextComponent cachedNameForChat;
    private BlockDimPos lastDeath;
    private BlockDimPos lastSafePos;
    private long[] lastTeleport;
    public final BlockDimPosStorage homes;
    private boolean fly;

    public FTBUtilitiesPlayerData(ForgePlayer p) {
        this.player = p;
        this.homes = new BlockDimPosStorage();
        this.tpaRequestsFrom = new HashSet<ForgePlayer>();
        this.lastTeleport = new long[Timer.VALUES.length];
    }

    public static FTBUtilitiesPlayerData get(ForgePlayer player) {
        return (FTBUtilitiesPlayerData)player.getData().get("ftbutilities");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("RenderBadge", this.renderBadge.getBoolean());
        nbt.func_74757_a("DisableGlobalBadges", this.disableGlobalBadge.getBoolean());
        nbt.func_74757_a("EnablePVP", this.enablePVP.getBoolean());
        nbt.func_74782_a("Homes", (NBTBase)this.homes.serializeNBT());
        nbt.func_74757_a("AllowFlying", this.fly);
        if (this.lastDeath != null) {
            nbt.func_74783_a("LastDeath", this.lastDeath.toIntArray());
        }
        nbt.func_74778_a("Nickname", this.nickname.getString());
        nbt.func_74778_a("AFK", this.afkMesageLocation.getString());
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.renderBadge.setBoolean(!nbt.func_74764_b("RenderBadge") || nbt.func_74767_n("RenderBadge"));
        this.disableGlobalBadge.setBoolean(nbt.func_74767_n("DisableGlobalBadges"));
        this.enablePVP.setBoolean(!nbt.func_74764_b("EnablePVP") || nbt.func_74767_n("EnablePVP"));
        this.homes.deserializeNBT(nbt.func_74775_l("Homes"));
        this.fly = nbt.func_74767_n("AllowFlying");
        this.lastDeath = BlockDimPos.fromIntArray((int[])nbt.func_74759_k("LastDeath"));
        this.nickname.setString(nbt.func_74779_i("Nickname"));
        this.afkMesageLocation.setValue(nbt.func_74779_i("AFK"));
    }

    public void addConfig(ConfigGroup group) {
        group.setGroupName("ftbutilities", (ITextComponent)new TextComponentString("FTB Utilities"));
        group.add("ftbutilities", "render_badge", (ConfigValue)this.renderBadge);
        group.add("ftbutilities", "disable_global_badge", (ConfigValue)this.disableGlobalBadge);
        group.add("ftbutilities", "enable_pvp", (ConfigValue)this.enablePVP);
        if (FTBUtilitiesConfig.commands.nick && this.player.hasPermission("ftbutilities.nickname.set")) {
            group.add("ftbutilities", "nickname", (ConfigValue)this.nickname);
        }
        if (FTBUtilitiesConfig.afk.isEnabled(this.player.team.universe.server)) {
            group.add("ftbutilities", "afk", this.afkMesageLocation);
        }
    }

    public boolean renderBadge() {
        return this.renderBadge.getBoolean();
    }

    public boolean disableGlobalBadge() {
        return this.disableGlobalBadge.getBoolean();
    }

    public boolean enablePVP() {
        return this.enablePVP.getBoolean();
    }

    public String getNickname() {
        return this.nickname.getString();
    }

    public void setNickname(String name) {
        this.nickname.setString(name.equals(this.player.func_176610_l()) ? "" : name);
        this.player.markDirty();
        this.clearCache();
    }

    public EnumMessageLocation getAFKMessageLocation() {
        return (EnumMessageLocation)this.afkMesageLocation.getValue();
    }

    public void setFly(boolean v) {
        this.fly = v;
        this.player.markDirty();
    }

    public boolean getFly() {
        return this.fly;
    }

    public void setLastDeath(@Nullable BlockDimPos pos) {
        this.lastDeath = pos;
        this.player.markDirty();
    }

    @Nullable
    public BlockDimPos getLastDeath() {
        return this.lastDeath;
    }

    public void setLastSafePos(@Nullable BlockDimPos pos) {
        this.lastSafePos = pos;
        this.player.markDirty();
    }

    @Nullable
    public BlockDimPos getLastSafePos() {
        return this.lastSafePos;
    }

    public void checkTeleportCooldown(ICommandSender sender, Timer timer) throws CommandException {
        long cooldown = this.lastTeleport[timer.ordinal()] + this.player.getRankConfig(timer.cooldown).getLong() - this.player.team.universe.world.func_82737_E();
        if (cooldown > 0L) {
            throw FTBLib.error((ICommandSender)sender, (String)"cant_use_now_cooldown", (Object[])new Object[]{StringUtils.getTimeStringTicks((long)cooldown)});
        }
    }

    public void clearCache() {
        this.cachedNameForChat = null;
        if (this.player.isOnline()) {
            this.player.getPlayer().refreshDisplayName();
        }
    }

    public ITextComponent getNameForChat(Rank rank) {
        FTBUtilitiesPermissions.ChatPart chatPart;
        int i;
        int partCount;
        if (this.cachedNameForChat != null) {
            return this.cachedNameForChat;
        }
        this.cachedNameForChat = new TextComponentString("");
        JsonElement json0 = rank.getConfigRaw(FTBUtilitiesPermissions.CHAT_PREFIX_PART_COUNT);
        int n = partCount = json0.isJsonPrimitive() ? json0.getAsInt() : 0;
        if (partCount <= 0) {
            this.cachedNameForChat.func_150258_a("<");
        } else {
            for (i = 0; i < partCount; ++i) {
                chatPart = new FTBUtilitiesPermissions.ChatPart("prefix." + (i + 1));
                json0 = rank.getConfigRaw(chatPart.text);
                if (!json0.isJsonPrimitive()) continue;
                this.cachedNameForChat.func_150257_a(chatPart.format(rank, (ITextComponent)new TextComponentString(json0.getAsString()), FTBUtilitiesPermissions.CHAT_PREFIX));
            }
        }
        json0 = rank.getConfigRaw(FTBUtilitiesPermissions.CHAT_NAME.text);
        if (json0.isJsonPrimitive() && !json0.getAsString().isEmpty()) {
            this.cachedNameForChat.func_150257_a(FTBUtilitiesPermissions.CHAT_NAME.format(rank, (ITextComponent)new TextComponentString(json0.getAsString()), null));
        } else {
            this.cachedNameForChat.func_150257_a(FTBUtilitiesPermissions.CHAT_NAME.format(rank, this.player.getDisplayName(), null));
        }
        json0 = rank.getConfigRaw(FTBUtilitiesPermissions.CHAT_SUFFIX_PART_COUNT);
        int n2 = partCount = json0.isJsonPrimitive() ? json0.getAsInt() : 0;
        if (partCount <= 0) {
            this.cachedNameForChat.func_150258_a(">");
        } else {
            for (i = 0; i < partCount; ++i) {
                chatPart = new FTBUtilitiesPermissions.ChatPart("suffix." + (i + 1));
                json0 = rank.getConfigRaw(chatPart.text);
                if (!json0.isJsonPrimitive()) continue;
                this.cachedNameForChat.func_150257_a(chatPart.format(rank, (ITextComponent)new TextComponentString(json0.getAsString()), FTBUtilitiesPermissions.CHAT_SUFFIX));
            }
        }
        this.cachedNameForChat.func_150258_a(" ");
        return this.cachedNameForChat;
    }

    private static class TeleportTask
    implements IScheduledTask {
        private final EntityPlayerMP player;
        private final Timer timer;
        private final BlockDimPos startPos;
        private final TeleporterDimPos pos;
        private final float startHP;
        private final int startSeconds;
        private final int secondsLeft;
        private final IScheduledTask extraTask;

        private TeleportTask(EntityPlayerMP p, Timer t, int ss, int s, TeleporterDimPos to, @Nullable IScheduledTask e) {
            this.player = p;
            this.timer = t;
            this.startPos = new BlockDimPos((Entity)this.player);
            this.startHP = this.player.func_110143_aJ();
            this.pos = to;
            this.startSeconds = ss;
            this.secondsLeft = s;
            this.extraTask = e;
        }

        public void execute(Universe universe) {
            if (!this.startPos.equalsPos(new BlockDimPos((Entity)this.player)) || this.startHP != this.player.func_110143_aJ()) {
                this.player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)this.player, (String)"stand_still_failed", (Object[])new Object[0]), (TextFormatting)TextFormatting.RED), true);
            } else if (this.secondsLeft <= 1) {
                this.pos.teleport((Entity)this.player);
                FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)this.player));
                ((FTBUtilitiesPlayerData)data).lastTeleport[this.timer.ordinal()] = universe.world.func_82737_E();
                if (this.secondsLeft != 0) {
                    this.player.func_146105_b(FTBLib.lang((ICommandSender)this.player, (String)"teleporting", (Object[])new Object[0]), true);
                }
                if (this.extraTask != null) {
                    this.extraTask.execute(universe);
                }
            } else {
                universe.scheduleTask(TimeType.MILLIS, System.currentTimeMillis() + 1000L, (IScheduledTask)new TeleportTask(this.player, this.timer, this.startSeconds, this.secondsLeft - 1, this.pos, this.extraTask));
                this.player.func_146105_b((ITextComponent)new TextComponentString(Integer.toString(this.secondsLeft - 1)), true);
                this.player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)this.player, (String)"stand_still", (Object[])new Object[]{this.startSeconds}).func_150258_a(" [" + (this.secondsLeft - 1) + "]"), (TextFormatting)TextFormatting.GOLD), true);
            }
        }
    }

    public static enum Timer {
        HOME(FTBUtilitiesPermissions.HOMES_COOLDOWN, FTBUtilitiesPermissions.HOMES_WARMUP),
        WARP(FTBUtilitiesPermissions.WARPS_COOLDOWN, FTBUtilitiesPermissions.WARPS_WARMUP),
        BACK(FTBUtilitiesPermissions.BACK_COOLDOWN, FTBUtilitiesPermissions.BACK_WARMUP),
        SPAWN(FTBUtilitiesPermissions.SPAWN_COOLDOWN, FTBUtilitiesPermissions.SPAWN_WARMUP),
        TPA(FTBUtilitiesPermissions.TPA_COOLDOWN, FTBUtilitiesPermissions.TPA_WARMUP);

        public static final Timer[] VALUES;
        private final Node cooldown;
        private final Node warmup;

        private Timer(Node c, Node w) {
            this.cooldown = c;
            this.warmup = w;
        }

        public void teleport(EntityPlayerMP player, TeleporterDimPos pos, @Nullable IScheduledTask extraTask) {
            Universe universe = Universe.get();
            int seconds = (int)Ticks.ts((long)RankConfigAPI.get((EntityPlayerMP)player, (Node)this.warmup).getLong());
            if (seconds > 0) {
                player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)player, (String)"stand_still", (Object[])new Object[]{seconds}).func_150258_a(" [" + seconds + "]"), (TextFormatting)TextFormatting.GOLD), true);
                universe.scheduleTask(TimeType.MILLIS, System.currentTimeMillis() + 1000L, (IScheduledTask)new TeleportTask(player, this, seconds, seconds, pos, extraTask));
            } else {
                new TeleportTask(player, this, 0, 0, pos, extraTask).execute(universe);
            }
        }

        public void teleport(EntityPlayerMP player, BlockDimPos pos, @Nullable IScheduledTask extraTask) {
            this.teleport(player, pos.teleporter(), extraTask);
        }

        static {
            VALUES = Timer.values();
        }
    }
}

