/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.rangedpumps.tile;

import com.raoulvdberge.rangedpumps.RangedPumps;
import com.raoulvdberge.rangedpumps.tile.PumpState;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;

public class TilePump
extends TileEntity
implements ITickable {
    private FluidTank tank;
    private IEnergyStorage energy;
    private int ticks;
    @Nullable
    private BlockPos currentPos;
    private int range;
    private Queue<BlockPos> surfaces;

    public TilePump() {
        this.energy = new EnergyStorage(RangedPumps.INSTANCE.energyCapacity);
        this.range = -1;
        this.surfaces = new LinkedList<BlockPos>();
        this.tank = new FluidTank(RangedPumps.INSTANCE.tankCapacity){

            protected void onContentsChanged() {
                super.onContentsChanged();
                TilePump.this.func_70296_d();
            }
        };
        this.tank.setCanFill(false);
    }

    private void rebuildSurfaces() {
        int i;
        this.surfaces.clear();
        if (this.range == -1) {
            this.surfaces.add(this.field_174879_c.func_177977_b());
            return;
        }
        int hl = 3 + 2 * this.range;
        int vl = 1 + 2 * this.range;
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1 + i, -1, -this.range - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1 + vl + 1, -1, -this.range - 1 + i + 1));
        }
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1 + hl - i - 1, -1, -this.range - 1 + hl - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.field_174879_c.func_177982_a(-this.range - 1, -1, -this.range - 1 + vl - i));
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.surfaces.isEmpty()) {
            this.rebuildSurfaces();
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!RangedPumps.INSTANCE.usesEnergy) {
            this.energy.receiveEnergy(this.energy.getMaxEnergyStored(), false);
        }
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            LinkedList<IFluidHandler> fluidHandlers = new LinkedList<IFluidHandler>();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IFluidHandler handler;
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) || (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) == null) continue;
                fluidHandlers.add(handler);
            }
            if (!fluidHandlers.isEmpty()) {
                int transfer = (int)Math.floor((float)this.tank.getFluidAmount() / (float)fluidHandlers.size());
                for (IFluidHandler fluidHandler : fluidHandlers) {
                    FluidStack toFill = this.tank.getFluid().copy();
                    toFill.amount = transfer;
                    this.tank.drain(fluidHandler.fill(toFill, true), true);
                }
            }
        }
        if ((RangedPumps.INSTANCE.speed == 0 || this.ticks % RangedPumps.INSTANCE.speed == 0) && this.getState() == PumpState.WORKING) {
            FluidStack drained;
            if (this.currentPos == null || this.currentPos.func_177956_o() == 0) {
                if (this.surfaces.isEmpty()) {
                    ++this.range;
                    if (this.range > RangedPumps.INSTANCE.range) {
                        return;
                    }
                    this.rebuildSurfaces();
                }
                this.currentPos = this.surfaces.poll();
            } else {
                this.currentPos = this.currentPos.func_177977_b();
            }
            this.energy.extractEnergy(RangedPumps.INSTANCE.energyUsagePerMove, false);
            Block block = this.func_145831_w().func_180495_p(this.currentPos).func_177230_c();
            BlockLiquidWrapper handler = null;
            if (block instanceof BlockLiquid) {
                handler = new BlockLiquidWrapper((BlockLiquid)block, this.func_145831_w(), this.currentPos);
            } else if (block instanceof IFluidBlock) {
                handler = new FluidBlockWrapper((IFluidBlock)block, this.func_145831_w(), this.currentPos);
            }
            if (handler != null && (drained = handler.drain(RangedPumps.INSTANCE.tankCapacity, false)) != null && this.tank.fillInternal(drained, false) == drained.amount) {
                this.tank.fillInternal(handler.drain(RangedPumps.INSTANCE.tankCapacity, true), true);
                if (RangedPumps.INSTANCE.replaceLiquidWithStone) {
                    this.field_145850_b.func_175656_a(this.currentPos, Blocks.field_150348_b.func_176223_P());
                }
                this.energy.extractEnergy(RangedPumps.INSTANCE.energyUsagePerDrain, false);
            }
            this.func_70296_d();
        }
        ++this.ticks;
    }

    BlockPos getCurrentPosition() {
        return this.currentPos == null ? this.field_174879_c.func_177977_b() : this.currentPos;
    }

    int getRange() {
        return this.range;
    }

    PumpState getState() {
        if (this.range > RangedPumps.INSTANCE.range) {
            return PumpState.DONE;
        }
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return PumpState.REDSTONE;
        }
        if (this.energy.getEnergyStored() == 0) {
            return PumpState.ENERGY;
        }
        if (this.tank.getFluidAmount() > this.tank.getCapacity() - 1000) {
            return PumpState.FULL;
        }
        return PumpState.WORKING;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        if (this.currentPos != null) {
            tag.func_74772_a("CurrentPos", this.currentPos.func_177986_g());
        }
        tag.func_74768_a("Range", this.range);
        NBTTagList surfaces = new NBTTagList();
        this.surfaces.forEach(s -> surfaces.func_74742_a((NBTBase)new NBTTagLong(s.func_177986_g())));
        tag.func_74782_a("Surfaces", (NBTBase)surfaces);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Energy")) {
            this.energy.receiveEnergy(tag.func_74762_e("Energy"), false);
        }
        if (tag.func_74764_b("CurrentPos")) {
            this.currentPos = BlockPos.func_177969_a((long)tag.func_74763_f("CurrentPos"));
        }
        if (tag.func_74764_b("Range")) {
            this.range = tag.func_74762_e("Range");
        }
        if (tag.func_74764_b("Surfaces")) {
            NBTTagList surfaces = tag.func_150295_c("Surfaces", 4);
            for (NBTBase surface : surfaces) {
                this.surfaces.add(BlockPos.func_177969_a((long)((NBTTagLong)surface).func_150291_c()));
            }
        }
        this.tank.readFromNBT(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return (T)super.getCapability(capability, facing);
    }
}

