/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.silentchaos512.gems.block.BlockGemOre;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.lib.EnumGem;

public class GeodeGenerator
extends WorldGenMinable {
    private final EnumGem.Set gemSet;
    private final IBlockState shellBlock;
    private Predicate<IBlockState> predicate;

    public GeodeGenerator(IBlockState shell, EnumGem.Set gemSet) {
        super(shell, 30);
        this.gemSet = gemSet;
        this.shellBlock = shell;
        this.predicate = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
    }

    public GeodeGenerator(IBlockState shell, EnumGem.Set gemSet, Predicate<IBlockState> predicate) {
        super(shell, 30, predicate);
        this.gemSet = gemSet;
        this.shellBlock = shell;
        this.predicate = predicate;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        float diameterXZ = 2.0f * rand.nextFloat() + 5.0f;
        float diameterY = 3.0f * rand.nextFloat() + 7.0f;
        this.generateShell(worldIn, rand, position, diameterXZ, diameterY);
        this.generateGems(worldIn, rand, position, diameterXZ, diameterY);
        return true;
    }

    public void generateShell(World worldIn, Random rand, BlockPos position, float diameterXZ, float diameterY) {
        int xmin = (int)((float)position.func_177958_n() - diameterXZ / 2.0f);
        int xmax = (int)((float)position.func_177958_n() + diameterXZ / 2.0f);
        int ymin = (int)((float)position.func_177956_o() - diameterY / 2.0f);
        int ymax = (int)((float)position.func_177956_o() + diameterY / 2.0f);
        int zmin = (int)((float)position.func_177952_p() - diameterXZ / 2.0f);
        int zmax = (int)((float)position.func_177952_p() + diameterXZ / 2.0f);
        int count = 0;
        for (int x = xmin; x <= xmax; ++x) {
            float dx = x - position.func_177958_n();
            for (int y = ymin; y <= ymax; ++y) {
                float dy = y - position.func_177956_o();
                for (int z = zmin; z <= zmax; ++z) {
                    float dz = z - position.func_177952_p();
                    if (!(dx * dx / (diameterXZ * diameterXZ) + dy * dy / (diameterY * diameterY) + dz * dz / (diameterXZ * diameterXZ) <= 0.25f)) continue;
                    ++count;
                    BlockPos blockpos = new BlockPos(x, y, z);
                    IBlockState state = worldIn.func_180495_p(blockpos);
                    if (!state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, this.predicate)) continue;
                    worldIn.func_180501_a(blockpos, this.shellBlock, 2);
                }
            }
        }
    }

    public void generateGems(World worldIn, Random rand, BlockPos position, float diameterXZ, float diameterY) {
        BlockMatcher shellPredicate = BlockMatcher.func_177642_a((Block)this.shellBlock.func_177230_c());
        int xmin = (int)((float)position.func_177958_n() - (diameterXZ *= GemsConfig.GEODE_FILL_RATIO) / 2.0f);
        int xmax = (int)((float)position.func_177958_n() + diameterXZ / 2.0f);
        int ymin = (int)((float)position.func_177956_o() - (diameterY *= GemsConfig.GEODE_FILL_RATIO) / 2.0f);
        int ymax = (int)((float)position.func_177956_o() + diameterY / 2.0f);
        int zmin = (int)((float)position.func_177952_p() - diameterXZ / 2.0f);
        int zmax = (int)((float)position.func_177952_p() + diameterXZ / 2.0f);
        BlockGemOre block = this.gemSet == EnumGem.Set.LIGHT ? ModBlocks.gemOreLight : (this.gemSet == EnumGem.Set.DARK ? ModBlocks.gemOreDark : ModBlocks.gemOre);
        int count = 0;
        for (int x = xmin; x <= xmax; ++x) {
            float dx = x - position.func_177958_n();
            for (int y = ymin; y <= ymax; ++y) {
                float dy = y - position.func_177956_o();
                for (int z = zmin; z <= zmax; ++z) {
                    float dz = z - position.func_177952_p();
                    count = this.tryPlaceGem(worldIn, rand, position, diameterXZ, diameterY, (Predicate)shellPredicate, (Block)block, count, x, dx, y, dy, z, dz);
                }
            }
        }
    }

    private int tryPlaceGem(World worldIn, Random rand, BlockPos position, float diameterXZ, float diameterY, Predicate shellPredicate, Block block, int count, int x, float dx, int y, float dy, int z, float dz) {
        if (dx * dx / (diameterXZ * diameterXZ) + dy * dy / (diameterY * diameterY) + dz * dz / (diameterXZ * diameterXZ) <= 0.25f && rand.nextFloat() <= GemsConfig.GEODE_GEM_DENSITY) {
            ++count;
            BlockPos blockpos = new BlockPos(x, y, z);
            IBlockState state = worldIn.func_180495_p(blockpos);
            if (state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos, shellPredicate)) {
                EnumGem gem = EnumGem.values()[rand.nextInt(16)];
                IBlockState stateToPlace = block.func_176223_P().func_177226_a((IProperty)EnumGem.VARIANT_GEM, (Comparable)((Object)gem));
                worldIn.func_180501_a(blockpos, stateToPlace, 2);
                if (GemsConfig.GEODE_SEAL_BREAKS) {
                    for (EnumFacing facing : EnumFacing.values()) {
                        BlockPos offset = position.func_177972_a(facing);
                        IBlockState adjacent = worldIn.func_180495_p(offset);
                        if (!worldIn.func_175623_d(offset) && (adjacent == this.shellBlock || adjacent.func_177230_c() == block)) continue;
                        worldIn.func_175656_a(offset, this.shellBlock);
                    }
                }
            }
        }
        return count;
    }
}

