/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.BlockEssenceOre;
import net.silentchaos512.gems.config.ConfigOptionOreGen;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.util.WeightedRandomItemSG;
import net.silentchaos512.lib.world.WorldGeneratorSL;

public class GemsWorldGenerator
extends WorldGeneratorSL {
    static final Predicate PREDICATE_STONE = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
    static final Predicate PREDICATE_NETHERRACK = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
    static final Predicate PREDICATE_END_STONE = BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs);

    public GemsWorldGenerator() {
        super(true, "silentgems_retrogen");
    }

    protected void generateSurface(World world, Random random, int posX, int posZ) {
        this.generateFlowers(world, random, posX, posZ);
        this.generateChaosNodes(world, random, posX, posZ);
        this.generateOres(world, random, posX, posZ, GemsConfig.WORLD_GEN_GEMS, PREDICATE_STONE);
        this.generateOres(world, random, posX, posZ, GemsConfig.WORLD_GEN_CHAOS, PREDICATE_STONE);
    }

    protected void generateNether(World world, Random random, int posX, int posZ) {
        this.generateOres(world, random, posX, posZ, GemsConfig.WORLD_GEN_GEMS_DARK, PREDICATE_NETHERRACK);
    }

    protected void generateEnd(World world, Random random, int posX, int posZ) {
        this.generateOres(world, random, posX, posZ, GemsConfig.WORLD_GEN_ENDER, PREDICATE_END_STONE);
        this.generateOres(world, random, posX, posZ, GemsConfig.WORLD_GEN_GEMS_LIGHT, PREDICATE_END_STONE);
    }

    protected void generateOres(World world, Random random, int posX, int posZ, ConfigOptionOreGen config, Predicate predicate) {
        int dimension = world.field_73011_w.getDimension();
        if (config.isEnabled() && config.canSpawnInDimension(dimension)) {
            int veinCount = config.getVeinCount(random);
            int veinSize = config.veinSize;
            for (int i = 0; i < veinCount; ++i) {
                BlockPos pos = config.getRandomPos(random, posX, posZ);
                IBlockState state = this.selectState(config, random, world, posX, posZ);
                new WorldGenMinable(state, veinSize, predicate).func_180709_b(world, random, pos);
            }
        }
    }

    protected IBlockState selectState(ConfigOptionOreGen config, Random random, World world, int posX, int posZ) {
        if (config == GemsConfig.WORLD_GEN_GEMS) {
            EnumGem gem;
            if (GemsConfig.GEM_REGIONS_ENABLED) {
                long dimension = world.field_73011_w.getDimension();
                long cx = (long)posX / 16L / (long)GemsConfig.GEM_REGIONS_SIZE;
                long cz = (long)posZ / 16L / (long)GemsConfig.GEM_REGIONS_SIZE;
                long seed = world.func_72905_C() << 40 | (dimension & 0xFFL) << 32 | (cz & 0xFFFFL) << 16 | cx & 0xFFFFL;
                Random regionRandom = new Random(seed);
                EnumGem firstGem = EnumGem.values()[regionRandom.nextInt(16)];
                EnumGem secondGem = EnumGem.values()[regionRandom.nextInt(16)];
                gem = regionRandom.nextFloat() < GemsConfig.GEM_REGIONS_SECOND_GEM_CHANCE && random.nextBoolean() ? secondGem : firstGem;
            } else {
                int meta = ((WeightedRandomItemSG)WeightedRandom.func_76271_a((Random)random, GemsConfig.GEM_WEIGHTS)).getMeta();
                gem = EnumGem.values()[meta];
            }
            return ModBlocks.gemOre.func_176223_P().func_177226_a((IProperty)EnumGem.VARIANT_GEM, (Comparable)((Object)gem));
        }
        if (config == GemsConfig.WORLD_GEN_CHAOS) {
            return ModBlocks.essenceOre.func_176223_P().func_177226_a((IProperty)BlockEssenceOre.VARIANT, (Comparable)((Object)BlockEssenceOre.Type.CHAOS));
        }
        if (config == GemsConfig.WORLD_GEN_GEMS_DARK) {
            int meta = ((WeightedRandomItemSG)WeightedRandom.func_76271_a((Random)random, GemsConfig.GEM_WEIGHTS_DARK)).getMeta();
            EnumGem gem = EnumGem.values()[meta];
            return ModBlocks.gemOreDark.func_176223_P().func_177226_a((IProperty)EnumGem.VARIANT_GEM, (Comparable)((Object)gem));
        }
        if (config == GemsConfig.WORLD_GEN_ENDER) {
            return ModBlocks.essenceOre.func_176223_P().func_177226_a((IProperty)BlockEssenceOre.VARIANT, (Comparable)((Object)BlockEssenceOre.Type.ENDER));
        }
        if (config == GemsConfig.WORLD_GEN_GEMS_LIGHT) {
            int meta = ((WeightedRandomItemSG)WeightedRandom.func_76271_a((Random)random, GemsConfig.GEM_WEIGHTS_LIGHT)).getMeta();
            EnumGem gem = EnumGem.values()[meta];
            return ModBlocks.gemOreLight.func_176223_P().func_177226_a((IProperty)EnumGem.VARIANT_GEM, (Comparable)((Object)gem));
        }
        SilentGems.logHelper.severe((Object)("GemsWorldGenerator - Unknown ore config: " + config.name));
        return null;
    }

    private void generateFlowers(World world, Random random, int posX, int posZ) {
        block0: for (int i = 0; i < GemsConfig.GLOW_ROSE_PER_CHUNK; ++i) {
            int y;
            int x = posX + 8 + random.nextInt(16);
            int z = posZ + 8 + random.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            int meta = random.nextInt(16);
            EnumGem gem = EnumGem.values()[meta];
            IBlockState state = ModBlocks.glowRose.func_176223_P().func_177226_a((IProperty)EnumGem.VARIANT_GEM, (Comparable)((Object)gem));
            for (y = random.nextInt(120) + 50; y > 50; --y) {
                if (world.func_175623_d(pos) && pos.func_177956_o() < 255 && ModBlocks.glowRose.func_180671_f(world, pos, state)) {
                    world.func_180501_a(pos, state, 2);
                    continue block0;
                }
                pos = pos.func_177977_b();
            }
        }
    }

    private void generateChaosNodes(World world, Random random, int posX, int posZ) {
        int count = (int)GemsConfig.CHAOS_NODES_PER_CHUNK;
        float diff = GemsConfig.CHAOS_NODES_PER_CHUNK - (float)count;
        count += random.nextFloat() < diff ? 1 : 0;
        for (int i = 0; i < count; ++i) {
            int y;
            int x = posX + 8 + random.nextInt(16);
            int z = posZ + 8 + random.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = ModBlocks.chaosNode.func_176223_P();
            for (y = random.nextInt(120) + 120; y > 50 && world.func_175623_d(pos.func_177977_b()); --y) {
                pos = pos.func_177977_b();
            }
            if (!world.func_175623_d(pos = pos.func_177981_b(random.nextInt(3) + 2))) continue;
            world.func_180501_a(pos, state, 2);
        }
    }
}

