/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class Cache<K, V> {
    private final Object2ObjectLinkedOpenCustomHashMap<K, CacheEntry<V>> cacheMap;
    private final Function<K, CacheEntry<V>> loader;
    private final Consumer<V> cleanup;
    private final V fallback;
    private final long age;

    public Cache(Function<K, V> loader, V fallback, int size, long age) {
        this(new NaturalHashStrategy(), loader, fallback, size, age, null);
    }

    public Cache(Hash.Strategy<K> hash, Function<K, V> loader, V fallback, int size, long age, Consumer<V> cleanup) {
        if (hash == null) {
            hash = new NaturalHashStrategy();
        }
        this.cacheMap = new Object2ObjectLinkedOpenCustomHashMap(hash);
        this.loader = key -> {
            if (this.cacheMap.size() >= size && !this.freeCacheSlot()) {
                return null;
            }
            return new CacheEntry(loader.apply(key));
        };
        this.fallback = fallback;
        this.age = age;
        this.cleanup = cleanup;
    }

    public V get(K key) {
        CacheEntry<V> entry = (CacheEntry<V>)this.cacheMap.getAndMoveToLast(key);
        if (entry == null) {
            entry = this.loader.apply(key);
            if (entry == null) {
                return this.fallback;
            }
            this.cacheMap.put(key, entry);
        }
        entry.timeStamp = System.currentTimeMillis();
        return entry.value;
    }

    private boolean freeCacheSlot() {
        CacheEntry entry = (CacheEntry)this.cacheMap.get(this.cacheMap.firstKey());
        if (System.currentTimeMillis() - entry.timeStamp > this.age) {
            this.cacheMap.removeFirst();
            this.cleanup.accept(entry.value);
            return true;
        }
        return false;
    }

    public void clear() {
        this.cacheMap.forEach((k, v) -> this.cleanup.accept(v.value));
        this.cacheMap.clear();
    }

    private static class NaturalHashStrategy<K>
    implements Hash.Strategy<K> {
        private NaturalHashStrategy() {
        }

        public int hashCode(K o) {
            return o.hashCode();
        }

        public boolean equals(K a, K b) {
            return Objects.equals(a, b);
        }
    }

    private static class CacheEntry<V> {
        public final V value;
        public long timeStamp;

        private CacheEntry(V value) {
            this.value = value;
        }
    }
}

