/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemBow
extends ItemBow
implements IRegistryObject,
ITool {
    private static final int MIN_DRAW_DELAY = 10;
    public static final float ENCHANTABILITY_MULTIPLIER = 0.45f;
    public static final ResourceLocation RESOURCE_PULL = new ResourceLocation("pull");
    public static final ResourceLocation RESOURCE_PULLING = new ResourceLocation("pulling");

    public ItemGemBow() {
        this.func_77655_b("silentgems:Bow");
        this.setNoRepair();
        this.func_185043_a(RESOURCE_PULL, new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return StackHelper.isValid((ItemStack)itemstack) && ToolHelper.areToolsEqual(stack, itemstack) ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / ItemGemBow.this.getDrawDelay(stack) : 0.0f;
            }
        });
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.bow;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return StackHelper.empty();
        }
        if (materials.length == 1) {
            return this.constructTool(rod, materials[0], materials[0], materials[0]);
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeDamage(ItemStack tool) {
        return 0.0f;
    }

    @Override
    public float getMagicDamage(ItemStack tool) {
        return 0.0f;
    }

    @Override
    public float getMeleeDamageModifier() {
        return 0.0f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 0.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return 0.0f;
    }

    public float getDrawDelay(ItemStack stack) {
        float mspeed = ToolHelper.getMeleeSpeed(stack);
        float dspeed = ToolHelper.getDigSpeedOnProperMaterial(stack);
        return ItemGemBow.getDrawDelay(mspeed, dspeed);
    }

    public static float getDrawDelay(float meleeSpeed, float digSpeed) {
        return Math.max(32.7f - 1.1f * meleeSpeed * digSpeed, 10.0f);
    }

    public float getDrawSpeedForDisplay(ItemStack stack) {
        return 20.0f / this.getDrawDelay(stack);
    }

    public static float getDrawSpeedForDisplay(float meleeSpeed, float digSpeed) {
        return 20.0f / ItemGemBow.getDrawDelay(meleeSpeed, digSpeed);
    }

    public float getArrowVelocity(ItemStack stack, int charge) {
        float f = (float)charge / this.getDrawDelay(stack);
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.0f ? 1.0f : f;
    }

    public float getArrowDamage(ItemStack stack) {
        return ItemGemBow.getArrowDamage(ToolHelper.getMeleeDamage(stack));
    }

    public static float getArrowDamage(float meleeDamage) {
        return 0.4f * meleeDamage - 1.0f;
    }

    public float getArrowDamageForDisplay(ItemStack stack) {
        return (2.0f + this.getArrowDamage(stack)) / 2.0f;
    }

    public static float getArrowDamageForDisplay(float meleeDamage) {
        return (2.0f + ItemGemBow.getArrowDamage(meleeDamage)) / 2.0f;
    }

    protected ItemStack func_185060_a(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return StackHelper.empty();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean hasAmmo = StackHelper.isValid((ItemStack)this.func_185060_a(player)) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        boolean isBroken = ToolHelper.isBroken(stack);
        if (isBroken) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)hasAmmo);
        if (ret != null && ret.func_188397_a() == EnumActionResult.FAIL) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return !hasAmmo ? new ActionResult(EnumActionResult.FAIL, (Object)stack) : new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean infiniteAmmo = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammo = this.func_185060_a(player);
            int i = this.func_77626_a(stack) - timeLeft;
            if (i < 0) {
                return;
            }
            if (StackHelper.isValid((ItemStack)ammo) || infiniteAmmo) {
                float velocity;
                if (StackHelper.isEmpty((ItemStack)ammo)) {
                    ammo = new ItemStack(Items.field_151032_g);
                }
                if ((double)(velocity = this.getArrowVelocity(stack, i)) >= 0.1) {
                    boolean flag1;
                    boolean bl = flag1 = player.field_71075_bZ.field_75098_d || ammo.func_77973_b() instanceof ItemArrow && ((ItemArrow)ammo.func_77973_b()).isInfinite(ammo, stack, player);
                    if (!worldIn.field_72995_K) {
                        int power;
                        ItemArrow itemarrow = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
                        EntityArrow entityarrow = itemarrow.func_185052_a(worldIn, ammo, (EntityLivingBase)player);
                        entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
                        if (velocity == 1.0f) {
                            entityarrow.func_70243_d(true);
                        }
                        float powerBoost = (power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0 ? (float)power * 0.5f + 0.5f : 0.0f;
                        float damageBoost = this.getArrowDamage(stack);
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)damageBoost + (double)powerBoost);
                        int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                        if (k > 0) {
                            entityarrow.func_70240_a(k);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            entityarrow.func_70015_d(100);
                        }
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        if (flag1) {
                            entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)entityarrow);
                    }
                    worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                    if (!flag1) {
                        StackHelper.shrink((ItemStack)ammo, (int)1);
                        if (StackHelper.getCount((ItemStack)ammo) == 0) {
                            player.field_71071_by.func_184437_d(ammo);
                        }
                    }
                    player.func_71029_a(StatList.func_188057_b((Item)this));
                    ToolHelper.incrementStatShotsFired(stack, 1);
                }
            }
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getMaxDamage(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ToolRenderHelper.instance.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ToolRenderHelper.instance.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ToolRenderHelper.instance.func_77613_e(stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return Math.round((float)ToolHelper.getItemEnchantability(stack) * 0.45f);
    }

    public void func_77663_a(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(tool, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return ToolHelper.onEntityItemUpdate(entityItem);
    }

    public void addOreDict() {
    }

    public void addRecipes(RecipeMaker recipes) {
        if (this.getConfig().isDisabled) {
            return;
        }
        String[] lines = new String[]{"rhw", "h w", "rhw"};
        ToolHelper.addExampleRecipe((Item)this, new EnumMaterialTier[]{EnumMaterialTier.MUNDANE, EnumMaterialTier.REGULAR}, lines, Character.valueOf('w'), new ItemStack(Items.field_151007_F));
        ToolHelper.addExampleRecipe((Item)this, new EnumMaterialTier[]{EnumMaterialTier.SUPER}, lines, Character.valueOf('w'), ModItems.craftingMaterial.gildedString);
    }

    public String getFullName() {
        return this.getModId() + ":" + this.getName();
    }

    public String getModId() {
        return "silentgems";
    }

    public String getName() {
        return "Bow";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        models.put(0, ToolRenderHelper.SMART_MODEL);
    }

    public boolean registerModels() {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        ToolRenderHelper.getInstance().clAddInformation(stack, player.field_70170_p, list, advanced);
    }

    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        ToolRenderHelper.getInstance().clAddInformation(stack, world, list, flag == ITooltipFlag.TooltipFlags.ADVANCED);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        this.clGetSubItems(item, tab, list);
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems(item, tab, (List<ItemStack>)list);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems((Item)this, tab, (List<ItemStack>)list);
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems(item, 3));
    }
}

