/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.lib.ArmorPartPosition;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.client.gui.ModelGemArmor;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.ArmorHelper;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.item.ItemArmorSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemArmor
extends ItemArmorSL
implements ISpecialArmor,
IArmor {
    public static final float[] ABSORPTION_RATIO_BY_SLOT = new float[]{0.175f, 0.3f, 0.4f, 0.125f};
    public static final boolean HAS_EFFECT = false;
    private List<ItemStack> subItems = null;
    public final EntityEquipmentSlot type;

    public ItemGemArmor(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, String name) {
        super("silentgems", name, ItemArmor.ArmorMaterial.DIAMOND, renderIndexIn, equipmentSlotIn);
        this.type = equipmentSlotIn;
        this.setNoRepair();
    }

    public ItemStack constructArmor(EnumMaterialTier tier, ItemStack material) {
        ItemStack frame = ModItems.armorFrame.getFrameForArmorPiece(this.field_77881_a, tier);
        return this.constructArmor(frame, material, material, material, material);
    }

    @Override
    public ItemStack constructArmor(ItemStack frame, ItemStack ... materials) {
        return ArmorHelper.constructArmor((Item)this, frame, materials);
    }

    public float getProtection(ItemStack armor) {
        return ABSORPTION_RATIO_BY_SLOT[this.field_77881_a.func_188454_b()] * ArmorHelper.getProtection(armor);
    }

    public float getToughness(ItemStack stack) {
        float durability = (float)ArmorHelper.getMaxDamage(stack) / 1536.0f;
        float protection = ArmorHelper.getProtection(stack) / 20.0f;
        float value = durability + protection - 0.8f;
        return MathHelper.func_76131_a((float)value, (float)0.0f, (float)4.0f);
    }

    public int getMaxDamage(ItemStack stack) {
        EnumMaterialTier tier = ToolHelper.getToolTier(stack);
        int x = ArmorHelper.getMaxDamage(stack);
        float y = (1.8f * (float)x + 1515.0f) / 131.0f;
        float z = tier != null ? y * ((float)tier.ordinal() + 1.0f) / 2.0f : y;
        return (int)((float)field_77882_bY[this.field_77881_a.func_188454_b()] * z);
    }

    public static int getPlayerTotalGemArmorValue(EntityLivingBase player) {
        float total = 0.0f;
        for (ItemStack armor : player.func_184193_aE()) {
            if (!StackHelper.isValid((ItemStack)armor)) continue;
            if (armor.func_77973_b() instanceof ItemGemArmor) {
                if (ToolHelper.isBroken(armor)) continue;
                total += ((ItemGemArmor)armor.func_77973_b()).getProtection(armor);
                continue;
            }
            if (!(armor.func_77973_b() instanceof ItemArmor)) continue;
            total += (float)((ItemArmor)armor.func_77973_b()).field_77879_b;
        }
        return Math.round(total);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (ToolHelper.isBroken(armor)) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 1.0, 0);
        }
        float protection = MathHelper.func_76125_a((int)ItemGemArmor.getPlayerTotalGemArmorValue(player), (int)0, (int)39);
        float ratio = ABSORPTION_RATIO_BY_SLOT[this.field_77881_a.func_188454_b()];
        ratio = protection <= 20.0f ? (ratio *= protection / 25.0f) : (ratio *= MathHelper.func_76131_a((float)(protection / 100.0f), (float)0.0f, (float)0.98f) + 0.6f);
        int durabilityLeft = armor.func_77958_k() - armor.func_77952_i();
        ISpecialArmor.ArmorProperties prop = new ISpecialArmor.ArmorProperties(0, (double)ratio, durabilityLeft - 1);
        return prop;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        ToolSoul soul;
        if (ToolHelper.isBroken(stack)) {
            return;
        }
        if (entity instanceof EntityPlayer && (soul = SoulManager.getSoul(stack)) != null) {
            soul.addXp((int)(3.0f * (float)damage), stack, (EntityPlayer)entity);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == this.field_77881_a && !ToolHelper.isBroken(stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(field_185084_n[slot.func_188454_b()], "Armor modifier", (double)this.getProtection(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(field_185084_n[slot.func_188454_b()], "Armor toughness", (double)this.getToughness(stack), 0));
        }
        return multimap;
    }

    @Nonnull
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "silentgems:textures/armor/temparmor.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped original) {
        ModelGemArmor model = ModelGemArmor.getModel(ArmorHelper.getRenderColorList(itemStack));
        if (model != null) {
            model.func_178686_a((ModelBase)original);
            return model;
        }
        return super.getArmorModel(entity, itemStack, slot, original);
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ToolHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return ArmorHelper.getItemEnchantability(stack);
    }

    public void func_77663_a(ItemStack armor, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(armor, world, entity, itemSlot, isSelected);
    }

    public void clAddInformation(ItemStack stack, World world, List<String> list, boolean advanced) {
        ToolSoul soul;
        LocalizationHelper loc = SilentGems.localizationHelper;
        ToolRenderHelper helper = ToolRenderHelper.getInstance();
        boolean controlDown = KeyTracker.isControlDown();
        boolean shiftDown = KeyTracker.isShiftDown();
        boolean altDown = KeyTracker.isAltDown();
        if (GemsConfig.DEBUG_MODE && controlDown && shiftDown) {
            UUID uuid = ToolHelper.hasUUID(stack) ? ToolHelper.getUUID(stack) : null;
            list.add(uuid == null ? "No UUID" : uuid.toString());
            uuid = ToolHelper.getSoulUUID(stack);
            list.add(uuid == null ? "No Soul UUID" : uuid.toString());
        }
        if ((soul = SoulManager.getSoul(stack)) != null) {
            soul.addInformation(stack, world, list, advanced);
        }
        if (controlDown) {
            String owner = ArmorHelper.getOriginalOwner(stack);
            if (!owner.isEmpty()) {
                list.add(loc.getMiscText("Tooltip.OriginalOwner", new Object[]{owner}));
            } else {
                list.add(loc.getMiscText("Tooltip.OriginalOwner.Unknown", new Object[0]));
            }
        }
        if (altDown) {
            list.add(TextFormatting.RED + "Armor models WIP.");
        }
        if (ArmorHelper.isBroken(stack)) {
            list.add(loc.getMiscText("Tooltip.Broken", new Object[0]));
        }
        String sep = loc.getMiscText("Tooltip.Separator", new Object[0]);
        if (controlDown) {
            list.add(loc.getMiscText("Tooltip.Properties", new Object[0]));
            TextFormatting color = TextFormatting.YELLOW;
            float durabilityBoost = ToolSoul.getDurabilityModifierForDisplay(soul);
            list.add(color + helper.getTooltipLine("Durability", this.getMaxDamage(stack), durabilityBoost));
            float protectionBoost = ToolSoul.getProtectionModifierForDisplay(soul);
            list.add(color + helper.getTooltipLine("Protection", this.getProtection(stack), protectionBoost));
            list.add(sep);
            list.add(loc.getMiscText("Tooltip.Statistics", new Object[0]));
            list.add(helper.getTooltipLine("DamageTaken", ArmorHelper.getStatDamageTaken(stack), 0.0f));
            list.add(helper.getTooltipLine("Redecorated", ArmorHelper.getStatRedecorated(stack), 0.0f));
            list.add(sep);
        } else {
            list.add(TextFormatting.GOLD + loc.getMiscText("PressCtrl", new Object[0]));
        }
        if (altDown) {
            list.add(loc.getMiscText("Tooltip.Construction", new Object[0]));
            ToolPart[] parts = ArmorHelper.getConstructionParts(stack);
            EnumMaterialGrade[] grades = ArmorHelper.getConstructionGrades(stack);
            for (int i = 0; i < parts.length; ++i) {
                ToolPart part = parts[i];
                EnumMaterialGrade grade = grades[i];
                String line = "  " + TextFormatting.YELLOW + part.getKey() + TextFormatting.GOLD + " (" + (Object)((Object)grade) + ")";
                list.add(line);
            }
            ToolPart partFrame = ArmorHelper.getPart(stack, ArmorPartPosition.FRAME);
            if (partFrame != null) {
                list.add("  " + TextFormatting.YELLOW + partFrame.getKey());
            }
            list.add(sep);
        } else {
            list.add(TextFormatting.GOLD + loc.getMiscText("PressAlt", new Object[0]));
        }
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        if (this.subItems == null) {
            this.subItems = new ArrayList<ItemStack>();
            ToolPartRegistry.getMains().forEach(part -> {
                if (!part.isBlacklisted(part.getCraftingStack())) {
                    ItemStack armor = this.constructArmor(part.getTier(), part.getCraftingStack());
                    armor.func_77978_p().func_74757_a("ExampleToolItem", true);
                    this.subItems.add(armor);
                }
            });
            for (ItemStack stack : this.subItems) {
                ArmorHelper.setOriginalOwner(stack, TextFormatting.LIGHT_PURPLE + "Creative");
                stack.func_77978_p().func_74757_a("ExampleToolItem", true);
            }
        }
        list.addAll(this.subItems);
    }

    public void addRecipes(RecipeMaker recipes) {
        ToolHelper.addExampleRecipe((Item)this, " h ", "hah", " h ");
    }

    public String func_77667_c(ItemStack stack) {
        return "item.silentgems:" + this.itemName;
    }
}

