/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.armor;

import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class ItemArmorFrame
extends ItemSL {
    public ItemArmorFrame() {
        super(4 * EnumMaterialTier.values().length, "silentgems", "ArmorFrame");
    }

    public ItemStack getFrameForArmorPiece(ItemArmor itemArmor, EnumMaterialTier tier) {
        return this.getFrameForArmorPiece(itemArmor.field_77881_a, tier);
    }

    public ItemStack getFrameForArmorPiece(EntityEquipmentSlot slot, EnumMaterialTier tier) {
        int type = 3 - slot.func_188454_b();
        return new ItemStack((Item)this, 1, type | tier.ordinal() << 2);
    }

    public EnumMaterialTier getTier(ItemStack stack) {
        int index = stack.func_77952_i() >> 2;
        return EnumMaterialTier.values()[MathHelper.func_76125_a((int)index, (int)0, (int)(EnumMaterialTier.values().length - 1))];
    }

    public Item getOutputItem(ItemStack stack) {
        return this.getOutputItem(stack.func_77952_i() & 3);
    }

    private Item getOutputItem(int armorType) {
        switch (armorType) {
            case 0: {
                return ModItems.gemHelmet;
            }
            case 1: {
                return ModItems.gemChestplate;
            }
            case 2: {
                return ModItems.gemLeggings;
            }
            case 3: {
                return ModItems.gemBoots;
            }
        }
        return null;
    }

    public void addRecipes(RecipeMaker recipes) {
        for (int tier = 0; tier < EnumMaterialTier.values().length; ++tier) {
            ItemStack lattice;
            ItemStack itemStack = tier == 0 ? ModItems.craftingMaterial.armorLatticeMundane : (tier == 1 ? ModItems.craftingMaterial.armorLatticeRegular : (lattice = tier == 2 ? ModItems.craftingMaterial.armorLatticeSuper : StackHelper.empty()));
            if (!StackHelper.isValid((ItemStack)lattice)) continue;
            for (int type = 0; type < 4; ++type) {
                this.addRecipe(recipes, "armor_frame_" + tier, new ItemStack((Item)this, 1, type + (tier << 2)), lattice, type);
            }
        }
    }

    private void addRecipe(RecipeMaker recipes, String name, ItemStack output, ItemStack lattice, int armorType) {
        switch (armorType) {
            case 0: {
                recipes.addShaped(name + "_helmet", output, new Object[]{"lll", "l l", Character.valueOf('l'), lattice});
                break;
            }
            case 1: {
                recipes.addShaped(name + "_chestplate", output, new Object[]{"l l", "lll", "lll", Character.valueOf('l'), lattice});
                break;
            }
            case 2: {
                recipes.addShaped(name + "_leggings", output, new Object[]{"lll", "l l", "l l", Character.valueOf('l'), lattice});
                break;
            }
            case 3: {
                recipes.addShaped(name + "_boots", output, new Object[]{"l l", "l l", Character.valueOf('l'), lattice});
            }
        }
    }
}

