/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.api.tool.part.ToolPartTip;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumTipUpgrade;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemTipUpgrade
extends ItemSL {
    public static final String[] NAMES = new String[]{"UpgradeIronTip", "UpgradeGoldTip", "UpgradeDiamondTip", "UpgradeEmeraldTip"};
    public static List<IRecipe> RECIPES = Lists.newArrayList();

    public ItemTipUpgrade() {
        super(EnumTipUpgrade.values().length - 1, "silentgems", "TipUpgrade");
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        ToolPartTip part = (ToolPartTip)ToolPartRegistry.fromStack(stack);
        if (part != null) {
            LocalizationHelper loc = SilentGems.localizationHelper;
            list.add(loc.getItemSubText(this.itemName, "willReplace", new Object[0]));
            list.add(loc.getItemSubText(this.itemName, "harvestLevel", new Object[]{part.getHarvestLevel()}));
            this.tooltipLine(loc, list, "durability", part.getDurability());
            this.tooltipLine(loc, list, "harvestSpeed", Float.valueOf(part.getHarvestSpeed()));
            this.tooltipLine(loc, list, "meleeDamage", Float.valueOf(part.getMeleeDamage()));
            this.tooltipLine(loc, list, "magicDamage", Float.valueOf(part.getMagicDamage()));
        }
    }

    protected void tooltipLine(LocalizationHelper loc, List list, String key, Number value) {
        if (value.floatValue() == 0.0f) {
            return;
        }
        String numberString = (value.floatValue() < 0.0f ? "-" : "+") + String.format(value instanceof Integer ? "%d" : "%.1f", value);
        String line = loc.getItemSubText(this.itemName, key, new Object[]{numberString});
        list.add(String.format(line, numberString));
    }

    public ItemStack applyToTool(ItemStack tool, ItemStack upgrade) {
        ToolPart part = ToolPartRegistry.fromStack(upgrade);
        if (part == null) {
            return null;
        }
        ItemStack result = StackHelper.safeCopy((ItemStack)tool);
        ToolHelper.setConstructionTip(result, part);
        ToolHelper.recalculateStats(result);
        return result;
    }

    public void addRecipes(RecipeMaker recipes) {
        ItemStack base = ModItems.craftingMaterial.upgradeBase;
        RECIPES.add(recipes.addShapelessOre("tip_upgrade_iron", new ItemStack((Item)this, 1, 0), new Object[]{"ingotIron", base}));
        RECIPES.add(recipes.addShapelessOre("tip_upgrade_gold", new ItemStack((Item)this, 1, 1), new Object[]{"ingotGold", base}));
        RECIPES.add(recipes.addShapelessOre("tip_upgrade_diamond", new ItemStack((Item)this, 1, 2), new Object[]{"gemDiamond", base}));
        RECIPES.add(recipes.addShapelessOre("tip_upgrade_emerald", new ItemStack((Item)this, 1, 3), new Object[]{"gemEmerald", base}));
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        int i = 0;
        for (String str : NAMES) {
            String name = ("silentgems:" + str).toLowerCase();
            models.put(i++, new ModelResourceLocation(name, "inventory"));
        }
    }

    public String getNameForStack(ItemStack stack) {
        return NAMES[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(NAMES.length - 1))];
    }
}

