/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemChaosOrb;
import net.silentchaos512.gems.item.ItemChaosStorage;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.util.NBTHelper;
import net.silentchaos512.gems.util.TeleportUtil;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.DimensionalPosition;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles"), @Optional.Interface(iface="baubles.api.render.IRenderBauble", modid="baubles")})
public class ItemReturnHome
extends ItemChaosStorage
implements IBauble,
IRenderBauble {
    public static final String TEXT_BOUND_TO = "BoundTo";
    public static final String TEXT_NOT_BOUND = "NotBound";
    public static final String TEXT_NOT_ENOUGH_CHARGE = "NotEnoughCharge";
    public static final String TEXT_NOT_SANE = "NotSane";
    public static final String TEXT_NOT_SAFE = "NotSafe";
    public static final String NBT_READY = "IsReady";

    public ItemReturnHome() {
        super(EnumGem.values().length, "ReturnHomeCharm", GemsConfig.RETURN_HOME_MAX_CHARGE);
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean par4) {
        boolean modifier = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
        LocalizationHelper loc = SilentGems.localizationHelper;
        list.addAll(loc.getItemDescriptionLines(this.itemName));
        DimensionalPosition pos = this.getBoundPosition(stack);
        if (pos != null) {
            if (modifier) {
                list.add(loc.getItemSubText(this.itemName, TEXT_BOUND_TO, new Object[]{pos}));
            } else {
                list.add(loc.getMiscText("PressCtrl", new Object[0]));
            }
        } else {
            list.add(loc.getItemSubText(this.itemName, TEXT_NOT_BOUND, new Object[0]));
        }
    }

    public void addRecipes(RecipeMaker recipes) {
        for (EnumGem gem : EnumGem.values()) {
            ItemStack result = new ItemStack((Item)this, 1, gem.ordinal());
            recipes.addShapedOre("return_home_" + gem.name(), result, new Object[]{" s ", "sgs", "ici", Character.valueOf('s'), ModItems.craftingMaterial.gildedString, Character.valueOf('g'), gem.getItemOreName(), Character.valueOf('i'), "ingotGold", Character.valueOf('c'), new ItemStack((Item)ModItems.chaosOrb, 1, ItemChaosOrb.Type.FRAGILE.ordinal())});
        }
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        for (EnumGem gem : EnumGem.values()) {
            ItemStack stack = new ItemStack(item, 1, gem.ordinal());
            this.setCharge(stack, this.getMaxCharge(stack));
            list.add(stack);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 133700;
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.getTagBoolean(stack, NBT_READY);
    }

    public String getNameForStack(ItemStack stack) {
        return this.itemName;
    }

    public DimensionalPosition getBoundPosition(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        DimensionalPosition pos = DimensionalPosition.readFromNBT((NBTTagCompound)stack.func_77978_p());
        if (pos.equals((Object)DimensionalPosition.ZERO)) {
            return null;
        }
        return pos;
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        DimensionalPosition pos = this.getBoundPosition(stack);
        if (pos != null) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        int timeUsed;
        if (player.field_70170_p.field_72995_K && (timeUsed = this.func_77626_a(stack) - count) >= GemsConfig.RETURN_HOME_USE_TIME) {
            NBTHelper.setTagBoolean(stack, NBT_READY, true);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected && NBTHelper.getTagBoolean(stack, NBT_READY)) {
            NBTHelper.setTagBoolean(stack, NBT_READY, false);
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (world.field_72995_K) {
            NBTHelper.setTagBoolean(stack, NBT_READY, false);
        } else {
            int timeUsed = this.func_77626_a(stack) - timeLeft;
            if (timeUsed < GemsConfig.RETURN_HOME_USE_TIME) {
                return;
            }
            this.tryTeleportPlayer(stack, player);
        }
    }

    public int getTeleportCost(ItemStack stack, EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d ? 0 : GemsConfig.RETURN_HOME_USE_COST;
    }

    public void tryTeleportPlayer(ItemStack stack, EntityPlayer player) {
        LocalizationHelper loc = SilentGems.localizationHelper;
        DimensionalPosition pos = this.getBoundPosition(stack);
        if (pos == null) {
            return;
        }
        if (this.getCharge(stack) < this.getTeleportCost(stack, player)) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)loc.getItemSubText(this.itemName, TEXT_NOT_ENOUGH_CHARGE, new Object[0]));
            return;
        }
        if (pos.y <= 0) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)loc.getItemSubText(this.itemName, TEXT_NOT_SANE, new Object[0]));
            return;
        }
        WorldServer worldServer = player.func_184102_h().func_71218_a(pos.dim);
        int height = (int)Math.ceil(player.eyeHeight);
        BlockPos target = pos.toBlockPos().func_177981_b(height);
        player.field_70143_R = 0.0f;
        this.teleportPlayer(stack, player, pos);
        float soundPitch = 0.8f + 0.3f * SilentGems.random.nextFloat();
        for (BlockPos p : new BlockPos[]{player.func_180425_c(), pos.toBlockPos()}) {
            player.field_70170_p.func_184133_a(null, p, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    protected void teleportPlayer(ItemStack stack, EntityPlayer player, DimensionalPosition pos) {
        if (player instanceof EntityPlayerMP) {
            TeleportUtil.teleportPlayerTo((EntityPlayerMP)player, pos);
        }
        this.extractCharge(stack, this.getTeleportCost(stack, player), false);
    }

    public boolean registerModels() {
        ModelResourceLocation model = new ModelResourceLocation("silentgems:ReturnHomeCharm", "inventory");
        for (int i = 0; i < EnumGem.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)model);
        }
        return true;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.AMULET;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="baubles")
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType renderType, float partialTicks) {
        if (renderType == IRenderBauble.RenderType.BODY) {
            float scale = 0.5f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IRenderBauble.Helper.translateToChest();
            GlStateManager.func_179137_b((double)0.0, (double)3.0, (double)0.55);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        }
    }
}

