/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.config.GemsConfigHC;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGem
extends ItemSL {
    public ItemGem() {
        super(EnumGem.values().length, "silentgems", "Gem");
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        EnumGem gem = EnumGem.getFromStack(stack);
        boolean controlDown = KeyTracker.isControlDown();
        if (controlDown && (gem == EnumGem.RUBY || gem == EnumGem.BERYL || gem == EnumGem.SAPPHIRE || gem == EnumGem.TOPAZ)) {
            list.add(SilentGems.localizationHelper.getItemSubText(this.itemName, "original4", new Object[0]));
        }
    }

    public void addRecipes(RecipeMaker recipes) {
        String centerItem = GemsConfigHC.HARD_SUPER_GEMS ? "gemEnderEssence" : "dustGlowstone";
        for (EnumGem gem : EnumGem.values()) {
            recipes.addShapedOre("gem_super_" + gem.name(), gem.getItemSuper(), new Object[]{"cgc", "cdc", "cgc", Character.valueOf('g'), gem.getItem(), Character.valueOf('d'), centerItem, Character.valueOf('c'), "gemChaos"});
            recipes.addCompression("gem_" + gem.name(), gem.getShard(), gem.getItem(), 9);
            ItemStack shards = gem.getShard();
            StackHelper.setCount((ItemStack)shards, (int)9);
            recipes.addShapelessOre("gem_shard_" + gem.name() + "_oredict", shards, new Object[]{gem.getItemOreName()});
        }
    }

    public void addOreDict() {
        for (EnumGem gem : EnumGem.values()) {
            OreDictionary.registerOre((String)gem.getItemOreName(), (ItemStack)gem.getItem());
            OreDictionary.registerOre((String)gem.getItemSuperOreName(), (ItemStack)gem.getItemSuper());
        }
    }
}

