/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.lib.item.ItemFoodSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemFoodSG
extends ItemFoodSL {
    public static final String[] NAMES = new String[]{"PotatoStick", "SugarCookie", "SecretDonut", "MeatyStewUncooked", "MeatyStew", "CandyCane", "CoffeeCup"};
    public static final int[] foodLevel = new int[]{8, 2, 6, 4, 12, 2, 1};
    public static final float[] saturationLevel = new float[]{0.8f, 0.4f, 0.8f, 0.6f, 1.6f, 0.2f, 0.2f};
    public static final boolean[] alwaysEdible = new boolean[]{false, true, false, false, false, true, true};
    public final ItemStack potatoStick = this.getStack("PotatoStick");
    public final ItemStack sugarCookie = this.getStack("SugarCookie");
    public final ItemStack secretDonut = this.getStack("SecretDonut");
    public final ItemStack meatyStewUncooked = this.getStack("MeatyStewUncooked");
    public final ItemStack meatyStew = this.getStack("MeatyStew");
    public final ItemStack candyCane = this.getStack("CandyCane");
    public final ItemStack coffeeCup = this.getStack("CoffeeCup");
    public static final List<SecretDonutEffect> secretDonutEffects = Lists.newArrayList();

    public ItemFoodSG() {
        super(NAMES.length, "silentgems", "Food");
        secretDonutEffects.clear();
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76440_q, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76431_k, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76420_g, 1.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76419_f, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76422_e, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76426_n, 4.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76438_s, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76441_p, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76430_j, 1.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76421_d, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76424_c, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76439_r, 1.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76436_u, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76428_l, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76429_m, 0.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76427_o, 2.0f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_76437_t, 1.5f));
        secretDonutEffects.add(new SecretDonutEffect(MobEffects.field_82731_v, 0.5f));
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        int meta = stack.func_77952_i();
        if (meta < NAMES.length) {
            list.addAll(SilentGems.localizationHelper.getItemDescriptionLines(NAMES[meta]));
        }
    }

    private void addSecretDonutEffect(World world, EntityPlayer player) {
        SecretDonutEffect effect = secretDonutEffects.get(world.field_73012_v.nextInt(secretDonutEffects.size()));
        player.func_70690_d(new PotionEffect(effect.potion, (int)((float)GemsConfig.FOOD_SUPPORT_DURATION * effect.durationMulti), 0, true, false));
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77952_i() == this.sugarCookie.func_77952_i()) {
            return 16;
        }
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77952_i() == this.coffeeCup.func_77952_i()) {
            return EnumAction.DRINK;
        }
        return super.func_77661_b(stack);
    }

    public ItemStack getStack(String name) {
        return this.getStack(name, 1);
    }

    public ItemStack getStack(String name, int count) {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equals(name)) continue;
            return new ItemStack((Item)this, count, i);
        }
        return StackHelper.empty();
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77952_i() < NAMES.length) {
            return "item.silentgems:" + NAMES[stack.func_77952_i()];
        }
        return super.func_77667_c(stack);
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_71043_e(alwaysEdible[stack.func_77952_i()])) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            int d = stack.func_77952_i();
            if (d == 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, GemsConfig.FOOD_SUPPORT_DURATION, 0, true, false));
                this.givePlayerItem(player, new ItemStack(Items.field_151055_y));
            } else if (d == 1) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, GemsConfig.FOOD_SUPPORT_DURATION, 0, true, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, GemsConfig.FOOD_SUPPORT_DURATION, 0, true, false));
            } else if (d == 2) {
                this.onDonutEaten(world, player);
            } else if (d == 3 || d == 4) {
                this.givePlayerItem(player, new ItemStack(Items.field_151054_z));
            } else if (d == 5) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, GemsConfig.FOOD_SUPPORT_DURATION / 6, 0, true, false));
            } else if (d == 6) {
                int duration = (int)(2.0f * (float)GemsConfig.FOOD_SUPPORT_DURATION);
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, duration * 2, 1, true, false));
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, duration, 1, true, false));
            }
        }
        super.func_77849_c(stack, world, player);
    }

    private void onDonutEaten(World world, EntityPlayer player) {
        Random rand = SilentGems.random;
        if (rand.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_CHANCE) {
            this.addSecretDonutEffect(world, player);
            if (rand.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_CHANCE) {
                this.addSecretDonutEffect(world, player);
                if (rand.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_CHANCE) {
                    this.addSecretDonutEffect(world, player);
                }
            }
        }
        if (rand.nextFloat() < GemsConfig.FOOD_SECRET_DONUT_TEXT_CHANCE) {
            List list = SilentGems.localizationHelper.getDescriptionLines("donut.silentgems:");
            String line = (String)list.get(rand.nextInt(list.size()));
            ChatHelper.sendMessage((EntityPlayer)player, (String)line);
        }
    }

    private void givePlayerItem(EntityPlayer player, ItemStack stack) {
        EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, stack);
        player.field_70170_p.func_72838_d((Entity)item);
    }

    public int func_150905_g(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta < 0 || meta >= NAMES.length) {
            return 0;
        }
        return foodLevel[meta];
    }

    public float func_150906_h(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta < 0 || meta >= NAMES.length) {
            return 0.0f;
        }
        return saturationLevel[meta];
    }

    public boolean func_77845_h() {
        return false;
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        for (int i = 0; i < NAMES.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void addRecipes(RecipeMaker recipes) {
        recipes.addShapedOre("potato_stick", this.getStack("PotatoStick", 1), new Object[]{" p", "s ", Character.valueOf('p'), Items.field_151168_bH, Character.valueOf('s'), "stickWood"});
        recipes.addShaped("sugar_cookie", this.getStack("SugarCookie", 8), new Object[]{" s ", "www", " s ", Character.valueOf('s'), Items.field_151102_aT, Character.valueOf('w'), Items.field_151015_O});
        recipes.addSurround("secret_donut", this.getStack("SecretDonut", 8), new ItemStack((Block)Blocks.field_150337_Q), new Object[]{Items.field_151015_O});
        Item[] meats = new Item[]{Items.field_151082_bd, Items.field_151147_al, Items.field_151076_bf};
        int i = -1;
        for (Item meat : meats) {
            recipes.addShapeless("meaty_stew_" + ++i, this.getStack("MeatyStewUncooked", 1), new Object[]{Items.field_151054_z, meat, Items.field_151174_bG, Items.field_151172_bF});
        }
        recipes.addSmelting(this.getStack("MeatyStewUncooked", 1), this.getStack("MeatyStew", 1), 0.5f);
        recipes.addShapedOre("candy_cane", this.getStack("CandyCane", 6), new Object[]{"ss", "rs", " s", Character.valueOf('s'), Items.field_151102_aT, Character.valueOf('r'), "dyeRed"});
    }

    public void addOreDict() {
    }

    public String getName() {
        return "Food";
    }

    public String getFullName() {
        return this.getModId() + ":" + this.getName();
    }

    public String getModId() {
        return "silentgems";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        for (int i = 0; i < NAMES.length; ++i) {
            String name = ("silentgems:" + NAMES[i]).toLowerCase();
            models.put(i, new ModelResourceLocation(name, "inventory"));
        }
    }

    public boolean registerModels() {
        return false;
    }

    public static class SecretDonutEffect {
        public Potion potion;
        public float durationMulti;

        public SecretDonutEffect(Potion potion, float durationMulti) {
            this.potion = potion;
            this.durationMulti = durationMulti;
        }
    }
}

