/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.handler.ClientTickHandler;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.EnchantmentUtils;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemEnchantmentToken
extends ItemSL {
    public static final String NBT_ENCHANTMENTS = "TokenEnchantments";
    public static final String KEY_ANY = "Any";
    public static final String KEY_ARMOR = "Armor";
    public static final String KEY_BOW = "Bow";
    public static final String KEY_EMPTY = "Empty";
    public static final String KEY_FISHING_ROD = "FishingRod";
    public static final String KEY_WEAPON = "Sword";
    public static final String KEY_DIGGER = "Tool";
    public static final String KEY_UNKNOWN = "Unknown";
    public static final String[] MODEL_TYPES = new String[]{"Any", "Armor", "Bow", "Empty", "FishingRod", "Sword", "Tool", "Unknown"};
    private Map<String, Integer> modelMap = new HashMap<String, Integer>();
    private Map<Enchantment, String> recipeMap = new HashMap<Enchantment, String>();
    private Map<Enchantment, Integer> colorMap = new HashMap<Enchantment, Integer>();
    private boolean modRecipesInitialized = false;
    public static final int BLANK_META = 256;
    boolean loggedIssue139Catch = false;
    public static float OUTLINE_PULSATE_SPEED = 0.10610329f;

    public ItemEnchantmentToken() {
        super(1, "silentgems", "EnchantmentToken");
        for (int i = 0; i < MODEL_TYPES.length; ++i) {
            this.modelMap.put(MODEL_TYPES[i], i);
        }
        this.func_185043_a(new ResourceLocation("model_index"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ((Integer)ItemEnchantmentToken.this.modelMap.get(ItemEnchantmentToken.this.getModelKey(stack))).intValue();
            }
        });
    }

    public ItemStack constructToken(Enchantment enchantment) {
        return this.constructToken(enchantment, 1);
    }

    public ItemStack constructToken(Enchantment enchantment, int level) {
        return this.addEnchantment(new ItemStack((Item)this), enchantment, level);
    }

    public ItemStack constructToken(Map<Enchantment, Integer> enchantmentMap) {
        ItemStack result = new ItemStack((Item)this);
        this.setEnchantments(result, enchantmentMap);
        return result;
    }

    public ItemStack addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
        ItemStack result = StackHelper.safeCopy((ItemStack)stack);
        try {
            Map<Enchantment, Integer> map = this.getEnchantments(stack);
            map.put(enchantment, level);
            this.setEnchantments(result, map);
        }
        catch (NullPointerException ex) {
            String str = "Failed to construct an enchantment token! This will likely result in a broken recipe.\n";
            str = str + "The following is a list of details on the enchantment at fault. Please direct your anger at:\n";
            str = str + this.getEnchantmentDebugInfo(enchantment);
            SilentGems.logHelper.warning((Object)str);
        }
        return result;
    }

    public Map<Enchantment, Integer> getEnchantments(ItemStack token) {
        if (StackHelper.isEmpty((ItemStack)token) || !token.func_77942_o()) {
            return new HashMap<Enchantment, Integer>();
        }
        NBTTagList tagList = token.func_77978_p().func_150295_c(NBT_ENCHANTMENTS, 10);
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        if (tagList != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                String name = tagList.func_150305_b(i).func_74779_i("name");
                short level = tagList.func_150305_b(i).func_74765_d("lvl");
                Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(name));
                if (ench == null) continue;
                map.put(ench, Integer.valueOf(level));
            }
        }
        return map;
    }

    public void setEnchantments(ItemStack token, Map<Enchantment, Integer> map) {
        if (StackHelper.isEmpty((ItemStack)token)) {
            return;
        }
        if (!token.func_77942_o()) {
            token.func_77982_d(new NBTTagCompound());
        }
        if (token.func_77978_p().func_74764_b(NBT_ENCHANTMENTS)) {
            token.func_77978_p().func_82580_o(NBT_ENCHANTMENTS);
        }
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            String name = entry.getKey().getRegistryName().toString();
            int level = entry.getValue();
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("name", name);
            compound.func_74777_a("lvl", (short)level);
            tagList.func_74742_a((NBTBase)compound);
        }
        token.func_77978_p().func_74782_a(NBT_ENCHANTMENTS, (NBTBase)tagList);
    }

    public boolean applyTokenToTool(ItemStack token, ItemStack tool) {
        if (StackHelper.isEmpty((ItemStack)token) || StackHelper.isEmpty((ItemStack)tool)) {
            return false;
        }
        Map<Enchantment, Integer> enchantmentsOnToken = this.getEnchantments(token);
        if (enchantmentsOnToken.isEmpty()) {
            return false;
        }
        Map enchantmentsOnTool = EnchantmentHelper.func_82781_a((ItemStack)tool);
        for (Map.Entry<Enchantment, Integer> entry : enchantmentsOnToken.entrySet()) {
            Enchantment ench = entry.getKey();
            if (!ench.func_92089_a(tool)) {
                return false;
            }
            for (Enchantment enchTool : enchantmentsOnTool.keySet()) {
                if (ench.equals(enchTool) || EnchantmentUtils.canApplyTogether((Enchantment)ench, (Enchantment)enchTool)) continue;
                return false;
            }
        }
        if (!this.mergeEnchantmentLists(enchantmentsOnToken, enchantmentsOnTool)) {
            return false;
        }
        EnchantmentHelper.func_82782_a(enchantmentsOnToken, (ItemStack)tool);
        return true;
    }

    public boolean mergeEnchantmentLists(Map<Enchantment, Integer> ench1, Map<Enchantment, Integer> ench2) {
        for (Enchantment enchantment : ench2.keySet()) {
            int newLevel;
            int level = newLevel = ench2.get(enchantment).intValue();
            if (ench1.containsKey(enchantment) && (newLevel = ench1.get(enchantment) + level) > enchantment.func_77325_b()) {
                return false;
            }
            ench1.put(enchantment, newLevel);
        }
        return true;
    }

    public String getModelKey(ItemStack stack) {
        String key;
        block12: {
            Map<Enchantment, Integer> enchMap = this.getEnchantments(stack);
            key = KEY_EMPTY;
            if (!enchMap.isEmpty()) {
                Enchantment ench = enchMap.keySet().iterator().next();
                if (ench == null || ench.field_77351_y == null) {
                    return KEY_UNKNOWN;
                }
                try {
                    switch (ench.field_77351_y) {
                        case ALL: 
                        case BREAKABLE: {
                            return KEY_ANY;
                        }
                        case ARMOR: 
                        case ARMOR_CHEST: 
                        case ARMOR_FEET: 
                        case ARMOR_HEAD: 
                        case ARMOR_LEGS: 
                        case WEARABLE: {
                            return KEY_ARMOR;
                        }
                        case BOW: {
                            return KEY_BOW;
                        }
                        case DIGGER: {
                            return KEY_DIGGER;
                        }
                        case FISHING_ROD: {
                            return KEY_FISHING_ROD;
                        }
                        case WEAPON: {
                            return KEY_WEAPON;
                        }
                    }
                    return KEY_UNKNOWN;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    if (this.loggedIssue139Catch) break block12;
                    this.loggedIssue139Catch = true;
                    SilentGems.logHelper.severe((Object)"Caught an odd exception in ItemEnchantmentToken#getModelKey. This will only be logged once.");
                    SilentGems.logHelper.info((Object)("Offending token: " + stack));
                    SilentGems.logHelper.info((Object)("Offending enchantment: " + ench + " (" + ench.func_77320_a() + ")"));
                    ex.printStackTrace();
                    return KEY_EMPTY;
                }
            }
        }
        return key;
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        LocalizationHelper loc = SilentGems.localizationHelper;
        Map<Enchantment, Integer> enchants = this.getEnchantments(stack);
        if (enchants.size() == 1) {
            Enchantment ench = enchants.keySet().iterator().next();
            list.add(loc.getItemSubText(this.itemName, "maxLevel", new Object[]{ench.func_77325_b()}));
            if (KeyTracker.isControlDown()) {
                list.add(loc.getItemSubText(this.itemName, "materials", new Object[0]));
                String recipeString = this.recipeMap.get(ench);
                if (recipeString != null && !recipeString.isEmpty()) {
                    for (String str : recipeString.split(";")) {
                        list.add("  " + str);
                    }
                }
            } else {
                list.add(loc.getItemSubText(this.itemName, "pressCtrl", new Object[0]));
            }
            if (KeyTracker.isAltDown()) {
                list.add(TextFormatting.DARK_GRAY + ench.getRegistryName().toString());
            }
        }
        for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
            Enchantment e = entry.getKey();
            String enchName = e.func_77316_c(entry.getValue().intValue());
            String modName = ((ModContainer)Loader.instance().getIndexedModList().get(e.getRegistryName().func_110624_b())).getName();
            list.add(loc.getItemSubText(this.itemName, "enchNameWithMod", new Object[]{enchName, modName}));
            String descKey = e.func_77320_a().replaceAll(":", ".").toLowerCase() + ".desc";
            String desc = loc.getLocalizedString(descKey, new Object[0]);
            if (desc.equals(descKey)) continue;
            list.add(TextFormatting.ITALIC + "  " + desc);
        }
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        ArrayList tokens = Lists.newArrayList();
        for (ResourceLocation key : Enchantment.field_185264_b.func_148742_b()) {
            tokens.add(this.constructToken((Enchantment)Enchantment.field_185264_b.func_82594_a((Object)key)));
        }
        tokens.sort(new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack o1, ItemStack o2) {
                int k = -ItemEnchantmentToken.this.getModelKey(o1).compareTo(ItemEnchantmentToken.this.getModelKey(o2));
                if (k == 0) {
                    Enchantment ench1 = ItemEnchantmentToken.this.getSingleEnchantment(o1);
                    Enchantment ench2 = ItemEnchantmentToken.this.getSingleEnchantment(o2);
                    if (ench1 == null || ench2 == null) {
                        return 0;
                    }
                    return ench1.func_77316_c(1).compareTo(ench2.func_77316_c(1));
                }
                return k;
            }
        });
        tokens.add(0, new ItemStack((Item)this, 1, 256));
        list.addAll(tokens);
    }

    @Nullable
    public Enchantment getSingleEnchantment(ItemStack token) {
        Map<Enchantment, Integer> map = this.getEnchantments(token);
        if (map.size() != 1) {
            return null;
        }
        return map.keySet().iterator().next();
    }

    public String getNameForStack(ItemStack stack) {
        boolean hasEnchants = StackHelper.isValid((ItemStack)stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_ENCHANTMENTS);
        return super.getNameForStack(stack) + (hasEnchants ? "" : "_Blank");
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public int getOutlineColor(ItemStack stack) {
        Enchantment ench = this.getSingleEnchantment(stack);
        if (ench != null && this.colorMap.containsKey(ench)) {
            int k = this.colorMap.get(ench);
            int r = k >> 16 & 0xFF;
            int g = k >> 8 & 0xFF;
            int b = k & 0xFF;
            int j = (int)(160.0f * MathHelper.func_76126_a((float)((float)ClientTickHandler.ticksInGame * OUTLINE_PULSATE_SPEED)));
            j = MathHelper.func_76125_a((int)j, (int)0, (int)255);
            r = MathHelper.func_76125_a((int)(r + j), (int)0, (int)255);
            g = MathHelper.func_76125_a((int)(g + j), (int)0, (int)255);
            b = MathHelper.func_76125_a((int)(b + j), (int)0, (int)255);
            return r << 16 | g << 8 | b;
        }
        return 0xFFFFFF;
    }

    public void setColorsForDefaultTokens() {
    }

    public void addRecipes(RecipeMaker recipes) {
        recipes.addShapedOre("enchantment_token_blank", new ItemStack((Item)this, 12, 256), new Object[]{"ggg", "lcl", "ggg", Character.valueOf('g'), "ingotGold", Character.valueOf('l'), "gemLapis", Character.valueOf('c'), "gemChaos"});
        recipes.addShapeless("enchantment_token_clear", new ItemStack((Item)this, 1, 256), new ItemStack[]{new ItemStack((Item)this, 1, Short.MAX_VALUE)});
        this.addTokenRecipe(Enchantments.field_185307_s, EnumGem.SAPPHIRE, "ingotIron", 5);
        this.addTokenRecipe(Enchantments.field_185296_A, EnumGem.BLACK_DIAMOND, Items.field_151156_bN, 1);
        this.addTokenRecipe(Enchantments.field_185305_q, EnumGem.BERYL, "dustGlowstone", 4);
        this.addTokenRecipe(Enchantments.field_185308_t, EnumGem.GOLDEN_BERYL, "gemDiamond", 3);
        this.addTokenRecipe(Enchantments.field_185306_r, EnumGem.VIOLET_SAPPHIRE, "gemEmerald", 3);
        ItemStack netherShard = ModItems.craftingMaterial.netherShard;
        this.addTokenRecipe(ModEnchantments.gravity, EnumGem.AMBER, netherShard, 2);
        this.addTokenRecipe(Enchantments.field_180312_n, EnumGem.AMETHYST, Items.field_151070_bp, 4);
        this.addTokenRecipe(Enchantments.field_77334_n, EnumGem.GARNET, Items.field_151065_br, 4);
        this.addTokenRecipe(Enchantments.field_180313_o, EnumGem.AQUAMARINE, Items.field_151008_G, 5);
        this.addTokenRecipe(Enchantments.field_185304_p, EnumGem.TURQUOISE, "gemEmerald", 2);
        this.addTokenRecipe(Enchantments.field_185302_k, EnumGem.RUBY, Items.field_151145_ak, 5);
        this.addTokenRecipe(Enchantments.field_185303_l, EnumGem.PERIDOT, Items.field_151078_bh, 5);
        if (SilentLib.instance.getMCVersion() >= 11) {
            this.addTokenRecipe(Enchantments.field_191530_r, EnumGem.MOLDAVITE, Items.field_151120_aE, 5);
        }
        this.addTokenRecipe(ModEnchantments.lifeSteal, EnumGem.MORGANITE, Items.field_151153_ao, 3);
        this.addTokenRecipe(ModEnchantments.magicDamage, EnumGem.LEPIDOLITE, Items.field_151072_bj, 4);
        this.addTokenRecipe(ModEnchantments.iceAspect, EnumGem.OPAL, Blocks.field_150432_aD, 5);
        this.addTokenRecipe(ModEnchantments.lightningAspect, EnumGem.HELIODOR, Items.field_151114_aO, 4);
        this.addTokenRecipe(Enchantments.field_185311_w, EnumGem.SPINEL, Items.field_151072_bj, 2);
        this.addTokenRecipe(Enchantments.field_185312_x, EnumGem.AMETRINE, Items.field_151061_bv, 4);
        this.addTokenRecipe(Enchantments.field_185309_u, EnumGem.CARNELIAN, Items.field_151032_g, 5);
        this.addTokenRecipe(Enchantments.field_185310_v, EnumGem.JASPER, Blocks.field_150331_J, 2);
        this.addTokenRecipe(Enchantments.field_151370_z, EnumGem.AQUAMARINE, new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE), 5);
        this.addTokenRecipe(Enchantments.field_151369_A, EnumGem.INDICOLITE, Blocks.field_150479_bC, 4);
        this.addTokenRecipe(Enchantments.field_185299_g, EnumGem.BLUE_TOPAZ, "blockLapis", 2);
        this.addTokenRecipe(Enchantments.field_185297_d, EnumGem.ONYX, Items.field_151016_H, 5);
        ItemStack plume = ModItems.craftingMaterial.plume;
        this.addTokenRecipe(Enchantments.field_180309_e, EnumGem.MALACHITE, plume, 2);
        this.addTokenRecipe(Enchantments.field_77329_d, EnumGem.CITRINE, Items.field_151064_bs, 2);
        this.addTokenRecipe(Enchantments.field_180308_g, EnumGem.AGATE, Items.field_151032_g, 4);
        this.addTokenRecipe(Enchantments.field_180310_c, EnumGem.IOLITE, Blocks.field_150411_aY, 4);
        this.addTokenRecipe(Enchantments.field_185298_f, EnumGem.TANZANITE, new ItemStack(Items.field_151115_aP, 1, 3), 1);
        this.addTokenRecipe(Enchantments.field_92091_k, EnumGem.TOPAZ, new ItemStack((Block)Blocks.field_150398_cm, 1, 4), 2);
        this.addTokenRecipe(Enchantments.field_185300_i, EnumGem.MOONSTONE, Blocks.field_150435_aG, 3);
        ItemStack enderFrost = ModItems.craftingMaterial.enderFrost;
        this.addTokenRecipe(Enchantments.field_185301_j, EnumGem.ALEXANDRITE, enderFrost, 4);
    }

    public void addModRecipes() {
        if (this.modRecipesInitialized) {
            return;
        }
        this.modRecipesInitialized = true;
        if (Loader.isModLoaded((String)"endercore")) {
            SilentGems.logHelper.info((Object)"Adding enchantment token recipes for Ender Core:");
            this.addModTokenRecipe("endercore:xpboost", EnumGem.MOLDAVITE, Blocks.field_150340_R, 1);
            this.addModTokenRecipe("endercore:autosmelt", EnumGem.GARNET, new ItemStack((Block)ModBlocks.miscBlock, 1, 3), 4);
        }
        if (Loader.isModLoaded((String)"EnderIO") || Loader.isModLoaded((String)"enderio")) {
            SilentGems.logHelper.info((Object)"Adding enchantment token recipes for Ender IO:");
            this.addModTokenRecipe("enderio:soulBound", EnumGem.OPAL, "itemEnderCrystal", 1);
        }
        if (Loader.isModLoaded((String)"EnderZoo") || Loader.isModLoaded((String)"enderzoo")) {
            SilentGems.logHelper.info((Object)"Adding enchantment token recipes for Ender Zoo:");
            Item witherDust = Item.func_111206_d((String)"enderzoo:witheringDust");
            this.addModTokenRecipe("enderzoo:witherWeapon", EnumGem.ONYX, witherDust, 5);
            this.addModTokenRecipe("enderzoo:witherArrow", EnumGem.BLACK_DIAMOND, witherDust, 5);
        }
    }

    public void addTokenRecipe(Enchantment ench, EnumGem gem, Object other, int otherCount) {
        String line2;
        if (ench == Enchantments.field_185301_j && GemsConfig.RECIPE_TOKEN_FROST_WALKER_DISABLE || ench == Enchantments.field_185296_A && GemsConfig.RECIPE_TOKEN_MENDING_DISABLE) {
            return;
        }
        if (!this.colorMap.containsKey(ench)) {
            this.colorMap.put(ench, gem.getColor());
        }
        String line1 = "g g";
        String string = line2 = otherCount > 3 ? "oto" : " t ";
        String line3 = otherCount == 3 || otherCount > 4 ? "ooo" : (otherCount == 2 || otherCount == 4 ? "o o" : " o ");
        ItemStack token = this.constructToken(ench);
        String recipeName = "enchantment_token_" + ench.func_77320_a().replaceAll(":", "_");
        SilentGems.registry.recipes.addShapedOre(recipeName, token, new Object[]{line1, line2, line3, Character.valueOf('g'), gem.getItemOreName(), Character.valueOf('o'), other, Character.valueOf('t'), new ItemStack((Item)this, 1, 256)});
        String recipeString = "2 " + gem.getItemOreName() + ";" + otherCount + " ";
        if (other instanceof String) {
            recipeString = recipeString + (String)other;
        } else if (other instanceof ItemStack) {
            recipeString = recipeString + ((ItemStack)other).func_82833_r();
        } else if (other instanceof Block) {
            recipeString = recipeString + new ItemStack((Block)other).func_82833_r();
        } else if (other instanceof Item) {
            recipeString = recipeString + new ItemStack((Item)other).func_82833_r();
        }
        this.recipeMap.put(ench, recipeString);
    }

    public void addModTokenRecipe(String enchantmentName, EnumGem gem, Object other, int otherCount) {
        SilentGems.logHelper.info((Object)("    Attempting to add token recipe for " + enchantmentName + "..."));
        Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_82594_a((Object)new ResourceLocation(enchantmentName));
        if (enchantment == null) {
            SilentGems.logHelper.info((Object)"    Failed to add! Enchantment is null?");
            return;
        }
        this.addTokenRecipe(enchantment, gem, other, otherCount);
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        String fullName = this.getFullName().toLowerCase();
        models.put(0, new ModelResourceLocation(fullName, "inventory"));
        int i = 1;
        for (String type : MODEL_TYPES) {
            String name = fullName + "_" + type.toLowerCase();
            models.put(i++, new ModelResourceLocation(name, "inventory"));
        }
    }

    public boolean registerModels() {
        ConcurrentMap models = new MapMaker().makeMap();
        this.getModels(models);
        for (Map.Entry entry : models.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)((ModelResourceLocation)entry.getValue()));
        }
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)256, (ModelResourceLocation)((ModelResourceLocation)models.get(0)));
        return true;
    }

    private String getEnchantmentDebugInfo(Enchantment ench) {
        String str = ench.toString();
        str = str + "\n    Name: " + ench.func_77320_a();
        str = str + "\n    Registry Name: " + ench.getRegistryName();
        str = str + "\n    Translated Name: " + ench.func_77316_c(1);
        str = str + "\n    Max Level: " + ench.func_77325_b();
        str = str + "\n    Type: " + ench.field_77351_y;
        str = str + "\n    Allowed On Books: " + ench.isAllowedOnBooks();
        if (SilentLib.getMCVersion() >= 11) {
            str = str + "\n    Curse: " + ench.func_190936_d();
        }
        str = str + "\n    Treasure: " + ench.func_185261_e();
        return str;
    }
}

