/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.item.ItemNamedSubtypesSorted;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class ItemCrafting
extends ItemNamedSubtypesSorted {
    public static final String[] NAMES = new String[]{"ChaosEssence", "ChaosEssencePlus", "ChaosEssencePlus2", "ChaosEssenceShard", "EnderEssence", "EnderEssenceShard", "ChaosCoal", "StickIron", "OrnateStickGold", "OrnateStickSilver", "IronPotato", "FluffyFabric", "UpgradeBase", "NamePlate", "ChaosCore", "MagnifyingGlass", "Plume", "ShinyPlume", "EnderFrost", "NetherShard", "NetherCluster", "GildedString", "YarnBall", "RawhideBone", "ArmorLatticeMundane", "ArmorLatticeRegular", "ArmorLatticeSuper", "Blazestone", "MysteryGoo", "ChaosIronUnfired", "ChaosIron", "EnderSlimeBall", "SoulShell", "StickStone"};
    public static final String[] SORTED_NAMES = new String[]{"ChaosEssence", "ChaosEssencePlus", "ChaosEssencePlus2", "ChaosEssenceShard", "EnderEssence", "EnderFrost", "EnderEssenceShard", "ChaosIronUnfired", "ChaosIron", "NetherShard", "NetherCluster", "EnderSlimeBall", "SoulShell", "ChaosCoal", "StickStone", "StickIron", "OrnateStickGold", "OrnateStickSilver", "ArmorLatticeMundane", "ArmorLatticeRegular", "ArmorLatticeSuper", "GildedString", "Blazestone", "MysteryGoo", "IronPotato", "ChaosCore", "FluffyFabric", "Plume", "ShinyPlume", "YarnBall", "RawhideBone", "MagnifyingGlass", "NamePlate", "UpgradeBase"};
    public final ItemStack armorLatticeMundane = this.getStack("ArmorLatticeMundane");
    public final ItemStack armorLatticeRegular = this.getStack("ArmorLatticeRegular");
    public final ItemStack armorLatticeSuper = this.getStack("ArmorLatticeSuper");
    public final ItemStack blazestone = this.getStack("Blazestone");
    public final ItemStack chaosCoal = this.getStack("ChaosCoal");
    public final ItemStack chaosCore = this.getStack("ChaosCore");
    public final ItemStack chaosEssence = this.getStack("ChaosEssence");
    public final ItemStack chaosEssenceEnriched = this.getStack("ChaosEssencePlus");
    public final ItemStack chaosEssenceCrystallized = this.getStack("ChaosEssencePlus2");
    public final ItemStack chaosEssenceShard = this.getStack("ChaosEssenceShard");
    public final ItemStack chaosIron = this.getStack("ChaosIron");
    public final ItemStack chaosIronUnfired = this.getStack("ChaosIronUnfired");
    public final ItemStack enderEssence = this.getStack("EnderEssence");
    public final ItemStack enderEssenceShard = this.getStack("EnderEssenceShard");
    public final ItemStack enderFrost = this.getStack("EnderFrost");
    public final ItemStack enderSlimeBall = this.getStack("EnderSlimeBall");
    public final ItemStack fluffyFabric = this.getStack("FluffyFabric");
    public final ItemStack gildedString = this.getStack("GildedString");
    public final ItemStack ironPotato = this.getStack("IronPotato");
    public final ItemStack magnifyingGlass = this.getStack("MagnifyingGlass");
    public final ItemStack namePlate = this.getStack("NamePlate");
    public final ItemStack netherCluster = this.getStack("NetherCluster");
    public final ItemStack netherShard = this.getStack("NetherShard");
    public final ItemStack plume = this.getStack("Plume");
    public final ItemStack rawhideBone = this.getStack("RawhideBone");
    public final ItemStack shinyPlume = this.getStack("ShinyPlume");
    public final ItemStack soulShell = this.getStack("SoulShell");
    public final ItemStack toolRodGold = this.getStack("OrnateStickGold");
    public final ItemStack toolRodIron = this.getStack("StickIron");
    public final ItemStack toolRodSilver = this.getStack("OrnateStickSilver");
    public final ItemStack toolRodStone = this.getStack("StickStone");
    public final ItemStack upgradeBase = this.getStack("UpgradeBase");
    public final ItemStack yarnBall = this.getStack("YarnBall");
    public final Map<Integer, IRecipe> guideRecipeMap = Maps.newHashMap();
    public IRecipe recipeLatticeMundane;
    public IRecipe recipeLatticeRegular;
    public IRecipe recipeLatticeSuper;

    public ItemCrafting() {
        super(NAMES, SORTED_NAMES, "silentgems", "CraftingMaterial");
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        list.add(TextFormatting.GOLD + SilentGems.localizationHelper.getItemSubText("CraftingMaterial", "desc", new Object[0]));
        super.clAddInformation(stack, world, list, advanced);
    }

    public void addRecipes(RecipeMaker recipes) {
        IRecipe recipe = recipes.addSurroundOre("chaos_essence_enriched", this.chaosEssenceEnriched, (Object)"dustGlowstone", new Object[]{"dustRedstone", "gemChaos"});
        this.guideRecipeMap.put(this.chaosEssenceEnriched.func_77952_i(), recipe);
        recipe = recipes.addSurroundOre("chaos_essence_crystallized", this.chaosEssenceCrystallized, (Object)this.enderEssence, new Object[]{this.netherShard, this.chaosEssenceEnriched});
        this.guideRecipeMap.put(this.chaosEssenceCrystallized.func_77952_i(), recipe);
        recipes.addCompression("chaos_essence", this.chaosEssenceShard, this.chaosEssence, 9);
        this.guideRecipeMap.put(this.chaosEssenceShard.func_77952_i(), recipes.makeShapelessOre(new ItemStack((Item)this, 9, this.chaosEssenceShard.func_77952_i()), new Object[]{this.chaosEssence}));
        recipes.addCompression("ender_essence", this.enderEssenceShard, this.enderEssence, 9);
        this.guideRecipeMap.put(this.enderEssenceShard.func_77952_i(), recipes.makeShapeless(new ItemStack((Item)this, 9, this.enderEssenceShard.func_77952_i()), new ItemStack[]{this.enderEssence}));
        recipe = recipes.addShapedOre("iron_rod", this.getStack("StickIron", 8), new Object[]{"igi", "igi", "igi", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE)});
        this.guideRecipeMap.put(this.toolRodIron.func_77952_i(), recipe);
        recipe = recipes.addShapedOre("ornate_rod_gold", this.getStack("OrnateStickGold", 8), new Object[]{"ifi", "ici", "ifi", Character.valueOf('i'), "ingotGold", Character.valueOf('f'), "ingotIron", Character.valueOf('c'), "gemChaos"});
        this.guideRecipeMap.put(this.toolRodGold.func_77952_i(), recipe);
        if (OreDictionary.doesOreNameExist((String)"ingotSilver")) {
            recipe = recipes.addShapedOre("ornate_rod_silver", this.getStack("OrnateStickSilver", 8), new Object[]{"ifi", "ici", "ifi", Character.valueOf('i'), "ingotSilver", Character.valueOf('f'), "ingotIron", Character.valueOf('c'), "gemChaos"});
            this.guideRecipeMap.put(this.toolRodSilver.func_77952_i(), recipe);
        }
        recipe = recipes.addShapelessOre("upgrade_base", this.getStack("UpgradeBase", 4), new Object[]{Items.field_151145_ak, Items.field_151145_ak, "plankWood", "stickWood"});
        this.guideRecipeMap.put(this.upgradeBase.func_77952_i(), recipe);
        recipe = recipes.addSurroundOre("chaos_coal_0", this.getStack("ChaosCoal", 8), (Object)"gemChaos", new Object[]{new ItemStack(Items.field_151044_h)});
        recipes.addSurroundOre("chaos_coal_1", this.getStack("ChaosCoal", 4), (Object)"gemChaos", new Object[]{new ItemStack(Items.field_151044_h, 1, 1)});
        this.guideRecipeMap.put(this.chaosCoal.func_77952_i(), recipe);
        recipes.addShapedOre("torches_chaos_coal", new ItemStack(Blocks.field_150478_aa, 16), new Object[]{"c", "s", Character.valueOf('c'), this.chaosCoal, Character.valueOf('s'), "stickWood"});
        recipe = recipes.addShapedOre("name_plate", this.getStack("NamePlate", 4), new Object[]{"iii", "pcp", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('p'), "paper", Character.valueOf('c'), "gemChaos"});
        this.guideRecipeMap.put(this.namePlate.func_77952_i(), recipe);
        recipe = recipes.addShapedOre("chaos_core", this.chaosCore, new Object[]{" c ", "cqc", " c ", Character.valueOf('c'), this.chaosEssenceEnriched, Character.valueOf('q'), "blockQuartz"});
        this.guideRecipeMap.put(this.chaosCore.func_77952_i(), recipe);
        recipe = recipes.addShapedOre("magnifying_glass", this.magnifyingGlass, new Object[]{" g ", "gpg", "rg ", Character.valueOf('g'), "ingotGold", Character.valueOf('p'), "paneGlass", Character.valueOf('r'), this.toolRodGold});
        this.guideRecipeMap.put(this.magnifyingGlass.func_77952_i(), recipe);
        recipe = recipes.addSurroundOre("plume", this.plume, (Object)new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE), new Object[]{"feather"});
        this.guideRecipeMap.put(this.plume.func_77952_i(), recipe);
        recipe = recipes.addSurroundOre("shiny_plume", this.shinyPlume, (Object)this.plume, new Object[]{"gemChaos", "ingotGold"});
        this.guideRecipeMap.put(this.shinyPlume.func_77952_i(), recipe);
        recipe = recipes.addSurround("ender_frost", this.enderFrost, this.enderEssence, new Object[]{Blocks.field_150432_aD});
        this.guideRecipeMap.put(this.enderFrost.func_77952_i(), recipe);
        recipe = recipes.addShapedOre("gilded_string", new ItemStack((Item)this, 3, this.gildedString.func_77952_i()), new Object[]{"gsg", "gsg", "gsg", Character.valueOf('s'), Items.field_151007_F, Character.valueOf('g'), "nuggetGold"});
        this.guideRecipeMap.put(this.gildedString.func_77952_i(), recipe);
        recipe = recipes.addSurround("yarn_ball", this.yarnBall, new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE), new Object[]{Items.field_151007_F});
        this.guideRecipeMap.put(this.yarnBall.func_77952_i(), recipe);
        recipe = recipes.addShapedOre("rawhide_bone", this.rawhideBone, new Object[]{" l ", "lbl", " l ", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('b'), Items.field_151103_aS});
        this.guideRecipeMap.put(this.rawhideBone.func_77952_i(), recipe);
        recipe = recipes.addSurroundOre("blazestone", this.blazestone, (Object)"dustRedstone", new Object[]{Items.field_151065_br});
        this.guideRecipeMap.put(this.blazestone.func_77952_i(), recipe);
        ItemStack netherStar = new ItemStack(Items.field_151156_bN);
        recipe = recipes.addSurroundOre("nether_shard", this.getStack("NetherShard", 24), (Object)netherStar, new Object[]{this.chaosEssenceEnriched, this.enderEssence});
        this.guideRecipeMap.put(this.netherShard.func_77952_i(), recipe);
        recipe = recipes.addShaped("nether_cluster", this.netherCluster, new Object[]{"sss", "s s", "sss", Character.valueOf('s'), this.netherShard});
        this.guideRecipeMap.put(this.netherCluster.func_77952_i(), recipe);
        recipes.addShapeless("nether_star", netherStar, new ItemStack[]{this.netherCluster, this.netherCluster, this.netherCluster});
        this.recipeLatticeMundane = recipes.addSurroundOre("armor_lattice_mundane", this.getStack("ArmorLatticeMundane", 24), (Object)"stickWood", new Object[]{"string", Items.field_151145_ak});
        this.guideRecipeMap.put(this.armorLatticeMundane.func_77952_i(), this.recipeLatticeMundane);
        this.recipeLatticeRegular = recipes.addSurroundOre("armor_lattice_regular", this.getStack("ArmorLatticeRegular", 24), (Object)this.fluffyFabric, new Object[]{"ingotIron", new ItemStack((Item)ModItems.gemShard, 1, Short.MAX_VALUE)});
        this.guideRecipeMap.put(this.armorLatticeRegular.func_77952_i(), this.recipeLatticeRegular);
        this.recipeLatticeSuper = recipes.addSurroundOre("armor_lattice_super", this.getStack("ArmorLatticeSuper", 24), (Object)"gemLapis", new Object[]{"gemDiamond", this.chaosEssenceEnriched});
        this.guideRecipeMap.put(this.armorLatticeSuper.func_77952_i(), this.recipeLatticeSuper);
        recipe = recipes.addShapedOre("chaos_iron_unfired", this.chaosIronUnfired, new Object[]{"c", "i", "c", Character.valueOf('c'), "gemChaos", Character.valueOf('i'), "ingotIron"});
        this.guideRecipeMap.put(this.chaosIronUnfired.func_77952_i(), recipe);
        recipes.addSmelting(this.chaosIronUnfired, this.chaosIron, 0.4f);
        recipe = recipes.addShapedOre("soul_shell", this.getStack("SoulShell", 2), new Object[]{" g ", "gdg", " g ", Character.valueOf('g'), "blockGlass", Character.valueOf('d'), "gemDiamond"});
        this.guideRecipeMap.put(this.soulShell.func_77952_i(), recipe);
        recipe = recipes.addShapedOre("stone_rod", this.getStack("StickStone", 4), new Object[]{"s", "s", Character.valueOf('s'), "cobblestone"});
        this.guideRecipeMap.put(this.toolRodStone.func_77952_i(), recipe);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int meta = stack.func_77952_i();
        if (meta == this.getMetaFor("ChaosEssencePlus")) {
            return EnumRarity.RARE;
        }
        return super.func_77613_e(stack);
    }

    public void addOreDict() {
        if (!OreDictionary.doesOreNameExist((String)"paper")) {
            OreDictionary.registerOre((String)"paper", (Item)Items.field_151121_aF);
        }
        if (!OreDictionary.doesOreNameExist((String)"feather")) {
            OreDictionary.registerOre((String)"feather", (Item)Items.field_151008_G);
        }
        OreDictionary.registerOre((String)"gemChaos", (ItemStack)this.chaosEssence);
        OreDictionary.registerOre((String)"nuggetChaos", (ItemStack)this.chaosEssenceShard);
        OreDictionary.registerOre((String)"gemEnderEssence", (ItemStack)this.enderEssence);
        OreDictionary.registerOre((String)"nuggetEnderEssence", (ItemStack)this.enderEssenceShard);
        OreDictionary.registerOre((String)"paper", (ItemStack)this.fluffyFabric);
        OreDictionary.registerOre((String)"slimeball", (ItemStack)this.enderSlimeBall);
        OreDictionary.registerOre((String)"rodStone", (ItemStack)this.toolRodStone);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (stack.func_77969_a(this.namePlate)) {
            if (!stack.func_82837_s()) {
                return false;
            }
            if (target instanceof EntityLiving) {
                EntityLiving entityLiving = (EntityLiving)target;
                if (entityLiving.func_145818_k_() && entityLiving.func_95999_t().equals(stack.func_82833_r())) {
                    return false;
                }
                entityLiving.func_96094_a(stack.func_82833_r());
                entityLiving.func_110163_bv();
                StackHelper.shrink((ItemStack)stack, (int)1);
                return true;
            }
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public int getItemBurnTime(ItemStack fuel) {
        return fuel.func_77973_b() == this && fuel.func_77952_i() == this.chaosCoal.func_77952_i() ? GemsConfig.BURN_TIME_CHAOS_COAL : 0;
    }
}

