/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import baubles.api.render.IRenderBauble;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.energy.IChaosStorage;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemChaosStorage;
import net.silentchaos512.gems.util.ChaosUtil;
import net.silentchaos512.gems.util.NBTHelper;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.lib.util.StackHelper;
import org.apache.commons.lang3.NotImplementedException;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles"), @Optional.Interface(iface="baubles.api.render.IRenderBauble", modid="baubles")})
public class ItemChaosOrb
extends ItemChaosStorage
implements IBauble,
IRenderBauble {
    public static final String NBT_CHARGE = "ChaosCharge";
    public static final String NBT_ITEM_SEND = "ItemSend";
    public static final int MAX_ITEM_SEND = 2000;

    public ItemChaosOrb() {
        super(Type.values().length, "ChaosOrb", 0);
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        boolean shifted = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)42);
        LocalizationHelper loc = SilentGems.localizationHelper;
        list.add(loc.getMiscText(NBT_CHARGE, new Object[]{this.getCharge(stack), this.getMaxCharge(stack)}));
        list.add(loc.getItemSubText(this.itemName, "breakChance", new Object[]{(int)(this.getType((ItemStack)stack).breakChance * 100.0f)}));
        boolean mode = this.isItemSendEnabled(stack);
        String onOrOff = loc.getMiscText("state." + (mode ? "on" : "off"), new Object[0]);
        onOrOff = (mode ? TextFormatting.GREEN : TextFormatting.RED) + onOrOff;
        list.add(loc.getItemSubText("ChaosOrb", "itemSend", new Object[]{onOrOff}));
        if (shifted) {
            for (String str : loc.getItemDescriptionLines(this.itemName)) {
                list.add(TextFormatting.ITALIC + str);
            }
        }
    }

    public void addRecipes(RecipeMaker recipes) {
        String chaosEssence = "gemChaos";
        ItemStack chaosEssenceEnriched = ModItems.craftingMaterial.chaosEssenceEnriched;
        ItemStack chaosEssenceCrystallized = ModItems.craftingMaterial.chaosEssenceCrystallized;
        String chaosEssenceShard = "nuggetChaos";
        block6: for (Type type : Type.values()) {
            ItemStack result = new ItemStack((Item)this, 1, type.ordinal());
            switch (type) {
                case FRAGILE: {
                    recipes.addShapedOre("chaos_orb_fragile", result, new Object[]{"ccc", "cdc", "ccc", Character.valueOf('c'), chaosEssence, Character.valueOf('d'), "gemDiamond"});
                    continue block6;
                }
                case POTATO: {
                    recipes.addShapedOre("chaos_orb_potato", result, new Object[]{"ccc", "cpc", "ccc", Character.valueOf('c'), chaosEssenceShard, Character.valueOf('p'), Items.field_151174_bG});
                    continue block6;
                }
                case REFINED: {
                    recipes.addShaped("chaos_orb_refined", result, new Object[]{" c ", "coc", " c ", Character.valueOf('c'), chaosEssenceEnriched, Character.valueOf('o'), new ItemStack((Item)this, 1, Type.FRAGILE.ordinal())});
                    continue block6;
                }
                case SUPREME: {
                    recipes.addShaped("chaos_orb_supreme", result, new Object[]{" c ", "coc", " c ", Character.valueOf('c'), chaosEssenceCrystallized, Character.valueOf('o'), new ItemStack((Item)this, 1, Type.REFINED.ordinal())});
                    continue block6;
                }
                default: {
                    throw new NotImplementedException("No recipe for chaos orb of type " + (Object)((Object)type));
                }
            }
        }
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        for (Type orbType : Type.values()) {
            String name = (this.getFullName() + orbType.ordinal()).toLowerCase();
            models.put(orbType.ordinal(), new ModelResourceLocation(name, "inventory"));
            for (int i = 1; i < orbType.crackStages; ++i) {
                int meta = orbType.ordinal() + (i << 4);
                models.put(meta, new ModelResourceLocation(name + "_" + i, "inventory"));
            }
        }
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        for (Type type : Type.values()) {
            ItemStack empty = new ItemStack(item, 1, type.ordinal());
            ItemStack half = empty.func_77946_l();
            ItemStack full = empty.func_77946_l();
            NBTHelper.setTagInt(half, NBT_CHARGE, this.getMaxCharge(half) / 2);
            NBTHelper.setTagInt(full, NBT_CHARGE, this.getMaxCharge(full));
            list.add(empty);
            list.add(half);
            list.add(full);
        }
    }

    public String getNameForStack(ItemStack stack) {
        return this.itemName + (stack.func_77952_i() & 0xF);
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.toggleItemSendEnabled(stack);
            boolean mode = this.isItemSendEnabled(stack);
            LocalizationHelper loc = SilentGems.localizationHelper;
            String onOrOff = loc.getMiscText("state." + (mode ? "on" : "off"), new Object[0]);
            onOrOff = (mode ? TextFormatting.GREEN : TextFormatting.RED) + onOrOff;
            String line = loc.getItemSubText("ChaosOrb", "itemSend", new Object[]{onOrOff});
            ChatHelper.sendStatusMessage((EntityPlayer)player, (ITextComponent)new TextComponentString(line), (boolean)true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.field_72995_K || worldIn.func_82737_E() % 20L != 0L) {
            return;
        }
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            int amount = this.extractCharge(stack, data.getChaosChargeSpeed(), true);
            amount = data.sendChaos(amount);
            this.extractCharge(stack, amount, false);
            int breakTries = amount / 1000;
            for (int i = 0; i < breakTries; ++i) {
                if (amount <= 0 || !(SilentGems.random.nextFloat() < this.getBreakChance(stack))) continue;
                this.damageOrb(stack, player);
                break;
            }
            if (this.isItemSendEnabled(stack)) {
                int totalSentToItems = 0;
                for (ItemStack itemstack : ChaosUtil.getChaosStorageItems(player)) {
                    if (itemstack.func_77973_b() == this || !(itemstack.func_77973_b() instanceof IChaosStorage)) continue;
                    int toSend = Math.min(this.getCharge(stack), 2000);
                    totalSentToItems += ((IChaosStorage)itemstack.func_77973_b()).receiveCharge(itemstack, toSend, false);
                }
                this.extractCharge(stack, totalSentToItems, false);
                breakTries = totalSentToItems / 2000;
                for (int i = 0; i < breakTries; ++i) {
                    if (!(SilentGems.random.nextFloat() < this.getBreakChance(stack) / 3.0f)) continue;
                    this.damageOrb(stack, player);
                    break;
                }
            }
        }
    }

    public Type getType(ItemStack stack) {
        int meta = stack.func_77952_i() & 0xF;
        if (meta >= 0 && meta < Type.values().length) {
            return Type.values()[meta];
        }
        return Type.POTATO;
    }

    public float getBreakChance(ItemStack stack) {
        int maxCharge;
        float baseChance = this.getType((ItemStack)stack).breakChance;
        int charge = this.getCharge(stack);
        float chargePercent = (float)charge / (float)(maxCharge = this.getMaxCharge(stack));
        if (chargePercent > 0.5f) {
            return 0.0f;
        }
        return baseChance * 2.0f * (0.5f - chargePercent);
    }

    public void damageOrb(ItemStack stack, EntityPlayer player) {
        int currentDamageLevel = (stack.func_77952_i() & 0xF0) >> 4;
        int newMeta = (stack.func_77952_i() & 0xF) + (++currentDamageLevel << 4);
        stack.func_77964_b(newMeta);
        if (currentDamageLevel >= this.getType((ItemStack)stack).crackStages) {
            this.breakOrb(stack, player);
            return;
        }
        String line = SilentGems.localizationHelper.getItemSubText(this.itemName, "crack", new Object[]{stack.func_82833_r()});
        ChatHelper.sendMessage((EntityPlayer)player, (String)line);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.AMBIENT, 0.6f, 1.5f);
    }

    public void breakOrb(ItemStack stack, EntityPlayer player) {
        int pieceCount = SilentGems.random.nextInt(99000) + 1000;
        String line = SilentGems.localizationHelper.getItemSubText(this.itemName, "break", new Object[]{stack.func_82833_r(), pieceCount});
        ChatHelper.sendMessage((EntityPlayer)player, (String)line);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.AMBIENT, 0.7f, -2.5f);
        PlayerHelper.removeItem((EntityPlayer)player, (ItemStack)stack);
    }

    public boolean isItemSendEnabled(ItemStack stack) {
        if (StackHelper.isEmpty((ItemStack)stack) || !stack.func_77942_o()) {
            return false;
        }
        if (!stack.func_77978_p().func_74764_b(NBT_ITEM_SEND)) {
            return true;
        }
        return stack.func_77978_p().func_74767_n(NBT_ITEM_SEND);
    }

    public void toggleItemSendEnabled(ItemStack stack) {
        if (StackHelper.isEmpty((ItemStack)stack)) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        boolean value = this.isItemSendEnabled(stack);
        stack.func_77978_p().func_74757_a(NBT_ITEM_SEND, !value);
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        return this.getType((ItemStack)stack).maxCharge;
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.TRINKET;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
        int currentDamageLevel = (stack.func_77952_i() & 0xF0) >> 4;
        if (currentDamageLevel >= this.getType((ItemStack)stack).crackStages) {
            int[] slots = this.getBaubleType(stack).getValidSlots();
            IBaublesItemHandler inventory = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player));
            for (int i = 0; i < slots.length; ++i) {
                ItemStack inSlot = inventory.getStackInSlot(slots[i]);
                if (inSlot != stack) continue;
                inventory.extractItem(slots[i], 1, false);
                break;
            }
        }
    }

    @Optional.Method(modid="baubles")
    public boolean willAutoSync(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="baubles")
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType renderType, float partialTicks) {
        if (renderType == IRenderBauble.RenderType.BODY) {
            float scale = 0.4f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IRenderBauble.Helper.translateToChest();
            GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)1.55);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        }
    }

    public static enum Type {
        POTATO(5000, 0.01f, 1),
        FRAGILE(100000, 0.2f, 3),
        REFINED(1000000, 0.05f, 5),
        SUPREME(10000000, 0.0f, 1);

        public final int maxCharge;
        public final float breakChance;
        public final int crackStages;

        private Type(int maxCharge, float breakChance, int crackStages) {
            this.maxCharge = maxCharge;
            this.breakChance = breakChance;
            this.crackStages = crackStages;
        }
    }
}

