/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.IItemHandler;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.inventory.SlotQuiver;
import net.silentchaos512.gems.item.quiver.IQuiver;

public class ContainerQuiver
extends Container {
    @Nonnull
    private final ItemStack quiver;
    @Nonnull
    private final IItemHandler itemHandler;
    private int blocked = -1;

    public ContainerQuiver(@Nonnull ItemStack quiver, @Nonnull InventoryPlayer inventoryPlayer, @Nonnull EnumHand hand) {
        this.quiver = quiver;
        this.itemHandler = ModItems.quiver.getInventory(quiver);
        this.setupSlots(inventoryPlayer, this.itemHandler, hand);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (!slot.func_82869_a(player)) {
            return slot.func_75211_c();
        }
        if (slotIndex == this.blocked) {
            return ItemStack.field_190927_a;
        }
        if (!slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex < 4) {
            if (!this.func_75135_a(stack, 4, this.field_75151_b.size(), true)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75218_e();
        } else if (!this.func_75135_a(stack, 0, 4, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return slot.func_190901_a(player, newStack);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int button, ClickType flag, EntityPlayer player) {
        if (slotId < 0 || slotId > this.field_75151_b.size()) {
            return super.func_184996_a(slotId, button, flag, player);
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (!this.canTake(slotId, slot, button, player, flag)) {
            return slot.func_75211_c();
        }
        return super.func_184996_a(slotId, button, flag, player);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!(this.quiver.func_77973_b() instanceof IQuiver)) {
            SilentGems.logHelper.warning((Object)("Item is not a quiver? " + this.quiver.func_77973_b()));
            return;
        }
        ((IQuiver)this.quiver.func_77973_b()).updateQuiver(this.quiver, this.itemHandler, playerIn);
    }

    public boolean canTake(int slotId, Slot slot, int button, EntityPlayer player, ClickType clickType) {
        if (slotId == this.blocked) {
            return false;
        }
        if (slotId <= 3 && player.field_71071_by.func_70445_o().func_77973_b() instanceof IQuiver) {
            return false;
        }
        if (clickType == ClickType.SWAP) {
            int hotbarId = 31 + button;
            if (this.blocked == hotbarId) {
                return false;
            }
            Slot hotbarSlot = this.func_75139_a(hotbarId);
            if (slotId <= 3 && (slot.func_75211_c().func_77973_b() instanceof IQuiver || hotbarSlot.func_75211_c().func_77973_b() instanceof IQuiver)) {
                return false;
            }
        }
        return true;
    }

    private void setupSlots(InventoryPlayer inventoryPlayer, IItemHandler itemHandler, EnumHand hand) {
        this.setupQuiverSlots(itemHandler);
        this.setupPlayerSlots(inventoryPlayer, hand);
    }

    private void setupQuiverSlots(IItemHandler itemHandler) {
        int xOffset = 1 + this.getContainerInvXOffset();
        int yOffset = 1 + this.getBorderTop();
        for (int x = 0; x < 4; ++x) {
            this.func_75146_a((Slot)new SlotQuiver(itemHandler, x, xOffset + x * 18, yOffset));
        }
    }

    private void setupPlayerSlots(InventoryPlayer inventoryPlayer, EnumHand hand) {
        int xOffset = 1 + this.getPlayerInvXOffset();
        int yOffset = 1 + this.getBorderTop() + this.getContainerInvHeight() + this.getBufferInventory();
        int y = 0;
        while (y < 3) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, x + y * 9 + 9, xOffset + x * 18, yOffset));
            }
            ++y;
            yOffset += 18;
        }
        yOffset += this.getBufferHotbar();
        for (int x = 0; x < 9; ++x) {
            Slot slot = this.func_75146_a(new Slot((IInventory)inventoryPlayer, x, xOffset + x * 18, yOffset){

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return this.field_75222_d != ContainerQuiver.this.blocked;
                }
            });
            if (x != inventoryPlayer.field_70461_c || hand != EnumHand.MAIN_HAND) continue;
            this.blocked = slot.field_75222_d;
        }
    }

    public int getBorderTop() {
        return 34;
    }

    public int getBorderSide() {
        return 7;
    }

    public int getBorderBottom() {
        return 7;
    }

    public int getBufferInventory() {
        return 31;
    }

    public int getBufferHotbar() {
        return 4;
    }

    public int getWidth() {
        return 72 + this.getBorderSide() * 2;
    }

    public int getHeight() {
        return this.getBorderTop() + 18 + this.getBufferInventory() + 72 + this.getBufferHotbar() + this.getBorderBottom();
    }

    public int getContainerInvWidth() {
        return 72;
    }

    public int getContainerInvHeight() {
        return 18;
    }

    public int getContainerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getPlayerInvWidth() - this.getContainerInvWidth()) / 2);
    }

    public int getPlayerInvXOffset() {
        return this.getBorderSide() + Math.max(0, (this.getContainerInvWidth() - this.getPlayerInvWidth()) / 2);
    }

    public int getPlayerInvWidth() {
        return 162;
    }

    public int getPlayerInvHeight() {
        return 72 + this.getBufferHotbar();
    }
}

