/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.guide;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.client.gui.config.GuiConfigSilentGems;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.guide.page.PageDebugTool;
import net.silentchaos512.gems.guide.page.PageOreSpawn;
import net.silentchaos512.gems.guide.page.PageSoulSkill;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemChaosOrb;
import net.silentchaos512.gems.item.ItemCrafting;
import net.silentchaos512.gems.item.ItemTipUpgrade;
import net.silentchaos512.gems.lib.ChaosBuff;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.util.ArmorHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.gems.util.ToolRandomizer;
import net.silentchaos512.lib.guidebook.GuideBook;
import net.silentchaos512.lib.guidebook.IGuideEntry;
import net.silentchaos512.lib.guidebook.IGuidePage;
import net.silentchaos512.lib.guidebook.chapter.GuideChapter;
import net.silentchaos512.lib.guidebook.entry.GuideEntry;
import net.silentchaos512.lib.guidebook.page.PageCrafting;
import net.silentchaos512.lib.guidebook.page.PageFurnace;
import net.silentchaos512.lib.guidebook.page.PagePicture;
import net.silentchaos512.lib.guidebook.page.PageTextOnly;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.StackHelper;

public class GuideBookGems
extends GuideBook {
    public static final String TOOL_OWNER_NAME = "Guide Book";
    private GuideEntry entryGettingStarted;
    private GuideEntry entryBlocks;
    private GuideEntry entryItems;
    private GuideEntry entryTools;
    private GuideEntry entrySouls;
    private GuideEntry entryEnchantments;
    private GuideEntry entryDebug;
    public static final String[] QUOTES = new String[]{"The flowers probably won't kill you.", "Try the donuts!", "May contain unintended &cR&6a&ei&an&9b&do&5w&0s!".replaceAll("&", "\u00a7"), "Shake well and refrigerate after opening.", "Drowning in [slightly fewer] JSON files...", "Download only from CurseForge!", "Rabbit poop coffee!", "It stares into your soul.", "Pot now included... flower pot, that is.", "Did you know Chaos Gems are finally back?", "Also try Extra Parts!", "Your wish has been granted!", "Voted most unnecessarily complicated mod in high school.", "I like your gems!@HockeyStick", "Also try JEI! Seriously, learn to look up the recipes... How do you play without mods like this?", "How do you craft the upgrades?@Everyone Ever", "Scathing comments since 2017!", "Muffin button not included.", "Now with more enchantments!", "Send help.@SilentChaos512", "Good lookin' mainframes!"};

    public GuideBookGems() {
        super("silentgems");
        this.resourceGui = new ResourceLocation("silentgems", "textures/guide/gui_guide.png");
        this.resourceGadgets = new ResourceLocation("silentgems", "textures/guide/gui_guide_gadgets.png");
        this.edition = 270;
    }

    public void initEntries() {
        this.entryGettingStarted = new GuideEntry((GuideBook)this, "gettingStarted").setImportant();
        this.entryBlocks = new GuideEntry((GuideBook)this, "blocks");
        this.entryItems = new GuideEntry((GuideBook)this, "items");
        this.entryTools = new GuideEntry((GuideBook)this, "tools");
        this.entrySouls = new GuideEntry((GuideBook)this, "souls");
        this.entryEnchantments = new GuideEntry((GuideBook)this, "enchantments");
        if (this.edition == 0 || GemsConfig.DEBUG_MODE) {
            this.entryDebug = new GuideEntry((GuideBook)this, "debug").setSpecial();
        }
    }

    public void initChapters() {
        RecipeMaker rec = SilentGems.registry.recipes;
        new GuideChapter((GuideBook)this, "introduction", (IGuideEntry)this.entryGettingStarted, new ItemStack((Item)ModItems.gem, 1, SilentGems.random.nextInt(32)), 1000, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2), new PageTextOnly((GuideBook)this, 3)}).setSpecial();
        ItemStack flintPickaxe = ModItems.pickaxe.constructTool(false, new ItemStack(Items.field_151145_ak));
        ToolHelper.setOriginalOwner(flintPickaxe, TOOL_OWNER_NAME);
        ItemStack flintPickaxeBroken = StackHelper.safeCopy((ItemStack)flintPickaxe);
        flintPickaxeBroken.func_77964_b(ToolHelper.getMaxDamage(flintPickaxeBroken));
        ItemStack ironTipUpgrade = new ItemStack((Item)ModItems.tipUpgrade);
        ItemStack flintPickaxeIronTips = ModItems.tipUpgrade.applyToTool(flintPickaxe, ironTipUpgrade);
        ItemStack gravel = new ItemStack(Blocks.field_150351_n);
        ItemStack gemPickaxe = ModItems.pickaxe.constructTool(new ItemStack(Items.field_151055_y), EnumGem.RUBY.getItem(), EnumGem.SAPPHIRE.getItem(), EnumGem.RUBY.getItem());
        ToolHelper.setOriginalOwner(gemPickaxe, TOOL_OWNER_NAME);
        ItemStack diamondTipUpgrade = new ItemStack((Item)ModItems.tipUpgrade, 1, 2);
        ItemStack gemPickaxeDiamondTips = ModItems.tipUpgrade.applyToTool(gemPickaxe, diamondTipUpgrade);
        ItemStack katana = ModItems.katana.constructTool(true, EnumGem.LEPIDOLITE.getItemSuper(), EnumGem.OPAL.getItemSuper(), EnumGem.BLACK_DIAMOND.getItemSuper());
        ToolHelper.setOriginalOwner(katana, TOOL_OWNER_NAME);
        new GuideChapter((GuideBook)this, "progression", (IGuideEntry)this.entryGettingStarted, flintPickaxeIronTips, 100, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapeless(new ItemStack(Items.field_151145_ak), new ItemStack[]{gravel, gravel})}), new PageCrafting((GuideBook)this, 3, new IRecipe[]{rec.makeShapedOre(flintPickaxe, new Object[]{"fff", " s ", " s ", Character.valueOf('f'), Items.field_151145_ak, Character.valueOf('s'), "stickWood"})}), new PageTextOnly((GuideBook)this, 4), new PageCrafting((GuideBook)this, 5, new IRecipe[]{rec.makeShapeless(flintPickaxe, new Object[]{flintPickaxeBroken, Items.field_151145_ak, Items.field_151145_ak})}), new PageTextOnly((GuideBook)this, 6), new PageCrafting((GuideBook)this, 7, new IRecipe[]{rec.makeShapelessOre(flintPickaxeIronTips, new Object[]{flintPickaxe, ironTipUpgrade})}), new PageCrafting((GuideBook)this, 8, new IRecipe[]{rec.makeShapedOre(gemPickaxe, new Object[]{"rsr", " t ", " t ", Character.valueOf('r'), EnumGem.RUBY.getItem(), Character.valueOf('s'), EnumGem.SAPPHIRE.getItem(), Character.valueOf('t'), "stickWood"})}), new PageTextOnly((GuideBook)this, 9), new PageCrafting((GuideBook)this, 10, new IRecipe[]{rec.makeShapeless(gemPickaxeDiamondTips, new ItemStack[]{gemPickaxe, diamondTipUpgrade})}), new PageTextOnly((GuideBook)this, 11), new PageCrafting((GuideBook)this, 12, new IRecipe[]{rec.makeShapedOre(katana, new Object[]{"lo", "d ", "r ", Character.valueOf('l'), EnumGem.LEPIDOLITE.getItemSuper(), Character.valueOf('o'), EnumGem.OPAL.getItemSuper(), Character.valueOf('d'), EnumGem.BLACK_DIAMOND.getItemSuper(), Character.valueOf('r'), ModItems.craftingMaterial.toolRodGold})}), new PageTextOnly((GuideBook)this, 13)}).setImportant();
        ItemStack toolsEntryRod = SilentGems.random.nextFloat() < 0.67f ? ModItems.craftingMaterial.toolRodGold : ModItems.craftingMaterial.toolRodSilver;
        ItemStack chAxeGem = EnumGem.getRandom().getItemSuper();
        ItemStack chAxe = this.makeTool(ModItems.axe, toolsEntryRod, chAxeGem, 3);
        new GuideChapter((GuideBook)this, "axe", (IGuideEntry)this.entryTools, chAxe, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chAxe, new Object[]{"gg", "gr", " r", Character.valueOf('g'), chAxeGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chBowGem = EnumGem.getRandom().getItemSuper();
        ItemStack chBow = this.makeTool(ModItems.bow, toolsEntryRod, chBowGem, 3);
        new GuideChapter((GuideBook)this, "bow", (IGuideEntry)this.entryTools, chBow, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chBow, new Object[]{"rgs", "g s", "rgs", Character.valueOf('g'), chBowGem, Character.valueOf('r'), toolsEntryRod, Character.valueOf('s'), ModItems.craftingMaterial.gildedString})})});
        ItemStack chDaggerGem = EnumGem.getRandom().getItemSuper();
        ItemStack chDagger = this.makeTool(ModItems.dagger, toolsEntryRod, chDaggerGem, 1);
        new GuideChapter((GuideBook)this, "dagger", (IGuideEntry)this.entryTools, chDagger, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chDagger, new Object[]{"g", "r", "f", Character.valueOf('g'), chDaggerGem, Character.valueOf('r'), toolsEntryRod, Character.valueOf('f'), "ingotGold"})})});
        ItemStack chHoeGem = EnumGem.getRandom().getItemSuper();
        ItemStack chHoe = this.makeTool(ModItems.hoe, toolsEntryRod, chHoeGem, 2);
        new GuideChapter((GuideBook)this, "hoe", (IGuideEntry)this.entryTools, chHoe, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chHoe, new Object[]{"gg", " r", " r", Character.valueOf('g'), chHoeGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chKatanaGem = EnumGem.getRandom().getItemSuper();
        ItemStack chKatana = this.makeTool(ModItems.katana, toolsEntryRod, chKatanaGem, 3);
        new GuideChapter((GuideBook)this, "katana", (IGuideEntry)this.entryTools, chKatana, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chKatana, new Object[]{"gg", "g ", "r ", Character.valueOf('g'), chKatanaGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chMacheteGem = EnumGem.getRandom().getItemSuper();
        ItemStack chMachete = this.makeTool(ModItems.machete, toolsEntryRod, chMacheteGem, 3);
        new GuideChapter((GuideBook)this, "machete", (IGuideEntry)this.entryTools, chMachete, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chMachete, new Object[]{" gg", " g ", "r  ", Character.valueOf('g'), chMacheteGem, Character.valueOf('r'), toolsEntryRod})}).setNoText(), new PageTextOnly((GuideBook)this, 3), new PageTextOnly((GuideBook)this, 4)});
        ItemStack chPaxelGem = EnumGem.getRandom().getItemSuper();
        ItemStack chPaxel = this.makeTool(ModItems.paxel, toolsEntryRod, chPaxelGem, 6);
        new GuideChapter((GuideBook)this, "paxel", (IGuideEntry)this.entryTools, chPaxel, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chPaxel, new Object[]{"ggg", "grg", "gr ", Character.valueOf('g'), chPaxelGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chPickaxeGem = EnumGem.getRandom().getItemSuper();
        ItemStack chPickaxe = this.makeTool(ModItems.pickaxe, toolsEntryRod, chPickaxeGem, 3);
        new GuideChapter((GuideBook)this, "pickaxe", (IGuideEntry)this.entryTools, chPickaxe, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chPickaxe, new Object[]{"ggg", " r ", " r ", Character.valueOf('g'), chPickaxeGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chScepterGem = EnumGem.getRandom().getItemSuper();
        ItemStack chScepter = this.makeTool(ModItems.scepter, toolsEntryRod, chScepterGem, 5);
        new GuideChapter((GuideBook)this, "scepter", (IGuideEntry)this.entryTools, chScepter, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chScepter, new Object[]{" g ", "grg", "grg", Character.valueOf('g'), chScepterGem, Character.valueOf('r'), toolsEntryRod})}).setNoText(), new PageTextOnly((GuideBook)this, 3)});
        ItemStack chShieldGem = EnumGem.getRandom().getItemSuper();
        ItemStack chShield = this.makeTool(ModItems.shield, toolsEntryRod, chShieldGem, 3);
        new GuideChapter((GuideBook)this, "shield", (IGuideEntry)this.entryTools, chShield, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chShield, new Object[]{"gwg", "wrw", " g ", Character.valueOf('g'), chShieldGem, Character.valueOf('r'), toolsEntryRod, Character.valueOf('w'), "plankWood"})}).setNoText()});
        ItemStack chShovelGem = EnumGem.getRandom().getItemSuper();
        ItemStack chShovel = this.makeTool(ModItems.shovel, toolsEntryRod, chShovelGem, 1);
        new GuideChapter((GuideBook)this, "shovel", (IGuideEntry)this.entryTools, chShovel, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chShovel, new Object[]{"g", "r", "r", Character.valueOf('g'), chShovelGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chSickleGem = EnumGem.getRandom().getItemSuper();
        ItemStack chSickle = this.makeTool(ModItems.sickle, toolsEntryRod, chSickleGem, 3);
        new GuideChapter((GuideBook)this, "sickle", (IGuideEntry)this.entryTools, chSickle, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chSickle, new Object[]{" g", "gg", "r ", Character.valueOf('g'), chSickleGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chSwordGem = EnumGem.getRandom().getItemSuper();
        ItemStack chSword = this.makeTool(ModItems.sword, toolsEntryRod, chSwordGem, 2);
        new GuideChapter((GuideBook)this, "sword", (IGuideEntry)this.entryTools, chSword, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chSword, new Object[]{"g", "g", "r", Character.valueOf('g'), chSwordGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chTomahawkGem = EnumGem.getRandom().getItemSuper();
        ItemStack chTomahawk = this.makeTool(ModItems.tomahawk, toolsEntryRod, chTomahawkGem, 4);
        new GuideChapter((GuideBook)this, "tomahawk", (IGuideEntry)this.entryTools, chTomahawk, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapedOre(chTomahawk, new Object[]{"ggg", "gr ", " r ", Character.valueOf('g'), chTomahawkGem, Character.valueOf('r'), toolsEntryRod})}).setNoText()});
        ItemStack chHelmetGem = EnumGem.getRandom().getItemSuper();
        ItemStack chHelmet = ModItems.gemHelmet.constructArmor(EnumMaterialTier.SUPER, chHelmetGem);
        ItemStack chHelmetFrame = ModItems.armorFrame.getFrameForArmorPiece((ItemArmor)ModItems.gemHelmet, EnumMaterialTier.SUPER);
        ArmorHelper.setOriginalOwner(chHelmet, TOOL_OWNER_NAME);
        new GuideChapter((GuideBook)this, "armor", (IGuideEntry)this.entryTools, chHelmet, -10, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{ModItems.craftingMaterial.recipeLatticeMundane}).setNoText(), new PageCrafting((GuideBook)this, 3, new IRecipe[]{ModItems.craftingMaterial.recipeLatticeRegular}).setNoText(), new PageCrafting((GuideBook)this, 4, new IRecipe[]{ModItems.craftingMaterial.recipeLatticeSuper}).setNoText(), new PageCrafting((GuideBook)this, 5, new IRecipe[]{rec.makeShaped(chHelmetFrame, new Object[]{"lll", "l l", Character.valueOf('l'), ModItems.craftingMaterial.armorLatticeSuper})}), new PageCrafting((GuideBook)this, 6, new IRecipe[]{rec.makeShapedOre(chHelmet, new Object[]{" g ", "gfg", " g ", Character.valueOf('g'), chHelmetGem, Character.valueOf('f'), chHelmetFrame})})});
        new GuideChapter((GuideBook)this, "ores", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.gemOre, 1, SilentGems.random.nextInt(16)), 10, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageOreSpawn(this, 2, GemsConfig.WORLD_GEN_GEMS), new PageOreSpawn(this, 3, GemsConfig.WORLD_GEN_GEMS_DARK), new PageOreSpawn(this, 8, GemsConfig.WORLD_GEN_GEMS_LIGHT), new PageOreSpawn(this, 4, GemsConfig.WORLD_GEN_CHAOS), new PageFurnace((GuideBook)this, 5, ModItems.craftingMaterial.chaosEssence), new PageOreSpawn(this, 6, GemsConfig.WORLD_GEN_ENDER), new PageFurnace((GuideBook)this, 7, ModItems.craftingMaterial.enderEssence)}).setImportant();
        new GuideChapter((GuideBook)this, "chaosAltar", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.chaosAltar), new IGuidePage[]{new PageCrafting((GuideBook)this, 1, new IRecipe[]{ModBlocks.chaosAltar.recipe}), new PageTextOnly((GuideBook)this, 2), new PageTextOnly((GuideBook)this, 3), new PageTextOnly((GuideBook)this, 4)});
        new GuideChapter((GuideBook)this, "chaosFlowerPot", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.chaosFlowerPot), new IGuidePage[]{new PageCrafting((GuideBook)this, 1, new IRecipe[]{ModBlocks.chaosFlowerPot.recipe}), new PageTextOnly((GuideBook)this, 2)});
        new GuideChapter((GuideBook)this, "chaosNode", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.chaosNode), new IGuidePage[]{new PagePicture((GuideBook)this, 3, new ResourceLocation("silentgems", "textures/guide/chaosnode.png"), 125), new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2)});
        new GuideChapter((GuideBook)this, "chaosPylon", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.chaosPylon), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2)});
        new GuideChapter((GuideBook)this, "fluffyBlocks", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.fluffyBlock), new IGuidePage[]{new PageCrafting((GuideBook)this, 1, new IRecipe[]{rec.makeShaped(new ItemStack((Block)ModBlocks.fluffyBlock), new Object[]{"ff", "ff", Character.valueOf('f'), ModItems.craftingMaterial.fluffyFabric})}), new PageTextOnly((GuideBook)this, 2)});
        new GuideChapter((GuideBook)this, "glowRose", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.glowRose), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1)});
        new GuideChapter((GuideBook)this, "materialGrader", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.materialGrader), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2)});
        new GuideChapter((GuideBook)this, "gemDecoBlocks", (IGuideEntry)this.entryBlocks, new ItemStack((Block)ModBlocks.gemBrickCoated, 1, SilentGems.random.nextInt(16)), -10, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1)});
        ArrayList<Object> pages = Lists.newArrayList();
        pages.add(new PageTextOnly((GuideBook)this, 1));
        for (String str : ItemCrafting.SORTED_NAMES) {
            ItemStack stack = ModItems.craftingMaterial.getStack(str);
            IRecipe recipe = ModItems.craftingMaterial.guideRecipeMap.get(stack.func_77952_i());
            if (stack.func_77969_a(ModItems.craftingMaterial.chaosEssence) || stack.func_77969_a(ModItems.craftingMaterial.enderEssence) || stack.func_77969_a(ModItems.craftingMaterial.chaosIron)) {
                pages.add(new PageFurnace((GuideBook)this, 100 + stack.func_77952_i(), stack));
                continue;
            }
            if (recipe != null) {
                pages.add(new PageCrafting((GuideBook)this, 100 + stack.func_77952_i(), new IRecipe[]{recipe}));
                continue;
            }
            pages.add(new PageTextOnly((GuideBook)this, 100 + stack.func_77952_i()));
        }
        new GuideChapter((GuideBook)this, "craftingMaterial", (IGuideEntry)this.entryItems, ModItems.craftingMaterial.chaosEssence, pages.toArray(new IGuidePage[pages.size()]));
        ItemStack chChaosGem = new ItemStack((Item)ModItems.chaosGem, 1, EnumGem.getRandom().ordinal());
        ModItems.chaosGem.receiveCharge(chChaosGem, ModItems.chaosGem.getMaxCharge(chChaosGem), false);
        ItemStack chChaosGemWithBuffs = StackHelper.safeCopy((ItemStack)chChaosGem);
        ItemStack chChaosGemRuneStrength = new ItemStack((Item)ModItems.chaosRune);
        ModItems.chaosRune.setBuff(chChaosGemRuneStrength, ChaosBuff.STRENGTH);
        ItemStack chChaosGemRuneResistance = new ItemStack((Item)ModItems.chaosRune);
        ModItems.chaosRune.setBuff(chChaosGemRuneResistance, ChaosBuff.RESISTANCE);
        ModItems.chaosGem.addBuff(chChaosGemWithBuffs, ChaosBuff.STRENGTH);
        ModItems.chaosGem.addBuff(chChaosGemWithBuffs, ChaosBuff.STRENGTH);
        ModItems.chaosGem.addBuff(chChaosGemWithBuffs, ChaosBuff.RESISTANCE);
        ModItems.chaosGem.addBuff(chChaosGemWithBuffs, ChaosBuff.RESISTANCE);
        new GuideChapter((GuideBook)this, "chaosGem", (IGuideEntry)this.entryItems, chChaosGem, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapeless(chChaosGemWithBuffs, new ItemStack[]{chChaosGem, chChaosGemRuneStrength, chChaosGemRuneStrength, chChaosGemRuneResistance, chChaosGemRuneResistance})}), new PageTextOnly((GuideBook)this, 3)});
        ItemStack chChaosOrb = new ItemStack((Item)ModItems.chaosOrb, 1, ItemChaosOrb.Type.SUPREME.ordinal());
        ModItems.chaosOrb.receiveCharge(chChaosOrb, ModItems.chaosOrb.getMaxCharge(chChaosOrb), false);
        new GuideChapter((GuideBook)this, "chaosOrb", (IGuideEntry)this.entryItems, chChaosOrb, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2)});
        ItemStack chDrawingCompass = new ItemStack((Item)ModItems.drawingCompass);
        new GuideChapter((GuideBook)this, "drawingCompass", (IGuideEntry)this.entryItems, chDrawingCompass, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2)});
        ItemStack chEnchantmentToken = new ItemStack((Item)ModItems.enchantmentToken, 1, 256);
        ItemStack tokenSharpness = ModItems.enchantmentToken.constructToken(Enchantments.field_185302_k);
        ItemStack chEnchantmentTokenPickaxe = ToolRandomizer.INSTANCE.randomize(new ItemStack((Item)ModItems.pickaxe), 0.75f);
        ItemStack chEnchantmentTokenPickaxeEnchanted = StackHelper.safeCopy((ItemStack)chEnchantmentTokenPickaxe);
        ItemStack tokenUnbreaking = ModItems.enchantmentToken.constructToken(Enchantments.field_185307_s);
        ItemStack tokenFortune = ModItems.enchantmentToken.constructToken(Enchantments.field_185308_t);
        for (int i = 0; i < 3; ++i) {
            ModItems.enchantmentToken.applyTokenToTool(tokenFortune, chEnchantmentTokenPickaxeEnchanted);
            ModItems.enchantmentToken.applyTokenToTool(tokenUnbreaking, chEnchantmentTokenPickaxeEnchanted);
        }
        new GuideChapter((GuideBook)this, "enchantmentToken", (IGuideEntry)this.entryItems, chEnchantmentToken, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2), new PageCrafting((GuideBook)this, 3, new IRecipe[]{rec.makeShapedOre(new ItemStack((Item)ModItems.enchantmentToken, 12, 256), new Object[]{"ggg", "lcl", "ggg", Character.valueOf('g'), "ingotGold", Character.valueOf('l'), "gemLapis", Character.valueOf('c'), "gemChaos"})}), new PageCrafting((GuideBook)this, 4, new IRecipe[]{rec.makeShapedOre(tokenSharpness, new Object[]{"r r", "fbf", "fff", Character.valueOf('r'), "gemRuby", Character.valueOf('f'), Items.field_151145_ak, Character.valueOf('b'), chEnchantmentToken})}), new PageTextOnly((GuideBook)this, 5), new PageCrafting((GuideBook)this, 6, new IRecipe[]{rec.makeShapeless(chEnchantmentTokenPickaxeEnchanted, new ItemStack[]{chEnchantmentTokenPickaxe, tokenUnbreaking, tokenUnbreaking, tokenUnbreaking, tokenFortune, tokenFortune, tokenFortune})})});
        new GuideChapter((GuideBook)this, "fluffyPuff", (IGuideEntry)this.entryItems, new ItemStack((Item)ModItems.fluffyPuff), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1)});
        EnumGem chGem = EnumGem.getRandom();
        ItemStack craftedShards = StackHelper.setCount((ItemStack)StackHelper.safeCopy((ItemStack)chGem.getShard()), (int)9);
        new GuideChapter((GuideBook)this, "gem", (IGuideEntry)this.entryItems, chGem.getItem(), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapelessOre(craftedShards, new Object[]{chGem.getItem()})}), new PageCrafting((GuideBook)this, 3, new IRecipe[]{rec.makeShapedOre(chGem.getItemSuper(), new Object[]{"cgc", "cdc", "cgc", Character.valueOf('c'), ModItems.craftingMaterial.chaosEssence, Character.valueOf('g'), chGem.getItem(), Character.valueOf('d'), "dustGlowstone"})})});
        ItemStack chHoldingGem = ModItems.holdingGem.construct(EnumGem.getRandom());
        ItemStack chHoldingGemIcon = StackHelper.safeCopy((ItemStack)chHoldingGem);
        chHoldingGemIcon.func_77964_b(0);
        ItemStack chHoldingGemSet = StackHelper.safeCopy((ItemStack)chHoldingGem);
        ModItems.holdingGem.setBlockPlaced(chHoldingGemSet, Blocks.field_150347_e.func_176223_P());
        chHoldingGemSet.func_77964_b(chHoldingGemSet.func_77958_k() - 1);
        new GuideChapter((GuideBook)this, "holdingGem", (IGuideEntry)this.entryItems, chHoldingGemIcon, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShapeless(chHoldingGemSet, new ItemStack[]{chHoldingGem, new ItemStack(Blocks.field_150347_e)})}), new PageTextOnly((GuideBook)this, 3)});
        ItemStack chTipUpgrade = new ItemStack((Item)ModItems.tipUpgrade, 1, 2);
        pages = Lists.newArrayList();
        pages.add(new PageTextOnly((GuideBook)this, 1));
        pages.add(new PageTextOnly((GuideBook)this, 2));
        pages.add(new PageCrafting((GuideBook)this, 3, new IRecipe[]{rec.makeShapelessOre(ModItems.craftingMaterial.upgradeBase, new Object[]{Items.field_151145_ak, Items.field_151145_ak, "stickWood", "plankWood"})}));
        for (IRecipe recipe : ItemTipUpgrade.RECIPES) {
            pages.add(new PageCrafting((GuideBook)this, 0, new IRecipe[]{recipe}).setNoText());
        }
        new GuideChapter((GuideBook)this, "tipUpgrade", (IGuideEntry)this.entryItems, chTipUpgrade, pages.toArray(new IGuidePage[pages.size()]));
        ItemStack chTorchBandolier = new ItemStack((Item)ModItems.torchBandolier);
        new GuideChapter((GuideBook)this, "torchBandolier", (IGuideEntry)this.entryItems, chTorchBandolier, new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2)});
        new GuideChapter((GuideBook)this, "toolSoul", (IGuideEntry)this.entrySouls, new ItemStack((Item)ModItems.toolSoul), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageCrafting((GuideBook)this, 2, new IRecipe[]{rec.makeShaped(new ItemStack((Item)ModItems.toolSoul), new Object[]{" s ", "sds", " s ", Character.valueOf('s'), ModItems.soulGem, Character.valueOf('d'), ModItems.craftingMaterial.soulShell})})});
        pages = new ArrayList<Object>();
        pages.add(new PageTextOnly((GuideBook)this, 1));
        pages.add(new PageTextOnly((GuideBook)this, 2));
        for (SoulSkill skill : SoulSkill.getSkillList()) {
            pages.add((Object)new PageSoulSkill(this, skill));
        }
        new GuideChapter((GuideBook)this, "soulSkills", (IGuideEntry)this.entrySouls, new ItemStack((Item)ModItems.skillOrb), pages.toArray(new IGuidePage[pages.size()]));
        new GuideChapter((GuideBook)this, "enchantmentGravity", (IGuideEntry)this.entryEnchantments, ModItems.enchantmentToken.constructToken(ModEnchantments.gravity), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1)});
        new GuideChapter((GuideBook)this, "enchantmentIceAspect", (IGuideEntry)this.entryEnchantments, ModItems.enchantmentToken.constructToken(ModEnchantments.iceAspect), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1)});
        new GuideChapter((GuideBook)this, "enchantmentLifeSteal", (IGuideEntry)this.entryEnchantments, ModItems.enchantmentToken.constructToken(ModEnchantments.lifeSteal), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1), new PageTextOnly((GuideBook)this, 2)});
        new GuideChapter((GuideBook)this, "enchantmentLightningAspect", (IGuideEntry)this.entryEnchantments, ModItems.enchantmentToken.constructToken(ModEnchantments.lightningAspect), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1)});
        new GuideChapter((GuideBook)this, "enchantmentMagicDamage", (IGuideEntry)this.entryEnchantments, ModItems.enchantmentToken.constructToken(ModEnchantments.magicDamage), new IGuidePage[]{new PageTextOnly((GuideBook)this, 1)});
        if (this.entryDebug != null) {
            new GuideChapter((GuideBook)this, "toolTest", (IGuideEntry)this.entryDebug, ModItems.craftingMaterial.ironPotato, new IGuidePage[]{new PageDebugTool(this, 1), new PageDebugTool(this, 2)});
        }
    }

    public String[] getQuotes() {
        return QUOTES;
    }

    @Nonnull
    public String selectQuote(Random rand) {
        if (rand.nextInt(100) == 0) {
            return "Lolis are love, lolis are life!";
        }
        return super.selectQuote(rand);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getConfigScreen(GuiScreen parent) {
        return new GuiConfigSilentGems(parent);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getAchievementScreen(GuiScreen parent) {
        return null;
    }

    private ItemStack makeTool(ITool tool, ItemStack rod, ItemStack gem, int gemCount) {
        ItemStack[] array = new ItemStack[gemCount];
        for (int i = 0; i < array.length; ++i) {
            array[i] = gem;
        }
        ItemStack ret = tool.constructTool(rod, array);
        ToolHelper.setOriginalOwner(ret, TOOL_OWNER_NAME);
        return ret;
    }
}

