/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity;

import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.entity.EntityChaosProjectile;

public class EntityChaosProjectileHoming
extends EntityChaosProjectile {
    protected Entity homingTarget = null;
    protected double homingTightness;
    protected double homingSpeed;

    public EntityChaosProjectileHoming(World worldIn) {
        super(worldIn);
    }

    public EntityChaosProjectileHoming(EntityLivingBase shooter, ItemStack castingStack, float damage, boolean flyUpBeforeHoming, double homingTightness, double homingSpeed) {
        super(shooter, castingStack, damage);
        this.homingTightness = homingTightness;
        this.homingSpeed = homingSpeed;
        Vec3d vec = shooter.func_70040_Z();
        if (flyUpBeforeHoming) {
            vec = vec.func_178785_b(2.0f * SilentGems.random.nextFloat() - 0.5f);
            vec = new Vec3d(vec.field_72450_a, 2.0, vec.field_72449_c).func_72432_b().func_186678_a(0.25 + 1.5 * SilentGems.random.nextDouble());
        }
        this.field_70159_w = vec.field_72450_a;
        this.field_70181_x = vec.field_72448_b;
        this.field_70179_y = vec.field_72449_c;
    }

    public void findHomingTarget() {
        if (this.field_70170_p.field_72995_K || this.homingTarget != null || this.field_70173_aa % 100 != 0 && this.field_70173_aa > 20) {
            return;
        }
        this.homingTarget = null;
        EntityChaosProjectileHoming projectile = this;
        Predicate predicate = input -> this.shooter != null && this.shooter != input && !input.func_184191_r((Entity)this.shooter);
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
            EntityLivingBase entityLiving;
            Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
            if (!(entity instanceof EntityLivingBase) || !predicate.apply((Object)(entityLiving = (EntityLivingBase)entity))) continue;
            int distance = (int)entityLiving.func_70068_e((Entity)projectile) + SilentGems.random.nextInt(512);
            if (distance >= 1200 || distance >= minDistance) continue;
            minDistance = distance;
            this.homingTarget = entityLiving;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 1) {
            this.findHomingTarget();
        }
        if (this.homingTarget != null && this.field_70173_aa > 5) {
            this.field_70165_t = this.field_70142_S;
            this.field_70163_u = this.field_70137_T;
            this.field_70161_v = this.field_70136_U;
            Vec3d vec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Vec3d toTarget = new Vec3d(this.homingTarget.field_70165_t - this.field_70165_t, this.homingTarget.field_70163_u + (double)(this.homingTarget.field_70131_O / 2.0f) - this.field_70163_u, this.homingTarget.field_70161_v - this.field_70161_v).func_72432_b();
            vec = vec.func_178787_e(toTarget.func_186678_a(this.homingTightness)).func_72432_b().func_186678_a(this.homingSpeed);
            this.field_70159_w = vec.field_72450_a;
            this.field_70181_x = vec.field_72448_b;
            this.field_70179_y = vec.field_72449_c;
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
        }
    }

    @Override
    public float func_70185_h() {
        return this.homingTarget == null ? 0.02f : 0.0f;
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        try {
            int targetId = data.readInt();
            this.homingTarget = this.field_70170_p.func_73045_a(targetId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeInt(this.homingTarget != null ? this.homingTarget.func_145782_y() : -1);
    }
}

