/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.item.tool.ItemGemSword;
import net.silentchaos512.gems.util.ToolHelper;

public class EnchantmentMagicDamage
extends Enchantment {
    public static final String NAME = "MagicDamage";
    public static boolean ENABLED = true;

    public EnchantmentMagicDamage() {
        super(Enchantment.Rarity.UNCOMMON, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(NAME);
    }

    public float calcDamage(int level) {
        return 1.0f + (float)Math.max(0, level - 1) / 2.0f;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (!ENABLED) {
            return true;
        }
        return stack.func_77973_b() instanceof ItemGemSword && ToolHelper.getToolTier(stack).ordinal() >= EnumMaterialTier.SUPER.ordinal() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_77326_a(Enchantment ench) {
        return !(ench instanceof EnchantmentDamage) && ench != this;
    }

    public int func_77321_a(int level) {
        return 5 + (level - 1) * 10;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 20;
    }

    public int func_77325_b() {
        return 5;
    }

    public String func_77320_a() {
        return "enchantment.silentgems:MagicDamage";
    }
}

