/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.client.gui.GuiChaosAltar;
import net.silentchaos512.gems.compat.jei.altar.AltarRecipeCategory;
import net.silentchaos512.gems.compat.jei.altar.AltarRecipeHandler;
import net.silentchaos512.gems.compat.jei.altar.AltarRecipeMaker;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.ChaosBuff;
import net.silentchaos512.gems.util.ToolHelper;

@JEIPlugin
public class SilentGemsPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;

    public void onRuntimeAvailable(IJeiRuntime runtime) {
    }

    public void register(IModRegistry reg) {
        jeiHelper = reg.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelper.getGuiHelper();
        this.doItemBlacklist(jeiHelper.getIngredientBlacklist());
        this.doRecipeRegistration(reg, guiHelper);
        this.doAddDescriptions(reg);
    }

    private void doItemBlacklist(IIngredientBlacklist list) {
        int any = Short.MAX_VALUE;
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampInverted, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampInvertedDark, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampInvertedLight, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampLit, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampLitDark, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.gemLampLitLight, 1, any));
        list.addIngredientToBlacklist((Object)new ItemStack((Block)ModBlocks.fluffyPuffPlant));
        list.addIngredientToBlacklist((Object)new ItemStack((Item)ModItems.toolRenderHelper));
        list.addIngredientToBlacklist((Object)new ItemStack((Item)ModItems.debugItem));
    }

    private void doRecipeRegistration(IModRegistry reg, IGuiHelper guiHelper) {
        reg.addRecipeCategories(new IRecipeCategory[]{new AltarRecipeCategory(guiHelper)});
        reg.addRecipeHandlers(new IRecipeHandler[]{new AltarRecipeHandler()});
        reg.addRecipes(AltarRecipeMaker.getRecipes());
        reg.addRecipes(ToolHelper.EXAMPLE_RECIPES, "minecraft.crafting");
        reg.addRecipeClickArea(GuiChaosAltar.class, 80, 34, 25, 16, new String[]{"silentgems:ChaosAltar"});
        reg.addRecipeCategoryCraftingItem(new ItemStack((Block)ModBlocks.chaosAltar), new String[]{"silentgems:ChaosAltar"});
    }

    private void doAddDescriptions(IModRegistry reg) {
        String prefix = "jei.silentgems:desc.";
        reg.addDescription(new ItemStack((Block)ModBlocks.chaosAltar), new String[]{prefix + "ChaosAltar"});
        reg.addDescription(new ItemStack((Block)ModBlocks.chaosFlowerPot), new String[]{prefix + "ChaosFlowerPot"});
        reg.addDescription(new ItemStack((Block)ModBlocks.chaosNode), new String[]{prefix + "ChaosNode"});
        reg.addDescription(new ItemStack((Block)ModBlocks.chaosPylon, 1, 0), new String[]{prefix + "ChaosPylon" + "0"});
        reg.addDescription(new ItemStack((Block)ModBlocks.chaosPylon, 1, 1), new String[]{prefix + "ChaosPylon" + "1"});
        reg.addDescription(new ItemStack((Block)ModBlocks.materialGrader), new String[]{prefix + "MaterialGrader"});
        reg.addDescription(new ItemStack((Item)ModItems.gem, 1, Short.MAX_VALUE), new String[]{prefix + "Gem"});
        reg.addDescription(new ItemStack((Item)ModItems.torchBandolier), new String[]{prefix + "TorchBandolier"});
        reg.addDescription(new ItemStack((Item)ModItems.fluffyPuffSeeds), new String[]{prefix + "FluffyPuffSeeds"});
    }

    public void registerIngredients(IModIngredientRegistration arg0) {
    }

    public void registerItemSubtypes(ISubtypeRegistry reg) {
        reg.registerSubtypeInterpreter((Item)ModItems.enchantmentToken, new ISubtypeRegistry.ISubtypeInterpreter(){

            public String getSubtypeInfo(ItemStack stack) {
                Enchantment ench = ModItems.enchantmentToken.getSingleEnchantment(stack);
                if (ench == null) {
                    return "none";
                }
                return ench.func_77320_a();
            }
        });
        reg.registerSubtypeInterpreter((Item)ModItems.chaosRune, new ISubtypeRegistry.ISubtypeInterpreter(){

            public String getSubtypeInfo(ItemStack stack) {
                ChaosBuff buff = ModItems.chaosRune.getBuff(stack);
                if (buff == null) {
                    return "none";
                }
                return buff.getKey();
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration arg0) {
    }
}

