/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.client.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.gui.GuiBurnerPylon;
import net.silentchaos512.gems.client.gui.GuiChaosAltar;
import net.silentchaos512.gems.client.gui.GuiMaterialGrader;
import net.silentchaos512.gems.client.gui.GuiQuiver;
import net.silentchaos512.gems.inventory.ContainerBurnerPylon;
import net.silentchaos512.gems.inventory.ContainerChaosAltar;
import net.silentchaos512.gems.inventory.ContainerMaterialGrader;
import net.silentchaos512.gems.inventory.ContainerQuiver;
import net.silentchaos512.gems.tile.TileChaosAltar;
import net.silentchaos512.gems.tile.TileChaosPylon;
import net.silentchaos512.gems.tile.TileMaterialGrader;

public class GuiHandlerSilentGems
implements IGuiHandler {
    public static final int ID_ALTAR = 0;
    public static final int ID_BURNER_PYLON = 1;
    public static final int ID_MATERIAL_GRADER = 2;
    public static final int ID_QUIVER = 3;

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (ID != 3 && tile == null) {
            SilentGems.logHelper.warning((Object)String.format("Missing TileEntity at %d %d %d!", x, y, z));
            return null;
        }
        switch (ID) {
            case 0: {
                if (tile instanceof TileChaosAltar) {
                    TileChaosAltar tileAltar = (TileChaosAltar)tile;
                    return new ContainerChaosAltar(player.field_71071_by, (IInventory)tileAltar);
                }
                return null;
            }
            case 1: {
                if (tile instanceof TileChaosPylon) {
                    return new ContainerBurnerPylon(player.field_71071_by, (IInventory)((TileChaosPylon)tile));
                }
                return null;
            }
            case 2: {
                if (tile instanceof TileMaterialGrader) {
                    return new ContainerMaterialGrader(player.field_71071_by, (IInventory)((TileMaterialGrader)tile));
                }
                return null;
            }
            case 3: {
                EnumHand hand = x == 1 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
                ItemStack stack = player.func_184586_b(hand);
                return new ContainerQuiver(stack, player.field_71071_by, hand);
            }
        }
        SilentGems.logHelper.warning((Object)("No GUI with ID " + ID + "!"));
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
        if (ID != 3 && tile == null) {
            SilentGems.logHelper.warning((Object)String.format("Missing TileEntity at %d %d %d!", x, y, z));
            return null;
        }
        switch (ID) {
            case 0: {
                if (tile instanceof TileChaosAltar) {
                    TileChaosAltar tileAltar = (TileChaosAltar)tile;
                    return new GuiChaosAltar(player.field_71071_by, tileAltar);
                }
                return null;
            }
            case 1: {
                if (tile instanceof TileChaosPylon) {
                    return new GuiBurnerPylon(player.field_71071_by, (TileChaosPylon)tile);
                }
                return null;
            }
            case 2: {
                if (tile instanceof TileMaterialGrader) {
                    return new GuiMaterialGrader(player.field_71071_by, (TileMaterialGrader)tile);
                }
                return null;
            }
            case 3: {
                EnumHand hand = x == 1 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
                ItemStack stack = player.func_184586_b(hand);
                return new GuiQuiver(new ContainerQuiver(stack, player.field_71071_by, hand));
            }
        }
        SilentGems.logHelper.warning((Object)("No GUI with ID " + ID + "!"));
        return null;
    }
}

