/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.BlockGemSubtypes;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.tile.TileTeleporter;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.DimensionalPosition;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.StackHelper;
import net.silentchaos512.wit.api.IWitHudInfo;

public class BlockTeleporter
extends BlockGemSubtypes
implements ITileEntityProvider,
IWitHudInfo {
    public final boolean isAnchor;

    public BlockTeleporter(String name) {
        super(name);
        this.isAnchor = true;
    }

    public BlockTeleporter(EnumGem.Set set, boolean isAnchor) {
        this(set, isAnchor, "Teleporter");
    }

    public BlockTeleporter(EnumGem.Set set, boolean isAnchor, String name) {
        super(isAnchor ? 1 : 16, set, BlockTeleporter.nameForSet(set, name), Material.field_151573_f);
        this.isAnchor = isAnchor;
        this.func_149711_c(15.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
    }

    public void addRecipes(RecipeMaker recipes) {
        if (GemsConfig.RECIPE_TELEPORTER_DISABLE) {
            return;
        }
        ItemStack[] anyTeleporter = new ItemStack[]{new ItemStack((Block)ModBlocks.teleporter, 1, Short.MAX_VALUE), new ItemStack((Block)ModBlocks.teleporterDark, 1, Short.MAX_VALUE)};
        int lastIndex = -1;
        for (int i = 0; i < this.subBlockCount; ++i) {
            EnumGem gem = this.getGem(i);
            recipes.addShapedOre(this.blockName + i, new ItemStack((Block)this, 2, i), new Object[]{"cec", " g ", "cec", Character.valueOf('c'), ModItems.craftingMaterial.chaosEssenceEnriched, Character.valueOf('e'), ModItems.craftingMaterial.enderEssence, Character.valueOf('g'), gem.getBlockOreName()});
            for (ItemStack stack : anyTeleporter) {
                recipes.addShapelessOre(this.blockName + "_" + ++lastIndex + "_recolor", new ItemStack((Block)this, 1, i), new Object[]{stack, gem.getItemOreName()});
            }
        }
    }

    @Override
    public List<String> getWitLines(IBlockState state, BlockPos pos, EntityPlayer player, boolean advanced) {
        TileEntity tile = player.field_70170_p.func_175625_s(pos);
        if (tile == null || !(tile instanceof TileTeleporter)) {
            return null;
        }
        TileTeleporter teleporter = (TileTeleporter)tile;
        DimensionalPosition destination = teleporter.getDestination();
        return Lists.newArrayList((Object[])new String[]{destination != null ? destination.toString() : "null"});
    }

    protected boolean clOnBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean holdingReturnHome;
        ItemStack heldItem = player.func_184586_b(hand);
        boolean holdingLinker = StackHelper.isValid((ItemStack)heldItem) && heldItem.func_77973_b() == ModItems.teleporterLinker;
        boolean bl = holdingReturnHome = StackHelper.isValid((ItemStack)heldItem) && heldItem.func_77973_b() == ModItems.returnHomeCharm;
        if (world.field_72995_K) {
            return holdingLinker || holdingReturnHome ? true : !this.isAnchor;
        }
        TileTeleporter tile = (TileTeleporter)world.func_175625_s(pos);
        if (tile == null) {
            SilentGems.logHelper.warning((Object)("Teleporter tile at " + pos + " not found!"));
            return false;
        }
        if (holdingLinker) {
            return tile.linkTeleporters(player, world, pos, heldItem, hand);
        }
        if (holdingReturnHome) {
            return tile.linkReturnHomeCharm(player, world, pos, heldItem, hand);
        }
        if (this.isAnchor) {
            return false;
        }
        LocalizationHelper loc = SilentGems.localizationHelper;
        if (!tile.isDestinationSet()) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)loc.getBlockSubText("Teleporter", "NoDestination", new Object[0]));
            return true;
        }
        if (!tile.isDestinationSane(player)) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)loc.getBlockSubText("Teleporter", "NotSane", new Object[0]));
            return true;
        }
        if (!tile.isDestinationSafe(player)) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)loc.getBlockSubText("Teleporter", "NotSafe", new Object[0]));
            return true;
        }
        if (!tile.isDestinationAllowedIfDumb(player)) {
            ChatHelper.sendMessage((EntityPlayer)player, (String)loc.getBlockSubText("Teleporter", "NoReceiver", new Object[0]));
            return true;
        }
        if (!tile.checkAndDrainChaos(player)) {
            return true;
        }
        tile.teleportEntityToDestination((Entity)player);
        float pitch = 0.7f + 0.3f * SilentGems.random.nextFloat();
        for (BlockPos p : new BlockPos[]{pos, tile.getDestination().toBlockPos()}) {
            world.func_184133_a(null, p, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, pitch);
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTeleporter(this.isAnchor);
    }
}

