/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.block.BlockSL;
import net.silentchaos512.lib.registry.RecipeMaker;

public class BlockMisc
extends BlockSL
implements IFuelHandler {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockMisc() {
        super(Type.values().length, "silentgems", "MiscBlock", Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(30.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)Type.CHAOS_ESSENCE)));
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    public int getBurnTime(ItemStack fuel) {
        return fuel.func_77973_b() == Item.func_150898_a((Block)this) && fuel.func_77952_i() == Type.CHAOS_COAL.ordinal() ? 10 * GemsConfig.BURN_TIME_CHAOS_COAL : 0;
    }

    public void addRecipes(RecipeMaker recipes) {
        ItemStack chaosCoal = this.getStack(Type.CHAOS_COAL, 1);
        ItemStack chaosEssence = this.getStack(Type.CHAOS_ESSENCE, 1);
        ItemStack chaosEssenceCrystallized = this.getStack(Type.CHAOS_ESSENCE_CRYSTALLIZED, 1);
        ItemStack chaosEssenceEnriched = this.getStack(Type.CHAOS_ESSENCE_ENRICHED, 1);
        recipes.addCompression("chaos_essence_block", ModItems.craftingMaterial.chaosEssence, chaosEssence, 9);
        recipes.addCompression("chaos_essence_enriched_block", ModItems.craftingMaterial.chaosEssenceEnriched, chaosEssenceEnriched, 9);
        recipes.addCompression("chaos_essence_crystallized_block", ModItems.craftingMaterial.chaosEssenceCrystallized, chaosEssenceCrystallized, 9);
        recipes.addCompression("chaos_coal_block", ModItems.craftingMaterial.chaosCoal, chaosCoal, 9);
    }

    public ItemStack getStack(Type type, int count) {
        return new ItemStack((Block)this, count, type.ordinal());
    }

    public EnumRarity getRarity(int meta) {
        switch (Type.values()[MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1))]) {
            case CHAOS_ESSENCE_CRYSTALLIZED: {
                return EnumRarity.EPIC;
            }
            case CHAOS_ESSENCE_ENRICHED: {
                return EnumRarity.RARE;
            }
        }
        return EnumRarity.COMMON;
    }

    public IBlockState func_176203_a(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1));
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        String name = this.getFullName().toLowerCase();
        for (Type type : Type.values()) {
            models.put(type.ordinal(), new ModelResourceLocation(name, "type=" + type.func_176610_l()));
        }
    }

    public static enum Type implements IStringSerializable
    {
        CHAOS_ESSENCE,
        CHAOS_ESSENCE_ENRICHED,
        CHAOS_ESSENCE_CRYSTALLIZED,
        CHAOS_COAL;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

