/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.BlockGemSubtypes;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.registry.RecipeMaker;

public class BlockGem
extends BlockGemSubtypes {
    public final boolean supercharged;

    public BlockGem(EnumGem.Set set, boolean supercharged) {
        super(set, BlockGem.nameForSet(set, "GemBlock" + (supercharged ? "Super" : "")));
        this.supercharged = supercharged;
        this.func_149711_c(supercharged ? 7.0f : 3.0f);
        this.func_149752_b(supercharged ? 6000000.0f : 30.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", supercharged ? 3 : 1);
    }

    public void addRecipes(RecipeMaker recipes) {
        for (int i = 0; i < 16; ++i) {
            EnumGem gem = this.getGem(i);
            if (this.supercharged) {
                recipes.addShapedOre(gem.name() + "_block_super", gem.getBlockSuper(), new Object[]{" g ", "gog", " g ", Character.valueOf('g'), gem.getItemSuperOreName(), Character.valueOf('o'), Blocks.field_150343_Z});
                continue;
            }
            recipes.addCompression(gem.name() + "_block", gem.getItem(), gem.getBlock(), 9);
        }
    }

    public void addOreDict() {
        for (int i = 0; i < 16; ++i) {
            EnumGem gem = this.getGem(i);
            if (this.supercharged) {
                OreDictionary.registerOre((String)gem.getBlockSuperOreName(), (ItemStack)gem.getBlockSuper());
                continue;
            }
            OreDictionary.registerOre((String)gem.getBlockOreName(), (ItemStack)gem.getBlock());
        }
    }

    public void clAddInformation(ItemStack stack, World world, List<String> list, boolean advanced) {
        String str = this.blockName.replaceFirst("Dark", "");
        list.addAll(SilentGems.localizationHelper.getBlockDescriptionLines(str));
    }

    public EnumRarity getRarity(int meta) {
        return this.supercharged ? EnumRarity.RARE : EnumRarity.COMMON;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (this.supercharged) {
            return entity instanceof EntityPlayer;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }
}

