/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.tile.TileChaosAltar;
import net.silentchaos512.lib.block.BlockContainerSL;
import net.silentchaos512.lib.registry.RecipeMaker;

public class BlockChaosAltar
extends BlockContainerSL {
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public IRecipe recipe;

    public BlockChaosAltar() {
        super(1, "silentgems", "ChaosAltar", Material.field_151573_f);
        this.func_149711_c(12.0f);
        this.func_149752_b(6000.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileChaosAltar();
    }

    public void addRecipes(RecipeMaker recipes) {
        ItemStack result = new ItemStack((Block)this);
        ItemStack chaos = ModItems.craftingMaterial.chaosEssenceEnriched;
        this.recipe = recipes.addShapedOre("chaos_altar", result, new Object[]{"rer", "dod", "ooo", Character.valueOf('e'), chaos, Character.valueOf('r'), "dustRedstone", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('d'), "gemDiamond"});
    }

    protected boolean clOnBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileChaosAltar) {
            player.openGui((Object)SilentGems.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileAltar = world.func_175625_s(pos);
        if (tileAltar != null && tileAltar instanceof TileChaosAltar) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileChaosAltar)tileAltar));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileChaosAltar) {
            TileChaosAltar altar = (TileChaosAltar)tile;
            float storedRatio = (float)altar.getCharge() / (float)altar.getMaxCharge();
            return (int)(15.0f * storedRatio);
        }
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }
}

