/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.tool;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.ArmorPartPosition;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.stats.CommonItemStats;
import net.silentchaos512.gems.api.stats.ItemStat;
import net.silentchaos512.gems.api.stats.ItemStatModifier;
import net.silentchaos512.gems.api.tool.part.ArmorPartFrame;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.api.tool.part.ToolPartRod;
import net.silentchaos512.gems.api.tool.part.ToolPartTip;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.util.ArmorHelper;
import net.silentchaos512.gems.util.ToolHelper;

public final class ToolStats {
    public static final String ID_VARIETY_BONUS = "variety_bonus";
    private final ToolPart[] parts;
    private final EnumMaterialGrade[] grades;
    public final ItemStack tool;
    public float durability = 0.0f;
    public float harvestSpeed = 0.0f;
    public float meleeDamage = 0.0f;
    public float magicDamage = 0.0f;
    public float meleeSpeed = 0.0f;
    public float chargeSpeed = 0.0f;
    public float enchantability = 0.0f;
    public float protection = 0.0f;
    public int harvestLevel = 0;

    public ToolStats(ItemStack tool) {
        this.tool = tool;
        this.parts = new ToolPart[0];
        this.grades = new EnumMaterialGrade[0];
    }

    public ToolStats(ItemStack tool, ToolPart[] parts, EnumMaterialGrade[] grades) {
        this.tool = tool;
        this.parts = parts;
        this.grades = grades;
    }

    public ToolStats(ItemStack tool, Map<ToolPart, EnumMaterialGrade> parts) {
        this.tool = tool;
        this.parts = parts.keySet().toArray(new ToolPart[0]);
        this.grades = parts.values().toArray(new EnumMaterialGrade[0]);
    }

    public ToolStats calculate() {
        if (this.parts.length == 0) {
            return this;
        }
        HashMap<ItemStat, List<ItemStatModifier>> mods = new HashMap<ItemStat, List<ItemStatModifier>>();
        for (ItemStat stat : ItemStat.ALL_STATS) {
            mods.put(stat, new ArrayList());
        }
        Set uniqueParts = Sets.newConcurrentHashSet();
        ToolPart partRod = null;
        ToolPart partTip = null;
        ToolPart partGrip = null;
        ToolPart partFrame = null;
        for (int i = 0; i < this.parts.length; ++i) {
            ToolPart part = this.parts[i];
            EnumMaterialGrade grade = this.grades[i];
            if (part instanceof ToolPartMain) {
                for (ItemStat stat : ItemStat.ALL_STATS) {
                    ItemStatModifier statModifier = part.getStatModifier(stat, grade);
                    if (statModifier == null) continue;
                    ((List)mods.get(stat)).add(statModifier);
                }
                uniqueParts.add(part);
                continue;
            }
            if (part instanceof ToolPartRod) {
                partRod = part;
                continue;
            }
            if (part instanceof ToolPartTip) {
                partTip = part;
                continue;
            }
            if (!(part instanceof ArmorPartFrame)) continue;
            partFrame = part;
        }
        int variety = MathHelper.func_76125_a((int)uniqueParts.size(), (int)1, (int)GemsConfig.VARIETY_CAP);
        float bonus = 1.0f + GemsConfig.VARIETY_BONUS * (float)(variety - 1);
        ((List)mods.get(CommonItemStats.DURABILITY)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.HARVEST_SPEED)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.MELEE_DAMAGE)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.MAGIC_DAMAGE)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.ATTACK_SPEED)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.CHARGE_SPEED)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.ENCHANTABILITY)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.ARMOR)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        ((List)mods.get(CommonItemStats.MAGIC_ARMOR)).add(new ItemStatModifier(ID_VARIETY_BONUS, bonus, ItemStatModifier.Operation.MULTIPLY));
        if (this.tool.func_77973_b() instanceof ITool) {
            ITool itool = (ITool)this.tool.func_77973_b();
            this.durability *= itool.getDurabilityMultiplier();
            this.harvestSpeed *= itool.getHarvestSpeedMultiplier();
        }
        if (partRod == null) {
            partRod = ToolHelper.getConstructionRod(this.tool);
        }
        if (partTip == null) {
            partTip = ToolHelper.getConstructionTip(this.tool);
        }
        if (partGrip == null) {
            partGrip = ToolHelper.getPart(this.tool, ToolPartPosition.ROD_GRIP);
        }
        if (partFrame == null) {
            partFrame = ArmorHelper.getPart(this.tool, ArmorPartPosition.FRAME);
        }
        for (ToolPart part : Lists.newArrayList((Object[])new ToolPart[]{partRod, partTip, partGrip, partFrame})) {
            if (part == null) continue;
            for (ItemStat stat : ItemStat.ALL_STATS) {
                ItemStatModifier statModifier = part.getStatModifier(stat, EnumMaterialGrade.NONE);
                if (statModifier == null) continue;
                ((List)mods.get(stat)).add(statModifier);
            }
        }
        this.durability = this.calcStat(CommonItemStats.DURABILITY, mods);
        this.harvestSpeed = this.calcStat(CommonItemStats.HARVEST_SPEED, mods);
        this.meleeDamage = this.calcStat(CommonItemStats.MELEE_DAMAGE, mods);
        this.magicDamage = this.calcStat(CommonItemStats.MAGIC_DAMAGE, mods);
        this.meleeSpeed = this.calcStat(CommonItemStats.ATTACK_SPEED, mods);
        this.chargeSpeed = this.calcStat(CommonItemStats.CHARGE_SPEED, mods);
        this.enchantability = this.calcStat(CommonItemStats.ENCHANTABILITY, mods);
        this.protection = this.calcStat(CommonItemStats.ARMOR, mods);
        this.harvestLevel = (int)this.calcStat(CommonItemStats.HARVEST_LEVEL, mods);
        return this;
    }

    public float calcStat(ItemStat stat, Map<ItemStat, List<ItemStatModifier>> mods) {
        return stat.compute(0.0f, (Collection<ItemStatModifier>)mods.get(stat));
    }
}

