/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.lib;

import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.lib.util.StackHelper;

public enum EnumMaterialGrade {
    NONE(0),
    E(2),
    D(4),
    C(6),
    B(8),
    A(12),
    S(16),
    SS(24),
    SSS(32);

    public static final String NBT_KEY = "SG_Grade";
    public final int bonusPercent;

    private EnumMaterialGrade(int bonusPercent) {
        this.bonusPercent = bonusPercent;
    }

    public static EnumMaterialGrade fromStack(ItemStack stack) {
        if (StackHelper.isValid((ItemStack)stack) && stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_KEY)) {
            String str = stack.func_77978_p().func_74779_i(NBT_KEY);
            return EnumMaterialGrade.fromString(str);
        }
        return NONE;
    }

    public static EnumMaterialGrade fromString(String str) {
        if (str != null) {
            for (EnumMaterialGrade grade : EnumMaterialGrade.values()) {
                if (!grade.name().equals(str)) continue;
                return grade;
            }
        }
        return NONE;
    }

    public static EnumMaterialGrade selectRandom(Random random) {
        int val = (int)(1.5 * random.nextGaussian() + 4.0);
        val = MathHelper.func_76125_a((int)val, (int)1, (int)8);
        return EnumMaterialGrade.values()[val];
    }

    public void setGradeOnStack(ItemStack stack) {
        if (StackHelper.isValid((ItemStack)stack)) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a(NBT_KEY, this.name());
        }
    }

    public String getLocalizedName() {
        return this == NONE ? SilentGems.localizationHelper.getMiscText("Grade.none", new Object[0]) : this.name();
    }
}

