/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.stats.CommonItemStats;
import net.silentchaos512.gems.compat.ScalingHealthCompat;
import net.silentchaos512.gems.compat.VeinMinerCompat;
import net.silentchaos512.gems.compat.tconstruct.TConstructGemsCompat;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.entity.ModEntities;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.init.ModPotions;
import net.silentchaos512.gems.init.ModRecipes;
import net.silentchaos512.gems.item.tool.ItemGemShield;
import net.silentchaos512.gems.lib.GemsCreativeTabs;
import net.silentchaos512.gems.lib.part.ModParts;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.proxy.GemsCommonProxy;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.gems.world.GemsGeodeWorldGenerator;
import net.silentchaos512.gems.world.GemsWorldGenerator;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.registry.IRegistrationHandler;
import net.silentchaos512.lib.registry.SRegistry;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.LogHelper;

@Mod(modid="silentgems", name="Silent's Gems", version="2.7.2", dependencies="required-after:silentlib@[2.3.1,);after:baubles;after:enderio;after:enderzoo;after:tconstruct;after:veinminer", acceptedMinecraftVersions="[1.12,1.12.2]", guiFactory="net.silentchaos512.gems.client.gui.config.GuiFactorySilentGems")
public class SilentGems {
    public static final String MODID = "silentgems";
    public static final String MODID_NBT = "SilentGems";
    public static final String MOD_NAME = "Silent's Gems";
    public static final String VERSION = "2.7.2";
    public static final String VERSION_SILENTLIB = "2.3.1";
    public static final int BUILD_NUM = 270;
    public static final String DEPENDENCIES = "required-after:silentlib@[2.3.1,);after:baubles;after:enderio;after:enderzoo;after:tconstruct;after:veinminer";
    public static final String ACCEPTED_MC_VERSIONS = "[1.12,1.12.2]";
    public static final String RESOURCE_PREFIX = "silentgems:";
    public static Random random = new Random();
    public static LogHelper logHelper = new LogHelper("Silent's Gems", 270);
    public static LocalizationHelper localizationHelper;
    public static SRegistry registry;
    @Mod.Instance(value="silentgems")
    public static SilentGems instance;
    @SidedProxy(clientSide="net.silentchaos512.gems.proxy.GemsClientProxy", serverSide="net.silentchaos512.gems.proxy.GemsCommonProxy")
    public static GemsCommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        localizationHelper = new LocalizationHelper(MODID).setReplaceAmpersand(true);
        SilentLib.instance.registerLocalizationHelperForMod(MODID, localizationHelper);
        CommonItemStats.init();
        ToolHelper.init();
        GemsConfig.INSTANCE.init(event.getSuggestedConfigurationFile());
        registry.addRegistrationHandler((IRegistrationHandler)new ModEnchantments(), Enchantment.class);
        registry.addRegistrationHandler((IRegistrationHandler)new ModBlocks(), Block.class);
        registry.addRegistrationHandler((IRegistrationHandler)new ModItems(), Item.class);
        registry.addRegistrationHandler((IRegistrationHandler)new ModPotions(), Potion.class);
        registry.addRegistrationHandler((IRegistrationHandler)new ModRecipes(), IRecipe.class);
        ModParts.init();
        SoulSkill.init();
        GemsConfig.INSTANCE.loadModuleConfigs();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GemsWorldGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GemsGeodeWorldGenerator(), (int)-10);
        FMLInterModComms.sendMessage((String)"headcrumbs", (String)"add-username", (String)"SilentChaos512");
        if (Loader.isModLoaded((String)"tconstruct") && GemsConfig.ENABLE_TIC_SUPPORT) {
            TConstructGemsCompat.preInit();
        }
        VeinMinerCompat.init();
        proxy.preInit(registry);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModEntities.init(registry);
        GemsConfig.INSTANCE.save();
        if (Loader.isModLoaded((String)"scalinghealth")) {
            ScalingHealthCompat.init();
        }
        proxy.init(registry);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(registry);
    }

    public boolean isDevBuild() {
        return false;
    }

    static {
        registry = new SRegistry(MODID, logHelper){

            public Block registerBlock(Block block, String key, ItemBlock itemBlock) {
                super.registerBlock(block, key, itemBlock);
                block.func_149647_a((CreativeTabs)GemsCreativeTabs.blocks);
                return block;
            }

            public Item registerItem(Item item, String key) {
                super.registerItem(item, key);
                if (item instanceof ITool) {
                    GemsConfig.NODE_REPAIR_WHITELIST.add(item);
                    if (!(item instanceof ItemGemShield)) {
                        item.func_77637_a((CreativeTabs)GemsCreativeTabs.tools);
                        ModItems.tools.add(item);
                    }
                } else if (item instanceof IArmor) {
                    GemsConfig.NODE_REPAIR_WHITELIST.add(item);
                    item.func_77637_a((CreativeTabs)GemsCreativeTabs.tools);
                } else {
                    item.func_77637_a((CreativeTabs)GemsCreativeTabs.materials);
                }
                return item;
            }
        };
    }
}

