/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration.mcmultipart;

import java.util.Collection;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.multipart.MultipartOcclusionHelper;
import mcmultipart.api.slot.IPartSlot;
import mod.chiselsandbits.chiseledblock.BoxType;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.ChiseledBlockPart;
import mod.chiselsandbits.integration.mcmultipart.MultiPartSlots;
import mod.chiselsandbits.interfaces.IChiseledTileContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

class MultipartContainerBuilder
implements IChiseledTileContainer {
    final IMultipartContainer targetContainer;
    final TileEntityBlockChiseled container;
    final World world;
    final BlockPos pos;

    public MultipartContainerBuilder(World w, BlockPos position, TileEntityBlockChiseled chisledBlockPart, IMultipartContainer targ) {
        this.world = w;
        this.pos = position;
        this.container = chisledBlockPart;
        this.targetContainer = targ;
    }

    @Override
    public void sendUpdate() {
        ModUtil.sendUpdate(this.world, this.pos);
    }

    @Override
    public void saveData() {
        MultipartHelper.addPart((World)this.world, (BlockPos)this.pos, (IPartSlot)MultiPartSlots.BITS, (IBlockState)ChiselsAndBits.getBlocks().getChiseledDefaultState(), (boolean)false);
        MultipartHelper.getPartTile((IBlockAccess)this.world, (BlockPos)this.pos, (IPartSlot)MultiPartSlots.BITS).ifPresent(stuff -> {
            if (stuff instanceof TileEntityBlockChiseled) {
                ((TileEntityBlockChiseled)stuff).copyFrom(this.container);
            }
        });
    }

    @Override
    public boolean isBlobOccluded(VoxelBlob blob) {
        ChiseledBlockPart part = new ChiseledBlockPart(null);
        part.setBlob(blob);
        Collection<AxisAlignedBB> selfBoxes = part.getBoxes(BoxType.OCCLUSION);
        return MultipartOcclusionHelper.testContainerBoxIntersection((IMultipartContainer)this.targetContainer, selfBoxes);
    }
}

