/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.tile;

import java.util.HashMap;
import java.util.Map;
import mrriegel.storagenetwork.data.StackWrapper;
import mrriegel.storagenetwork.helper.UtilTileEntity;
import mrriegel.storagenetwork.tile.TileConnectable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractFilterTile
extends TileConnectable {
    public static final int FILTER_SIZE = 18;
    private Map<Integer, StackWrapper> filter = new HashMap<Integer, StackWrapper>();
    private boolean ores = false;
    private boolean metas = false;
    private boolean isWhitelist;
    private int priority;
    private Direction way = Direction.BOTH;

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSettings(compound);
    }

    public void readSettings(NBTTagCompound compound) {
        this.isWhitelist = compound.func_74767_n("white");
        this.priority = compound.func_74762_e("prio");
        NBTTagList invList = compound.func_150295_c("crunchTE", 10);
        this.filter = new HashMap<Integer, StackWrapper>();
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = invList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            this.filter.put(Integer.valueOf(slot), StackWrapper.loadStackWrapperFromNBT(stackTag));
        }
        this.ores = compound.func_74767_n("ores");
        this.metas = compound.func_74767_n("metas");
        try {
            this.way = Direction.valueOf(compound.func_74779_i("way"));
        }
        catch (Exception e) {
            this.way = Direction.BOTH;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeSettings(compound);
        return compound;
    }

    public void writeSettings(NBTTagCompound compound) {
        compound.func_74757_a("white", this.isWhitelist);
        compound.func_74768_a("prio", this.priority);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < 18; ++i) {
            if (this.filter.get(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.filter.get(i).writeToNBT(stackTag);
            invList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("crunchTE", (NBTBase)invList);
        compound.func_74757_a("ores", this.ores);
        compound.func_74757_a("metas", this.metas);
        compound.func_74778_a("way", this.way.toString());
    }

    private boolean doesWrapperMatchStack(StackWrapper stackWrapper, ItemStack stack) {
        ItemStack s = stackWrapper.getStack();
        return this.ores ? UtilTileEntity.equalOreDict(stack, s) : (this.metas ? stack.func_77969_a(s) : stack.func_77973_b() == s.func_77973_b());
    }

    public boolean canTransfer(ItemStack stack, Direction way) {
        if (this.isStorage() && !this.way.match(way)) {
            return false;
        }
        if (this.isWhitelist()) {
            boolean tmp = false;
            for (StackWrapper stackWrapper : this.filter.values()) {
                if (stackWrapper == null || stackWrapper.getStack() == null || !this.doesWrapperMatchStack(stackWrapper, stack)) continue;
                tmp = true;
                break;
            }
            return tmp;
        }
        boolean tmp = true;
        for (StackWrapper stackWrapper : this.filter.values()) {
            if (stackWrapper == null || stackWrapper.getStack() == null || !this.doesWrapperMatchStack(stackWrapper, stack)) continue;
            tmp = false;
            break;
        }
        return tmp;
    }

    public abstract IItemHandler getInventory();

    public abstract BlockPos getSource();

    public abstract boolean isStorage();

    public Map<Integer, StackWrapper> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<Integer, StackWrapper> filter) {
        this.filter = filter;
    }

    public boolean getOre() {
        return this.ores;
    }

    public void setOres(boolean ores) {
        this.ores = ores;
    }

    public boolean getMeta() {
        return this.metas;
    }

    public void setMeta(boolean ores) {
        this.metas = ores;
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setWhite(boolean white) {
        this.isWhitelist = white;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Direction getWay() {
        return this.way;
    }

    public void setWay(Direction way) {
        this.way = way;
    }

    public static enum Direction {
        IN,
        OUT,
        BOTH;


        public boolean match(Direction way) {
            if (this == BOTH || way == BOTH) {
                return true;
            }
            return this == way;
        }

        public Direction next() {
            if (this == OUT) {
                return BOTH;
            }
            return OUT;
        }
    }
}

