/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.data.FilterItem;
import mrriegel.storagenetwork.data.StackWrapper;
import mrriegel.storagenetwork.master.TileMaster;
import mrriegel.storagenetwork.network.StackMessage;
import mrriegel.storagenetwork.network.StacksMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.remote.ContainerRemote;
import mrriegel.storagenetwork.remote.ItemRemote;
import mrriegel.storagenetwork.request.ContainerRequest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.ItemHandlerHelper;

public class RequestMessage
implements IMessage,
IMessageHandler<RequestMessage, IMessage> {
    int id;
    ItemStack stack;
    boolean shift;
    boolean ctrl;

    public RequestMessage() {
    }

    public RequestMessage(int id, ItemStack stack, boolean shift, boolean ctrl) {
        this.id = id;
        this.stack = stack;
        this.shift = shift;
        this.ctrl = ctrl;
    }

    public IMessage onMessage(final RequestMessage message, final MessageContext ctx) {
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        if (message.stack.func_190926_b()) {
            return null;
        }
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                TileMaster tileMaster = null;
                if (ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerRequest) {
                    ContainerRequest ctrRequest = (ContainerRequest)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    tileMaster = (TileMaster)ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(ctrRequest.tile.getMaster());
                } else if (ctx.getServerHandler().field_147369_b.field_71070_bA instanceof ContainerRemote) {
                    tileMaster = ItemRemote.getTile(ctx.getServerHandler().field_147369_b.field_71071_by.func_70448_g());
                }
                if (tileMaster == null) {
                    StorageNetwork.log("RequestMessage master is null ");
                    return;
                }
                int in = tileMaster.getAmount(new FilterItem(message.stack, true, false, true));
                StorageNetwork.log("RequestMessage.stack HUNTIN eh " + message.stack + " message.id = " + message.id);
                int sizeRequested = Math.max(message.id == 0 ? message.stack.func_77976_d() : (message.ctrl ? 1 : Math.min(message.stack.func_77976_d() / 2, in / 2)), 1);
                ItemStack stack = tileMaster.request(new FilterItem(message.stack, true, false, true), sizeRequested, false);
                StorageNetwork.log("!RequestMessage AFTER filter " + stack + "? size=" + sizeRequested);
                if (stack.func_190926_b()) {
                    StorageNetwork.log("!RequestMessage try again with nbt false");
                    stack = tileMaster.request(new FilterItem(message.stack, true, false, false), sizeRequested, false);
                }
                if (!stack.func_190926_b()) {
                    if (message.shift) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)ctx.getServerHandler().field_147369_b, (ItemStack)stack);
                    } else {
                        ctx.getServerHandler().field_147369_b.field_71071_by.func_70437_b(stack);
                        PacketRegistry.INSTANCE.sendTo((IMessage)new StackMessage(stack), ctx.getServerHandler().field_147369_b);
                        StorageNetwork.log("RequestMessage message sStack Single??? " + stack + " isCLIENT " + tileMaster.func_145831_w().field_72995_K);
                    }
                } else {
                    StorageNetwork.log("RequestMessage how did we get empty stack  " + stack + " isCLIENT " + tileMaster.func_145831_w().field_72995_K);
                }
                List<StackWrapper> list = tileMaster.getStacks();
                PacketRegistry.INSTANCE.sendTo((IMessage)new StacksMessage(list, tileMaster.getCraftableStacks(list)), ctx.getServerHandler().field_147369_b);
                ctx.getServerHandler().field_147369_b.field_71070_bA.func_75142_b();
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.shift = buf.readBoolean();
        this.ctrl = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeBoolean(this.shift);
        buf.writeBoolean(this.ctrl);
    }
}

