/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import mrriegel.storagenetwork.cable.ContainerCable;
import mrriegel.storagenetwork.cable.TileCable;
import mrriegel.storagenetwork.data.StackWrapper;
import mrriegel.storagenetwork.helper.UtilTileEntity;
import mrriegel.storagenetwork.tile.AbstractFilterTile;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class CableDataMessage
implements IMessage,
IMessageHandler<CableDataMessage, IMessage> {
    public static final int TOGGLE_WAY = 6;
    public static final int IMPORT_FILTER = 5;
    public static final int TOGGLE_WHITELIST = 3;
    public static final int PRIORITY_UP = 1;
    public static final int PRIORITY_DOWN = 0;
    public static final int TOGGLE_MODE = 4;
    int id;
    BlockPos pos;

    public CableDataMessage() {
    }

    public CableDataMessage(int id, BlockPos pos) {
        this.id = id;
        this.pos = pos;
    }

    public IMessage onMessage(final CableDataMessage message, final MessageContext ctx) {
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                TileEntity t = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.pos);
                if (t instanceof AbstractFilterTile) {
                    AbstractFilterTile tile = (AbstractFilterTile)t;
                    switch (message.id) {
                        case 0: {
                            tile.setPriority(tile.getPriority() - 1);
                            break;
                        }
                        case 1: {
                            tile.setPriority(tile.getPriority() + 1);
                            break;
                        }
                        case 3: {
                            tile.setWhite(!tile.isWhitelist());
                            break;
                        }
                        case 4: {
                            if (!(tile instanceof TileCable)) break;
                            ((TileCable)tile).setMode(!((TileCable)tile).isMode());
                            break;
                        }
                        case 5: {
                            int i;
                            if (tile.getInventory() == null) break;
                            IItemHandler inv = tile.getInventory();
                            int index = 0;
                            tile.setWhite(true);
                            int size = 18;
                            for (i = 0; i < size; ++i) {
                                tile.getFilter().put(i, null);
                            }
                            for (i = 0; i < inv.getSlots() && index < size; ++i) {
                                ItemStack s = inv.getStackInSlot(i);
                                if (s == null || s.func_190926_b() || new ContainerCable(tile, ctx.getServerHandler().field_147369_b.field_71071_by).isInFilter(new StackWrapper(s, 1))) continue;
                                tile.getFilter().put(index, new StackWrapper(s, 1));
                                ++index;
                            }
                            break;
                        }
                        case 6: {
                            tile.setWay(tile.getWay().next());
                        }
                    }
                    tile.func_70296_d();
                }
                UtilTileEntity.updateTile(t.func_145831_w(), t.func_174877_v());
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.id = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.id);
    }
}

