/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import mrriegel.storagenetwork.StorageNetwork;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class UtilTileEntity {
    private static final Map<String, String> modNamesForIds = new HashMap<String, String>();

    public static void init() {
        Map modMap = Loader.instance().getIndexedModList();
        for (Map.Entry modEntry : modMap.entrySet()) {
            String lowercaseId = ((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH);
            String modName = ((ModContainer)modEntry.getValue()).getName();
            modNamesForIds.put(lowercaseId, modName);
        }
    }

    @Nonnull
    public static String getModNameForItem(@Nonnull Object object) {
        ResourceLocation itemResourceLocation;
        if (object instanceof Item) {
            itemResourceLocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)((Item)object));
        } else if (object instanceof Block) {
            itemResourceLocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)((Block)object));
        } else {
            return null;
        }
        String modId = itemResourceLocation.func_110624_b();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = modNamesForIds.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            modNamesForIds.put(lowercaseModId, modName);
        }
        return modName;
    }

    public static boolean equalOreDict(ItemStack a, ItemStack b) {
        int[] ar = OreDictionary.getOreIDs((ItemStack)a);
        int[] br = OreDictionary.getOreIDs((ItemStack)b);
        for (int i = 0; i < ar.length; ++i) {
            for (int j = 0; j < br.length; ++j) {
                if (ar[i] != br[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> boolean contains(List<E> list, E e, Comparator<? super E> c) {
        for (E a : list) {
            if (c.compare(a, e) != 0) continue;
            return true;
        }
        return false;
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        if (stack == null || stack.func_190926_b() || worldIn.field_72995_K) {
            return;
        }
        float f = 0.1f;
        float f1 = 0.8f;
        float f2 = 0.1f;
        EntityItem entityitem = new EntityItem(worldIn, x + (double)f, y + (double)f1, z + (double)f2, stack);
        worldIn.func_72838_d((Entity)entityitem);
    }

    public static List<BlockPos> getSides(BlockPos pos) {
        ArrayList lis = Lists.newArrayList();
        for (EnumFacing face : EnumFacing.values()) {
            lis.add(pos.func_177972_a(face));
        }
        return lis;
    }

    public static void updateTile(World world, BlockPos pos) {
        if (world == null || world.field_72995_K || world.func_175625_s(pos) == null || !world.func_175726_f(pos).func_177410_o()) {
            return;
        }
        WorldServer w = (WorldServer)world;
        for (EntityPlayer p : w.field_73010_i) {
            if (!(p.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < 32.0)) continue;
            try {
                ((EntityPlayerMP)p).field_71135_a.func_147359_a((Packet)world.func_175625_s(pos).func_189518_D_());
                world.func_175646_b(pos, world.func_175625_s(pos));
            }
            catch (Error e) {
                StorageNetwork.instance.logger.error("Update Tile error", (Throwable)e);
            }
        }
    }
}

