/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.cable;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mrriegel.storagenetwork.cable.BlockCable;
import mrriegel.storagenetwork.data.FilterItem;
import mrriegel.storagenetwork.helper.UtilInventory;
import mrriegel.storagenetwork.master.TileMaster;
import mrriegel.storagenetwork.registry.ModBlocks;
import mrriegel.storagenetwork.tile.AbstractFilterTile;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class TileCable
extends AbstractFilterTile {
    private BlockPos connectedInventory;
    private EnumFacing inventoryFace;
    private NonNullList<ItemStack> upgrades = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private boolean mode = true;
    private int limit = 0;
    public BlockCable.EnumConnectType north;
    public BlockCable.EnumConnectType south;
    public BlockCable.EnumConnectType east;
    public BlockCable.EnumConnectType west;
    public BlockCable.EnumConnectType up;
    public BlockCable.EnumConnectType down;
    ItemStack stack = null;

    public TileCable() {
        this.setOres(false);
        this.setMeta(true);
    }

    public int getUpgradesOfType(int num) {
        int res = 0;
        for (ItemStack s : this.upgrades) {
            if (s == null || s.func_190926_b() || s.func_77952_i() != num) continue;
            res += s.func_190916_E();
        }
        return res;
    }

    public boolean isUpgradeable() {
        CableKind kind = this.getKind();
        return kind == CableKind.exKabel || kind == CableKind.imKabel;
    }

    public static CableKind getKind(Block b) {
        if (b == ModBlocks.kabel) {
            return CableKind.kabel;
        }
        if (b == ModBlocks.exKabel) {
            return CableKind.exKabel;
        }
        if (b == ModBlocks.imKabel) {
            return CableKind.imKabel;
        }
        if (b == ModBlocks.storageKabel) {
            return CableKind.storageKabel;
        }
        return null;
    }

    public Map<EnumFacing, BlockCable.EnumConnectType> getConnects() {
        HashMap map = Maps.newHashMap();
        map.put(EnumFacing.NORTH, this.north);
        map.put(EnumFacing.SOUTH, this.south);
        map.put(EnumFacing.EAST, this.east);
        map.put(EnumFacing.WEST, this.west);
        map.put(EnumFacing.UP, this.up);
        map.put(EnumFacing.DOWN, this.down);
        return map;
    }

    public void setConnects(Map<EnumFacing, BlockCable.EnumConnectType> map) {
        this.north = map.get(EnumFacing.NORTH);
        this.south = map.get(EnumFacing.SOUTH);
        this.east = map.get(EnumFacing.EAST);
        this.west = map.get(EnumFacing.WEST);
        this.up = map.get(EnumFacing.UP);
        this.down = map.get(EnumFacing.DOWN);
    }

    public boolean doesPassOperationFilterLimit() {
        if (this.getUpgradesOfType(1) < 1) {
            return true;
        }
        TileMaster m = (TileMaster)this.field_145850_b.func_175625_s(this.getMaster());
        if (this.getOperationStack() == null || this.getOperationStack().func_190926_b()) {
            return true;
        }
        int amount = m.getAmount(new FilterItem(this.getOperationStack()));
        if (this.isMode()) {
            return amount > this.getLimit();
        }
        return amount <= this.getLimit();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.connectedInventory = (BlockPos)new Gson().fromJson(compound.func_74779_i("connectedInventory"), new TypeToken<BlockPos>(){}.getType());
        this.inventoryFace = EnumFacing.func_176739_a((String)compound.func_74779_i("inventoryFace"));
        this.mode = compound.func_74767_n("mode");
        this.limit = compound.func_74762_e("limit");
        this.stack = compound.func_150297_b("stack", 10) ? new ItemStack(compound.func_74775_l("stack")) : null;
        if (compound.func_74764_b("north")) {
            this.north = BlockCable.EnumConnectType.valueOf(compound.func_74779_i("north"));
        }
        if (compound.func_74764_b("south")) {
            this.south = BlockCable.EnumConnectType.valueOf(compound.func_74779_i("south"));
        }
        if (compound.func_74764_b("east")) {
            this.east = BlockCable.EnumConnectType.valueOf(compound.func_74779_i("east"));
        }
        if (compound.func_74764_b("west")) {
            this.west = BlockCable.EnumConnectType.valueOf(compound.func_74779_i("west"));
        }
        if (compound.func_74764_b("up")) {
            this.up = BlockCable.EnumConnectType.valueOf(compound.func_74779_i("up"));
        }
        if (compound.func_74764_b("down")) {
            this.down = BlockCable.EnumConnectType.valueOf(compound.func_74779_i("down"));
        }
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.upgrades = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= 4) continue;
            this.upgrades.set(j, (Object)new ItemStack(nbttagcompound));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("connectedInventory", new Gson().toJson((Object)this.connectedInventory));
        if (this.inventoryFace != null) {
            compound.func_74778_a("inventoryFace", this.inventoryFace.toString());
        }
        compound.func_74757_a("mode", this.mode);
        compound.func_74768_a("limit", this.limit);
        if (this.stack != null) {
            compound.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        }
        if (this.north != null) {
            compound.func_74778_a("north", this.north.toString());
        }
        if (this.south != null) {
            compound.func_74778_a("south", this.south.toString());
        }
        if (this.east != null) {
            compound.func_74778_a("east", this.east.toString());
        }
        if (this.west != null) {
            compound.func_74778_a("west", this.west.toString());
        }
        if (this.up != null) {
            compound.func_74778_a("up", this.up.toString());
        }
        if (this.down != null) {
            compound.func_74778_a("down", this.down.toString());
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.upgrades.size(); ++i) {
            if (this.upgrades.get(i) == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.upgrades.get(i)).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        return compound;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtention = 1.0;
        AxisAlignedBB bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtention, (double)this.field_174879_c.func_177956_o() - renderExtention, (double)this.field_174879_c.func_177952_p() - renderExtention, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtention, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtention, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtention);
        return bb;
    }

    public CableKind getKind() {
        if (this.field_145850_b == null) {
            return null;
        }
        return TileCable.getKind(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
    }

    public BlockPos getConnectedInventory() {
        return this.connectedInventory;
    }

    public void setConnectedInventory(BlockPos connectedInventory) {
        this.connectedInventory = connectedInventory;
    }

    public EnumFacing getInventoryFace() {
        return this.inventoryFace;
    }

    public void setInventoryFace(EnumFacing inventoryFace) {
        this.inventoryFace = inventoryFace;
    }

    public List<ItemStack> getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(List<ItemStack> upgrades) {
        upgrades = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        int i = 0;
        for (ItemStack s : upgrades) {
            if (s != null && !s.func_190926_b()) {
                this.upgrades.set(i, (Object)s);
            }
            ++i;
        }
    }

    public boolean isMode() {
        return this.mode;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public ItemStack getOperationStack() {
        return this.stack;
    }

    public void setOperationStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public IItemHandler getInventory() {
        if (this.getConnectedInventory() != null) {
            return UtilInventory.getItemHandler(this.field_145850_b.func_175625_s(this.getConnectedInventory()), this.inventoryFace.func_176734_d());
        }
        return null;
    }

    @Override
    public BlockPos getSource() {
        return this.getConnectedInventory();
    }

    @Override
    public boolean isStorage() {
        return this.getKind() == CableKind.storageKabel;
    }

    public static enum CableKind {
        kabel,
        exKabel,
        imKabel,
        storageKabel;

    }
}

