/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.cable;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import mrriegel.storagenetwork.cable.ContainerCable;
import mrriegel.storagenetwork.cable.TileCable;
import mrriegel.storagenetwork.data.StackWrapper;
import mrriegel.storagenetwork.gui.GuiContainerBase;
import mrriegel.storagenetwork.network.CableDataMessage;
import mrriegel.storagenetwork.network.FilterMessage;
import mrriegel.storagenetwork.network.LimitMessage;
import mrriegel.storagenetwork.registry.ModBlocks;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.tile.AbstractFilterTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiCable
extends GuiContainerBase {
    private static final int TEXTBOX_WIDTH = 26;
    private ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable.png");
    TileCable.CableKind kind;
    Button btnPlus;
    Button btnMinus;
    Button btnWhite;
    Button btnOperationToggle;
    Button btnImport;
    Button btnInputOutputStorage;
    AbstractFilterTile tile;
    private GuiTextField searchBar;
    List<GuiContainerBase.ItemSlot> list;
    GuiContainerBase.ItemSlot operation;
    private GuiCheckBox checkOre;
    private GuiCheckBox checkMeta;

    public GuiCable(ContainerCable inventorySlotsIn) {
        super(inventorySlotsIn);
        this.field_146999_f = 176;
        this.field_147000_g = 171;
        this.tile = inventorySlotsIn.tile;
        if (this.tile instanceof TileCable) {
            this.kind = ((TileCable)this.tile).getKind();
        }
        this.list = Lists.newArrayList();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        this.drawTooltips(mouseX, mouseY);
    }

    public void func_146278_c(int tint) {
        super.func_146278_c(tint);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int ii;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int ii2 = 0; ii2 < 9; ++ii2) {
            for (int jj = 0; jj < 2; ++jj) {
                this.func_73729_b(i + 7 + ii2 * 18, j + 25 + 18 * jj, 176, 34, 18, 18);
            }
        }
        if (this.tile instanceof TileCable) {
            TileCable cable = (TileCable)this.tile;
            if (cable.isUpgradeable()) {
                for (ii = 0; ii < 4; ++ii) {
                    this.func_73729_b(i + 97 + ii * 18, j + 5, 176, 34, 18, 18);
                }
            }
            if (cable.getUpgradesOfType(1) >= 1 && this.btnOperationToggle != null) {
                this.btnOperationToggle.field_146124_l = true;
                this.btnOperationToggle.field_146125_m = true;
                this.field_146297_k.func_110434_K().func_110577_a(this.texture);
                this.func_73729_b(i + 7, j + 65, 176, 34, 18, 18);
                this.func_73729_b(i + 50, j + 67, 0, 171, 26, 12);
                this.searchBar.func_146194_f();
            } else if (this.btnOperationToggle != null) {
                this.btnOperationToggle.field_146124_l = false;
                this.btnOperationToggle.field_146125_m = false;
            }
        }
        this.list = Lists.newArrayList();
        for (int jj = 0; jj < 2; ++jj) {
            for (ii = 0; ii < 9; ++ii) {
                int num;
                int index = ii + 9 * jj;
                StackWrapper wrap = this.tile.getFilter().get(index);
                ItemStack s = wrap == null ? null : wrap.getStack();
                int n = num = wrap == null ? 0 : wrap.getSize();
                boolean numShow = this.tile instanceof TileCable ? ((TileCable)this.tile).getUpgradesOfType(3) > 0 : false;
                this.list.add(new GuiContainerBase.ItemSlot(this, s, this.field_147003_i + 8 + ii * 18, this.field_147009_r + 26 + jj * 18, num, this.field_147003_i, this.field_147009_r, numShow, true, false, true));
            }
        }
        for (GuiContainerBase.ItemSlot s : this.list) {
            s.drawSlot(mouseX, mouseY);
        }
        if (this.tile instanceof TileCable && ((TileCable)this.tile).getUpgradesOfType(1) >= 1) {
            this.operation.drawSlot(mouseX, mouseY);
        }
        this.field_146289_q.func_78276_b(String.valueOf(this.tile.getPriority()), this.field_147003_i + 30 - this.field_146289_q.func_78256_a(String.valueOf(this.tile.getPriority())) / 2, this.field_147009_r + 10, 0x404040);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    private void drawTooltips(int mouseX, int mouseY) {
        String s;
        for (GuiContainerBase.ItemSlot s2 : this.list) {
            if (s2 == null || s2.stack == null || s2.stack.func_190926_b() || !s2.isMouseOverSlot(mouseX, mouseY)) continue;
            this.func_146285_a(s2.stack, mouseX, mouseY);
        }
        if (this.tile instanceof TileCable && ((TileCable)this.tile).getUpgradesOfType(1) >= 1) {
            this.operation.drawTooltip(mouseX, mouseY);
        }
        if (this.btnImport != null && this.btnImport.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.gui.import", (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.btnInputOutputStorage != null && this.btnInputOutputStorage.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)("gui.storagenetwork.fil.tooltip_" + this.tile.getWay().toString()), (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (mouseX > this.field_147003_i + 20 && mouseX < this.field_147003_i + 50 && mouseY > this.field_147009_r + 2 && mouseY < this.field_147009_r + 30) {
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.priority", (Object[])new Object[0])}), mouseX, mouseY, this.field_146289_q);
        }
        if (this.btnWhite != null && this.btnWhite.func_146115_a()) {
            s = this.tile.isWhitelist() ? I18n.func_135052_a((String)"gui.storagenetwork.gui.whitelist", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.storagenetwork.gui.blacklist", (Object[])new Object[0]);
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{s}), mouseX, mouseY, this.field_146289_q);
        }
        if (this.btnPlus != null && this.btnPlus.func_146115_a()) {
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.priority.up", (Object[])new Object[0])}), mouseX, mouseY, this.field_146289_q);
        }
        if (this.btnMinus != null && this.btnMinus.func_146115_a()) {
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.priority.down", (Object[])new Object[0])}), mouseX, mouseY, this.field_146289_q);
        }
        if (this.btnOperationToggle != null && this.btnOperationToggle.func_146115_a()) {
            s = I18n.func_135052_a((String)"gui.storagenetwork.operate.tooltip", (Object[])new Object[]{I18n.func_135052_a((String)("gui.storagenetwork.operate.tooltip." + (((TileCable)this.tile).isMode() ? "more" : "less")), (Object[])new Object[0]), ((TileCable)this.tile).getLimit(), ((TileCable)this.tile).getOperationStack() != null ? ((TileCable)this.tile).getOperationStack().func_82833_r() : "Items"});
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{s}), mouseX, mouseY, this.field_146289_q);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.btnMinus = new Button(0, this.field_147003_i + 6, this.field_147009_r + 5, "-");
        this.func_189646_b(this.btnMinus);
        this.btnPlus = new Button(1, this.field_147003_i + 37, this.field_147009_r + 5, "+");
        this.func_189646_b(this.btnPlus);
        this.btnImport = new Button(5, this.field_147003_i + 78, this.field_147009_r + 5, "I");
        this.func_189646_b(this.btnImport);
        this.btnWhite = new Button(3, this.field_147003_i + 58, this.field_147009_r + 5, "");
        this.func_189646_b(this.btnWhite);
        boolean bl = this.btnWhite.field_146125_m = this.tile.func_145838_q() != ModBlocks.exKabel;
        if (this.tile.isStorage()) {
            this.btnInputOutputStorage = new Button(6, this.field_147003_i + 115, this.field_147009_r + 5, "");
            this.func_189646_b(this.btnInputOutputStorage);
        }
        if (!this.tile.isStorage() && this.tile instanceof TileCable) {
            TileCable cable = (TileCable)this.tile;
            Keyboard.enableRepeatEvents((boolean)true);
            this.searchBar = new GuiTextField(99, this.field_146289_q, this.field_147003_i + 54, this.field_147009_r + 69, 26, this.field_146289_q.field_78288_b);
            this.searchBar.func_146203_f(3);
            this.searchBar.func_146185_a(false);
            this.searchBar.func_146189_e(true);
            this.searchBar.func_146193_g(0xFFFFFF);
            this.searchBar.func_146205_d(false);
            this.searchBar.func_146195_b(true);
            this.searchBar.func_146180_a(cable.getLimit() + "");
            this.searchBar.field_146218_h = 20;
            this.btnOperationToggle = new Button(4, this.field_147003_i + 28, this.field_147009_r + 66, "");
            this.func_189646_b(this.btnOperationToggle);
            this.operation = new GuiContainerBase.ItemSlot(this, cable.getOperationStack(), this.field_147003_i + 8, this.field_147009_r + 66, 1, this.field_147003_i, this.field_147009_r, false, true, false, true);
            this.checkOre = new GuiCheckBox(10, this.field_147003_i + 78, this.field_147009_r + 64, I18n.func_135052_a((String)"gui.storagenetwork.checkbox.ore", (Object[])new Object[0]), true);
            this.checkOre.setIsChecked(this.tile.getOre());
            this.func_189646_b((GuiButton)this.checkOre);
            this.checkMeta = new GuiCheckBox(11, this.field_147003_i + 78, this.field_147009_r + 76, I18n.func_135052_a((String)"gui.storagenetwork.checkbox.meta", (Object[])new Object[0]), true);
            this.checkMeta.setIsChecked(this.tile.getMeta());
            this.func_189646_b((GuiButton)this.checkMeta);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.operation != null && this.operation.isMouseOverSlot(mouseX, mouseY) && ((TileCable)this.tile).getUpgradesOfType(1) >= 1) {
            ((TileCable)this.tile).setOperationStack(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
            this.operation.stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            int num = this.searchBar.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.searchBar.func_146179_b());
            PacketRegistry.INSTANCE.sendToServer((IMessage)new LimitMessage(num, this.tile.func_174877_v(), this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()));
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            GuiContainerBase.ItemSlot e = this.list.get(i);
            if (!e.isMouseOverSlot(mouseX, mouseY)) continue;
            ContainerCable con = (ContainerCable)this.field_147002_h;
            StackWrapper x = con.tile.getFilter().get(i);
            if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() != null) {
                if (!con.isInFilter(new StackWrapper(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), 1))) {
                    con.tile.getFilter().put(i, new StackWrapper(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190916_E()));
                }
            } else if (x != null) {
                if (mouseButton == 0) {
                    x.setSize(x.getSize() + (GuiCable.func_146272_n() ? 10 : 1));
                } else if (mouseButton == 1) {
                    x.setSize(x.getSize() - (GuiCable.func_146272_n() ? 10 : 1));
                } else if (mouseButton == 2) {
                    con.tile.getFilter().put(i, null);
                }
                if (x != null && x.getSize() <= 0) {
                    con.tile.getFilter().put(i, null);
                }
            }
            con.slotChanged();
            PacketRegistry.INSTANCE.sendToServer((IMessage)new FilterMessage(i, this.tile.getFilter().get(i), this.tile.getOre(), this.tile.getMeta()));
            break;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k, this.tile.func_174877_v()));
        if (this.btnMinus != null && button.field_146127_k == this.btnMinus.field_146127_k) {
            this.tile.setPriority(this.tile.getPriority() - 1);
        } else if (this.btnPlus != null && button.field_146127_k == this.btnPlus.field_146127_k) {
            this.tile.setPriority(this.tile.getPriority() + 1);
        } else if (this.btnWhite != null && button.field_146127_k == this.btnWhite.field_146127_k) {
            this.tile.setWhite(!this.tile.isWhitelist());
        } else if (this.btnOperationToggle != null && button.field_146127_k == this.btnOperationToggle.field_146127_k) {
            if (this.tile instanceof TileCable) {
                ((TileCable)this.tile).setMode(!((TileCable)this.tile).isMode());
            }
        } else if (this.checkMeta != null && this.checkOre != null && (button.field_146127_k == this.checkMeta.field_146127_k || button.field_146127_k == this.checkOre.field_146127_k)) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new FilterMessage(-1, null, this.checkOre.isChecked(), this.checkMeta.isChecked()));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!(this.tile instanceof TileCable)) {
            super.func_73869_a(typedChar, keyCode);
            return;
        }
        if (!this.func_146983_a(keyCode)) {
            Keyboard.enableRepeatEvents((boolean)true);
            String s = "";
            if (((TileCable)this.tile).getUpgradesOfType(1) >= 1) {
                s = this.searchBar.func_146179_b();
            }
            if (((TileCable)this.tile).getUpgradesOfType(1) >= 1 && this.searchBar.func_146201_a(typedChar, keyCode)) {
                if (!StringUtils.isNumeric((CharSequence)this.searchBar.func_146179_b()) && !this.searchBar.func_146179_b().isEmpty()) {
                    this.searchBar.func_146180_a(s);
                }
                int num = 0;
                try {
                    num = this.searchBar.func_146179_b().isEmpty() ? 0 : Integer.valueOf(this.searchBar.func_146179_b());
                }
                catch (Exception e) {
                    this.searchBar.func_146180_a("0");
                }
                ((TileCable)this.tile).setLimit(num);
                PacketRegistry.INSTANCE.sendToServer((IMessage)new LimitMessage(num, this.tile.func_174877_v(), this.operation.stack));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    class Button
    extends GuiButton {
        public Button(int id, int x, int y, String z) {
            super(id, x, y, 16, 16, z);
        }

        public void func_191745_a(Minecraft mcc, int x, int y, float p) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mcc.field_71466_p;
                mcc.func_110434_K().func_110577_a(GuiCable.this.texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 160 + 16 * k, 52, 16, 16);
                if (this.field_146127_k == 3) {
                    if (GuiCable.this.tile.isWhitelist()) {
                        this.func_73729_b(this.field_146128_h + 1, this.field_146129_i + 3, 176, 83, 13, 10);
                    } else {
                        this.func_73729_b(this.field_146128_h + 1, this.field_146129_i + 3, 190, 83, 13, 10);
                    }
                }
                if (this.field_146127_k == 4) {
                    this.field_146126_j = ((TileCable)GuiCable.this.tile).isMode() ? ">" : "<";
                }
                if (this.field_146127_k == 6) {
                    this.func_73729_b(this.field_146128_h + 2, this.field_146129_i + 2, 176 + GuiCable.this.tile.getWay().ordinal() * 12, 114, 12, 12);
                }
                this.func_146119_b(mcc, x, y);
                int l = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    l = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }
}

